# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.rdf


class URIs(object):
    """
    Const Class

    Constants to specify some well-known URIs.
    
    These constants are for use with URI.createKnown().
    
    **since**
    
        OOo 3.2

    See Also:
        `API URIs <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1rdf_1_1URIs.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.rdf'
    __ooo_full_ns__: str = 'com.sun.star.rdf.URIs'
    __ooo_type_name__: str = 'const'

    XSD_NCNAME = 1
    """
    http://www.w3.org/2001/XMLSchema-datatypes#NCName
    """
    XSD_STRING = 2
    """
    http://www.w3.org/2001/XMLSchema-datatypes#string
    """
    XSD_NORMALIZEDSTRING = 3
    """
    http://www.w3.org/2001/XMLSchema-datatypes#normalizedString
    """
    XSD_BOOLEAN = 4
    """
    http://www.w3.org/2001/XMLSchema-datatypes#boolean
    """
    XSD_DECIMAL = 5
    """
    http://www.w3.org/2001/XMLSchema-datatypes#decimal
    """
    XSD_FLOAT = 6
    """
    http://www.w3.org/2001/XMLSchema-datatypes#float
    """
    XSD_DOUBLE = 7
    """
    http://www.w3.org/2001/XMLSchema-datatypes#double
    """
    XSD_INTEGER = 8
    """
    http://www.w3.org/2001/XMLSchema-datatypes#integer
    """
    XSD_NONNEGATIVEINTEGER = 9
    """
    http://www.w3.org/2001/XMLSchema-datatypes#nonNegativeInteger
    """
    XSD_POSITIVEINTEGER = 10
    """
    http://www.w3.org/2001/XMLSchema-datatypes#positiveInteger
    """
    XSD_NONPOSITIVEINTEGER = 11
    """
    http://www.w3.org/2001/XMLSchema-datatypes#nonPositiveInteger
    """
    XSD_NEGATIVEINTEGER = 12
    """
    http://www.w3.org/2001/XMLSchema-datatypes#negativeInteger
    """
    XSD_LONG = 13
    """
    http://www.w3.org/2001/XMLSchema-datatypes#long
    """
    XSD_INT = 14
    """
    http://www.w3.org/2001/XMLSchema-datatypes#int
    """
    XSD_SHORT = 15
    """
    http://www.w3.org/2001/XMLSchema-datatypes#short
    """
    XSD_BYTE = 16
    """
    http://www.w3.org/2001/XMLSchema-datatypes#byte
    """
    XSD_UNSIGNEDLONG = 17
    """
    http://www.w3.org/2001/XMLSchema-datatypes#unsignedLong
    """
    XSD_UNSIGNEDINT = 18
    """
    http://www.w3.org/2001/XMLSchema-datatypes#unsignedInt
    """
    XSD_UNSIGNEDSHORT = 19
    """
    http://www.w3.org/2001/XMLSchema-datatypes#unsignedShort
    """
    XSD_UNSIGNEDBYTE = 20
    """
    http://www.w3.org/2001/XMLSchema-datatypes#unsignedByte
    """
    XSD_HEXBINARY = 21
    """
    http://www.w3.org/2001/XMLSchema-datatypes#hexBinary
    """
    XSD_BASE64BINARY = 22
    """
    http://www.w3.org/2001/XMLSchema-datatypes#base64Binary
    """
    XSD_DATETIME = 23
    """
    http://www.w3.org/2001/XMLSchema-datatypes#dateTime
    """
    XSD_TIME = 24
    """
    http://www.w3.org/2001/XMLSchema-datatypes#time
    """
    XSD_DATE = 25
    """
    http://www.w3.org/2001/XMLSchema-datatypes#date
    """
    XSD_GYEARMONTH = 26
    """
    http://www.w3.org/2001/XMLSchema-datatypes#gYearMonth
    """
    XSD_GYEAR = 27
    """
    http://www.w3.org/2001/XMLSchema-datatypes#gYear
    """
    XSD_GMONTHDAY = 28
    """
    http://www.w3.org/2001/XMLSchema-datatypes#gMonthDay
    """
    XSD_GDAY = 29
    """
    http://www.w3.org/2001/XMLSchema-datatypes#gDay
    """
    XSD_GMONTH = 30
    """
    http://www.w3.org/2001/XMLSchema-datatypes#gMonth
    """
    XSD_ANYURI = 31
    """
    http://www.w3.org/2001/XMLSchema-datatypes#anyURI
    """
    XSD_TOKEN = 32
    """
    http://www.w3.org/2001/XMLSchema-datatypes#token
    """
    XSD_LANGUAGE = 33
    """
    http://www.w3.org/2001/XMLSchema-datatypes#language
    """
    XSD_NMTOKEN = 34
    """
    http://www.w3.org/2001/XMLSchema-datatypes#NMTOKEN
    """
    XSD_NAME = 35
    """
    http://www.w3.org/2001/XMLSchema-datatypes#Name
    """
    XSD_DURATION = 36
    """
    http://www.w3.org/2001/XMLSchema-datatypes#duration
    """
    XSD_QNAME = 37
    """
    http://www.w3.org/2001/XMLSchema-datatypes#QName
    """
    XSD_NOTATION = 38
    """
    http://www.w3.org/2001/XMLSchema-datatypes#NOTATION
    """
    XSD_NMTOKENS = 39
    """
    http://www.w3.org/2001/XMLSchema-datatypes#NMTOKENS
    """
    XSD_ID = 40
    """
    http://www.w3.org/2001/XMLSchema-datatypes#ID
    """
    XSD_IDREF = 41
    """
    http://www.w3.org/2001/XMLSchema-datatypes#IDREF
    """
    XSD_IDREFS = 42
    """
    http://www.w3.org/2001/XMLSchema-datatypes#IDREFS
    """
    XSD_ENTITY = 43
    """
    http://www.w3.org/2001/XMLSchema-datatypes#ENTITY
    """
    XSD_ENTITIES = 44
    """
    http://www.w3.org/2001/XMLSchema-datatypes#ENTITIES
    """
    RDF_TYPE = 1000
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#type
    """
    RDF_SUBJECT = 1001
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#subject
    """
    RDF_PREDICATE = 1002
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate
    """
    RDF_OBJECT = 1003
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#object
    """
    RDF_PROPERTY = 1004
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#Property
    """
    RDF_STATEMENT = 1005
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement
    """
    RDF_VALUE = 1006
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#value
    """
    RDF_FIRST = 1007
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#first
    """
    RDF_REST = 1008
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#rest
    """
    RDF_NIL = 1009
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#nil
    """
    RDF_XMLLITERAL = 1010
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral
    """
    RDF_ALT = 1011
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt
    """
    RDF_BAG = 1012
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag
    """
    RDF_LIST = 1013
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#List
    """
    RDF_SEQ = 1014
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq
    """
    RDF_1 = 1015
    """
    http://www.w3.org/1999/02/22-rdf-syntax-ns#_1
    """
    RDFS_COMMENT = 1100
    """
    http://www.w3.org/2000/01/rdf-schema#comment
    """
    RDFS_LABEL = 1101
    """
    http://www.w3.org/2000/01/rdf-schema#label
    """
    RDFS_DOMAIN = 1102
    """
    http://www.w3.org/2000/01/rdf-schema#domain
    """
    RDFS_RANGE = 1103
    """
    http://www.w3.org/2000/01/rdf-schema#range
    """
    RDFS_SUBCLASSOF = 1104
    """
    http://www.w3.org/2000/01/rdf-schema#subClassOf
    """
    RDFS_LITERAL = 1105
    """
    http://www.w3.org/2000/01/rdf-schema#Literal
    """
    RDFS_MEMBER = 1106
    """
    http://www.w3.org/2000/01/rdf-schema#member
    """
    RDFS_SUBPROPERTYOF = 1107
    """
    http://www.w3.org/2000/01/rdf-schema#subPropertyOf
    """
    RDFS_ISDEFINEDBY = 1108
    """
    http://www.w3.org/2000/01/rdf-schema#isDefinedBy
    """
    RDFS_SEEALSO = 1109
    """
    http://www.w3.org/2000/01/rdf-schema#seeAlso
    """
    RDFS_RESOURCE = 1110
    """
    http://www.w3.org/2000/01/rdf-schema#Resource
    """
    RDFS_CLASS = 1111
    """
    http://www.w3.org/2000/01/rdf-schema#Class
    """
    RDFS_DATATYPE = 1112
    """
    http://www.w3.org/2000/01/rdf-schema#Datatype
    """
    RDFS_CONTAINER = 1113
    """
    http://www.w3.org/2000/01/rdf-schema#Container
    """
    RDFS_CONTAINERMEMBERSHIPPROPERTY = 1114
    """
    http://www.w3.org/2000/01/rdf-schema#ContainerMembershipProperty
    """
    OWL_CLASS = 1200
    """
    http://www.w3.org/2002/07/owl#Class
    """
    OWL_OBJECTPROPERTY = 1201
    """
    http://www.w3.org/2002/07/owl#ObjectProperty
    """
    OWL_DATATYPEPROPERTY = 1202
    """
    http://www.w3.org/2002/07/owl#DatatypeProperty
    """
    OWL_FUNCTIONALPROPERTY = 1203
    """
    http://www.w3.org/2002/07/owl#FunctionalProperty
    """
    OWL_THING = 1204
    """
    http://www.w3.org/2002/07/owl#Thing
    """
    OWL_NOTHING = 1205
    """
    http://www.w3.org/2002/07/owl#Nothing
    """
    OWL_INDIVIDUAL = 1206
    """
    http://www.w3.org/2002/07/owl#Individual
    """
    OWL_EQUIVALENTCLASS = 1207
    """
    http://www.w3.org/2002/07/owl#equivalentClass
    """
    OWL_EQUIVALENTPROPERTY = 1208
    """
    http://www.w3.org/2002/07/owl#equivalentProperty
    """
    OWL_SAMEAS = 1209
    """
    http://www.w3.org/2002/07/owl#sameAs
    """
    OWL_DIFFERENTFROM = 1210
    """
    http://www.w3.org/2002/07/owl#differentFrom
    """
    OWL_ALLDIFFERENT = 1211
    """
    http://www.w3.org/2002/07/owl#AllDifferent
    """
    OWL_DISTINCTMEMBERS = 1212
    """
    http://www.w3.org/2002/07/owl#distinctMembers
    """
    OWL_INVERSEOF = 1213
    """
    http://www.w3.org/2002/07/owl#inverseOf
    """
    OWL_TRANSITIVEPROPERTY = 1214
    """
    http://www.w3.org/2002/07/owl#TransitiveProperty
    """
    OWL_SYMMETRICPROPERTY = 1215
    """
    http://www.w3.org/2002/07/owl#SymmetricProperty
    """
    OWL_INVERSEFUNCTIONALPROPERTY = 1216
    """
    http://www.w3.org/2002/07/owl#InverseFunctionalProperty
    """
    OWL_RESTRICTION = 1217
    """
    http://www.w3.org/2002/07/owl#Restriction
    """
    OWL_ONPROPERTY = 1218
    """
    http://www.w3.org/2002/07/owl#onProperty
    """
    OWL_ALLVALUESFROM = 1219
    """
    http://www.w3.org/2002/07/owl#allValuesFrom
    """
    OWL_SOMEVALUESFROM = 1220
    """
    http://www.w3.org/2002/07/owl#someValuesFrom
    """
    OWL_MINCARDINALITY = 1221
    """
    http://www.w3.org/2002/07/owl#minCardinality
    """
    OWL_MAXCARDINALITY = 1222
    """
    http://www.w3.org/2002/07/owl#maxCardinality
    """
    OWL_CARDINALITY = 1223
    """
    http://www.w3.org/2002/07/owl#cardinality
    """
    OWL_ONTOLOGY = 1224
    """
    http://www.w3.org/2002/07/owl#Ontology
    """
    OWL_IMPORTS = 1225
    """
    http://www.w3.org/2002/07/owl#imports
    """
    OWL_VERSIONINFO = 1226
    """
    http://www.w3.org/2002/07/owl#versionInfo
    """
    OWL_PRIORVERSION = 1227
    """
    http://www.w3.org/2002/07/owl#priorVersion
    """
    OWL_BACKWARDCOMPATIBLEWITH = 1228
    """
    http://www.w3.org/2002/07/owl#backwardCompatibleWith
    """
    OWL_INCOMPATIBLEWITH = 1229
    """
    http://www.w3.org/2002/07/owl#incompatibleWith
    """
    OWL_DEPRECATEDCLASS = 1230
    """
    http://www.w3.org/2002/07/owl#DeprecatedClass
    """
    OWL_DEPRECATEDPROPERTY = 1231
    """
    http://www.w3.org/2002/07/owl#DeprecatedProperty
    """
    OWL_ANNOTATIONPROPERTY = 1232
    """
    http://www.w3.org/2002/07/owl#AnnotationProperty
    """
    OWL_ONTOLOGYPROPERTY = 1233
    """
    http://www.w3.org/2002/07/owl#OntologyProperty
    """
    OWL_ONEOF = 1234
    """
    http://www.w3.org/2002/07/owl#oneOf
    """
    OWL_DATARANGE = 1235
    """
    http://www.w3.org/2002/07/owl#dataRange
    """
    OWL_DISJOINTWITH = 1236
    """
    http://www.w3.org/2002/07/owl#disjointWith
    """
    OWL_UNIONOF = 1237
    """
    http://www.w3.org/2002/07/owl#unionOf
    """
    OWL_COMPLEMENTOF = 1238
    """
    http://www.w3.org/2002/07/owl#complementOf
    """
    OWL_INTERSECTIONOF = 1239
    """
    http://www.w3.org/2002/07/owl#intersectionOf
    """
    OWL_HASVALUE = 1240
    """
    http://www.w3.org/2002/07/owl#hasValue
    """
    PKG_HASPART = 2000
    """
    http://docs.oasis-open.org/ns/office/1.2/meta/pkg#hasPart
    """
    PKG_MIMETYPE = 2003
    """
    http://docs.oasis-open.org/ns/office/1.2/meta/pkg#mimeType
    """
    PKG_PACKAGE = 2004
    """
    http://docs.oasis-open.org/ns/office/1.2/meta/pkg#Package
    """
    PKG_ELEMENT = 2005
    """
    http://docs.oasis-open.org/ns/office/1.2/meta/pkg#Element
    """
    PKG_FILE = 2006
    """
    http://docs.oasis-open.org/ns/office/1.2/meta/pkg#File
    """
    PKG_METADATAFILE = 2007
    """
    http://docs.oasis-open.org/ns/office/1.2/meta/pkg#MetadataFile
    """
    PKG_DOCUMENT = 2008
    """
    http://docs.oasis-open.org/ns/office/1.2/meta/pkg#Document
    """
    ODF_PREFIX = 2100
    """
    http://docs.oasis-open.org/ns/office/1.2/meta/odf#prefix
    """
    ODF_SUFFIX = 2101
    """
    http://docs.oasis-open.org/ns/office/1.2/meta/odf#suffix
    """
    ODF_ELEMENT = 2102
    """
    http://docs.oasis-open.org/ns/office/1.2/meta/odf#Element
    """
    ODF_CONTENTFILE = 2103
    """
    http://docs.oasis-open.org/ns/office/1.2/meta/odf#ContentFile
    """
    ODF_STYLESFILE = 2104
    """
    http://docs.oasis-open.org/ns/office/1.2/meta/odf#StylesFile
    """
    LO_EXT_SHADING = 2106
    """
    custom shading color of an annotated text range or metadata field (replacement of the default field shading color)
    
    urn:org:documentfoundation:names:experimental:office:xmlns:loext:1.0odf#shading
    
    **since**
    
        LibreOffice 7.2
    """

__all__ = ['URIs']
