# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.reflection
from abc import abstractmethod
from .x_type_description import XTypeDescription as XTypeDescription_3c210fb1

class XPropertyTypeDescription(XTypeDescription_3c210fb1):
    """
    Reflects a property.
    
    The type class of this type is com.sun.star.uno.TypeClass.PROPERTY.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API XPropertyTypeDescription <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1reflection_1_1XPropertyTypeDescription.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.reflection'
    __ooo_full_ns__: str = 'com.sun.star.reflection.XPropertyTypeDescription'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.reflection.XPropertyTypeDescription'

    @abstractmethod
    def getPropertyFlags(self) -> int:
        """
        The possible values are defined in com.sun.star.beans.PropertyAttribute
        """
    @abstractmethod
    def getPropertyTypeDescription(self) -> 'XTypeDescription_3c210fb1':
        """
        """

__all__ = ['XPropertyTypeDescription']

