# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.rendering


class ColorComponentTag(object):
    """
    Const Class

    A collection of tags for the individual components of a color.
    
    Color components usually correspond to physical attributes like the amount of red colorant contained in an output color. This constant field enumerates the most common ones.
    
    **since**
    
        OOo 2.3

    See Also:
        `API ColorComponentTag <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1rendering_1_1ColorComponentTag.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.rendering'
    __ooo_full_ns__: str = 'com.sun.star.rendering.ColorComponentTag'
    __ooo_type_name__: str = 'const'

    DEVICE = 0
    """
    Unspecified device color value.
    """
    RGB_RED = 1
    """
    Red colorant from RGB color space.
    """
    RGB_GREEN = 2
    """
    Green colorant from RGB color space.
    """
    RGB_BLUE = 3
    """
    Blue colorant from RGB color space.
    """
    CMYK_CYAN = 4
    """
    Cyan colorant from CMYK color space.
    """
    CMYK_MAGENTA = 5
    """
    Magenta colorant from CMYK color space.
    """
    CMYK_YELLOW = 6
    """
    Yellow colorant from CMYK color space.
    """
    CMYK_BLACK = 7
    """
    Black colorant from CMYK color space.
    """
    CMYKOG_ORANGE = 8
    """
    Orange colorant from hexachrome color space.
    """
    CMYKOG_GREEN = 9
    """
    Green colorant from hexachrome color space.
    """
    SPOT = 10
    """
    Arbitrary extra spot color, e.g. Pantone.
    """
    INDEX = 11
    """
    Index into palette.
    """
    ALPHA = 12
    """
    Alpha channel.
    """
    GREY = 13
    """
    Grey value. Used for monochrome color spaces.
    """
    PREMULTIPLIED_ALPHA = 14
    """
    Premultiplied alpha channel.
    
    Note that this alpha format actually influences the other color components, in that their values are pre-multiplied with the alpha value.
    """
    CIEXYZ_X = 15
    """
    CieXYZ X value.
    """
    CIEXYZ_Y = 16
    """
    CieXYZ Y value.
    """
    CIEXYZ_Z = 17
    """
    CieXYZ Z value.
    """
    CIELAB_L = 18
    """
    CieLab L value.
    """
    CIELAB_A = 19
    """
    CieLab a value.
    """
    CIELAB_B = 20
    """
    CieLab b value.
    """
    HSV_H = 21
    """
    HSV H value.
    """
    HSV_S = 22
    """
    HSV S value.
    """
    HSV_V = 23
    """
    HSV V value.
    """
    HSL_H = 24
    """
    HSL H value.
    """
    HSL_S = 25
    """
    HSL S value.
    """
    HSL_L = 26
    """
    HSL L value.
    """
    YCBCR_Y = 27
    """
    YCbCr Y value.
    """
    YCBCR_CB = 28
    """
    YCbCr Cb value.
    """
    YCBCR_CR = 29
    """
    YCbCr Cr value.
    """

__all__ = ['ColorComponentTag']
