# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.rendering
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing


class StringContext(object):
    """
    Struct Class

    Collection of string-related arguments used on all canvas text interfaces.
    
    A possibly much larger string than later rendered is necessary here, because in several languages, glyph selection is context dependent.
    
    **since**
    
        OOo 2.0

    See Also:
        `API StringContext <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1rendering_1_1StringContext.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.rendering'
    __ooo_full_ns__: str = 'com.sun.star.rendering.StringContext'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.rendering.StringContext'
    """Literal Constant ``com.sun.star.rendering.StringContext``"""

    def __init__(self, Text: typing.Optional[str] = '', StartPosition: typing.Optional[int] = 0, Length: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Text (str, optional): Text value.
            StartPosition (int, optional): StartPosition value.
            Length (int, optional): Length value.
        """
        super().__init__()

        if isinstance(Text, StringContext):
            oth: StringContext = Text
            self.Text = oth.Text
            self.StartPosition = oth.StartPosition
            self.Length = oth.Length
            return

        kargs = {
            "Text": Text,
            "StartPosition": StartPosition,
            "Length": Length,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._text = kwargs["Text"]
        self._start_position = kwargs["StartPosition"]
        self._length = kwargs["Length"]


    @property
    def Text(self) -> str:
        """
        The complete text, from which a subset is selected by the parameters below.
        """
        return self._text
    
    @Text.setter
    def Text(self, value: str) -> None:
        self._text = value

    @property
    def StartPosition(self) -> int:
        """
        Start position within the string.
        
        The first character has index 0.
        """
        return self._start_position
    
    @StartPosition.setter
    def StartPosition(self, value: int) -> None:
        self._start_position = value

    @property
    def Length(self) -> int:
        """
        Length of the substring to actually use.
        
        Must be within the range [0,INTMAX].
        """
        return self._length
    
    @Length.setter
    def Length(self, value: int) -> None:
        self._length = value


__all__ = ['StringContext']
