# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.rendering
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing
from ..geometry.affine_matrix2_d import AffineMatrix2D as AffineMatrix2D_ff040da8
from .stroke_attributes import StrokeAttributes as StrokeAttributes_2dd10f65
from .x_bitmap import XBitmap as XBitmap_b1b70b7b
from .x_parametric_poly_polygon2_d import XParametricPolyPolygon2D as XParametricPolyPolygon2D_b3511228


class Texture(object):
    """
    Struct Class

    Contains all information needed to define a texture.
    
    This structure contains all information necessary to define a texture. A texture describes the filled area of polygonal shapes, providing its own transformation matrix, repeat mode, and transparency.
    
    To achieve uniformity, if this texture has a bitmap set, it is scaled in such a way that it will cover the same [0,1]x[0,1] box as the hatch and the gradient. The transformation member can then be used to scale the complete texture as it fits suit.
    
    **since**
    
        OOo 2.0

    See Also:
        `API Texture <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1rendering_1_1Texture.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.rendering'
    __ooo_full_ns__: str = 'com.sun.star.rendering.Texture'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.rendering.Texture'
    """Literal Constant ``com.sun.star.rendering.Texture``"""

    def __init__(self, AffineTransform: typing.Optional[AffineMatrix2D_ff040da8] = UNO_NONE, Alpha: typing.Optional[float] = 0.0, NumberOfHatchPolygons: typing.Optional[int] = 0, Bitmap: typing.Optional[XBitmap_b1b70b7b] = None, Gradient: typing.Optional[XParametricPolyPolygon2D_b3511228] = None, Hatching: typing.Optional[XParametricPolyPolygon2D_b3511228] = None, HatchAttributes: typing.Optional[StrokeAttributes_2dd10f65] = UNO_NONE, RepeatModeX: typing.Optional[int] = 0, RepeatModeY: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            AffineTransform (AffineMatrix2D, optional): AffineTransform value.
            Alpha (float, optional): Alpha value.
            NumberOfHatchPolygons (int, optional): NumberOfHatchPolygons value.
            Bitmap (XBitmap, optional): Bitmap value.
            Gradient (XParametricPolyPolygon2D, optional): Gradient value.
            Hatching (XParametricPolyPolygon2D, optional): Hatching value.
            HatchAttributes (StrokeAttributes, optional): HatchAttributes value.
            RepeatModeX (int, optional): RepeatModeX value.
            RepeatModeY (int, optional): RepeatModeY value.
        """
        super().__init__()

        if isinstance(AffineTransform, Texture):
            oth: Texture = AffineTransform
            self.AffineTransform = oth.AffineTransform
            self.Alpha = oth.Alpha
            self.NumberOfHatchPolygons = oth.NumberOfHatchPolygons
            self.Bitmap = oth.Bitmap
            self.Gradient = oth.Gradient
            self.Hatching = oth.Hatching
            self.HatchAttributes = oth.HatchAttributes
            self.RepeatModeX = oth.RepeatModeX
            self.RepeatModeY = oth.RepeatModeY
            return

        kargs = {
            "AffineTransform": AffineTransform,
            "Alpha": Alpha,
            "NumberOfHatchPolygons": NumberOfHatchPolygons,
            "Bitmap": Bitmap,
            "Gradient": Gradient,
            "Hatching": Hatching,
            "HatchAttributes": HatchAttributes,
            "RepeatModeX": RepeatModeX,
            "RepeatModeY": RepeatModeY,
        }
        if kargs["AffineTransform"] is UNO_NONE:
            kargs["AffineTransform"] = None
        if kargs["HatchAttributes"] is UNO_NONE:
            kargs["HatchAttributes"] = None
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._affine_transform = kwargs["AffineTransform"]
        self._alpha = kwargs["Alpha"]
        self._number_of_hatch_polygons = kwargs["NumberOfHatchPolygons"]
        self._bitmap = kwargs["Bitmap"]
        self._gradient = kwargs["Gradient"]
        self._hatching = kwargs["Hatching"]
        self._hatch_attributes = kwargs["HatchAttributes"]
        self._repeat_mode_x = kwargs["RepeatModeX"]
        self._repeat_mode_y = kwargs["RepeatModeY"]


    @property
    def AffineTransform(self) -> AffineMatrix2D_ff040da8:
        """
        Texture transformation from texture to primitive space.
        
        This member allows arbitrary transformations of the texture, relative to the textured primitive. Thus, the total transformation from the [0,1]x[0,1] texture space to the device coordinate space is the concatenation of texture, render state, and view state transformation (with only render state and view state transformation being applied to the textured primitive).
        """
        return self._affine_transform
    
    @AffineTransform.setter
    def AffineTransform(self, value: AffineMatrix2D_ff040da8) -> None:
        self._affine_transform = value

    @property
    def Alpha(self) -> float:
        """
        Overall transparency of the texturing.
        
        The valid range for this value is [0,1], where 0 denotes complete transparency, and 1 denotes fully opaque.
        """
        return self._alpha
    
    @Alpha.setter
    def Alpha(self, value: float) -> None:
        self._alpha = value

    @property
    def NumberOfHatchPolygons(self) -> int:
        """
        Specifies the number of parameterized polygons used for the texture.
        
        This member specifies the number of polygons the parametric polygon interface is queried. The continuous range [0,1] of the XParametricPolyPolygon.getOutline() method is divided up into numberOfHatchPolygons equal parts, and for everyone of these parts, the start of the interval is plugged into the getOutline method. For example, if numberOfHatchPolygons is 2, then getOutline is called twice, once with 0.0 and once with 0.5. Use this parameter to control the density of the hatching.
        """
        return self._number_of_hatch_polygons
    
    @NumberOfHatchPolygons.setter
    def NumberOfHatchPolygons(self, value: int) -> None:
        self._number_of_hatch_polygons = value

    @property
    def Bitmap(self) -> XBitmap_b1b70b7b:
        """
        Texture bitmap.
        
        This member can be used together with gradient and hatching.
        
        The bitmap is scaled to a one-by-one rectangle, to cover the same area as both the gradient and the hatching.
        """
        return self._bitmap
    
    @Bitmap.setter
    def Bitmap(self, value: XBitmap_b1b70b7b) -> None:
        self._bitmap = value

    @property
    def Gradient(self) -> XParametricPolyPolygon2D_b3511228:
        """
        Texture gradient.
        
        This member can be used together with bitmap and hatching. The parametric polygons color value is used to fill the returned polygonal outlines.
        """
        return self._gradient
    
    @Gradient.setter
    def Gradient(self, value: XParametricPolyPolygon2D_b3511228) -> None:
        self._gradient = value

    @property
    def Hatching(self) -> XParametricPolyPolygon2D_b3511228:
        """
        Texture hatching.
        
        This member can be used together with bitmap and gradient. The parametric polygons color value is used to stroke the returned polygonal outlines.
        """
        return self._hatching
    
    @Hatching.setter
    def Hatching(self, value: XParametricPolyPolygon2D_b3511228) -> None:
        self._hatching = value

    @property
    def HatchAttributes(self) -> StrokeAttributes_2dd10f65:
        """
        Specifies the stroke attributes used for hatching.
        
        Use 0.0 as the strokeWidth here to indicate hair lines.
        """
        return self._hatch_attributes
    
    @HatchAttributes.setter
    def HatchAttributes(self, value: StrokeAttributes_2dd10f65) -> None:
        self._hatch_attributes = value

    @property
    def RepeatModeX(self) -> int:
        """
        Repeat mode of the texture, x direction.
        
        The repeat mode is separated into x and y direction, this is the x direction part. Permissible values are from the TexturingMode constants.
        """
        return self._repeat_mode_x
    
    @RepeatModeX.setter
    def RepeatModeX(self, value: int) -> None:
        self._repeat_mode_x = value

    @property
    def RepeatModeY(self) -> int:
        """
        Repeat mode of the texture, y direction.
        
        The repeat mode is separated into x and y direction, this is the y direction part. Permissible values are from the TexturingMode constants.
        """
        return self._repeat_mode_y
    
    @RepeatModeY.setter
    def RepeatModeY(self, value: int) -> None:
        self._repeat_mode_y = value


__all__ = ['Texture']
