# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.rendering
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .color_component import ColorComponent as ColorComponent_e4c0e78
    from .x_color_space import XColorSpace as XColorSpace_e3940d09

class XBitmapPalette(XInterface_8f010a43):
    """
    Interface to access the palette of a color-indexed bitmap.
    
    **since**
    
        OOo 2.0

    See Also:
        `API XBitmapPalette <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1rendering_1_1XBitmapPalette.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.rendering'
    __ooo_full_ns__: str = 'com.sun.star.rendering.XBitmapPalette'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.rendering.XBitmapPalette'

    @abstractmethod
    def getColorSpace(self) -> 'XColorSpace_e3940d09':
        """
        Query associated color space.
        """
    @abstractmethod
    def getIndex(self, entry: 'typing.Tuple[ColorComponent_e4c0e78, ...]', nIndex: int) -> bool:
        """
        Request the color for the given palette entry.

        * ``entry`` is an out direction argument.

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
    @abstractmethod
    def getNumberOfEntries(self) -> int:
        """
        Request the number of palette entries available.
        """
    @abstractmethod
    def setIndex(self, color: 'typing.Tuple[ColorComponent_e4c0e78, ...]', transparency: bool, nIndex: int) -> bool:
        """
        Set the color for the given palette entry.

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """

__all__ = ['XBitmapPalette']

