# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.report


class KeepTogether(object):
    """
    Const Class

    Specifies that a group header, detail, and footer section is printed on the same page.

    See Also:
        `API KeepTogether <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1report_1_1KeepTogether.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.report'
    __ooo_full_ns__: str = 'com.sun.star.report.KeepTogether'
    __ooo_type_name__: str = 'const'

    NO = 0
    """
    Prints the group without keeping the header, detail, and footer together on the same page.
    """
    WHOLE_GROUP = 1
    """
    Prints the group header, detail, and footer together on the same page.
    """
    WITH_FIRST_DETAIL = 2
    """
    Prints the group header on a page when the first detail record can fit on the same page.
    """

__all__ = ['KeepTogether']
