# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.script
import typing
from abc import abstractmethod
from ..container.x_name_access import XNameAccess as XNameAccess_e2ab0cf6
if typing.TYPE_CHECKING:
    from ..container.x_name_container import XNameContainer as XNameContainer_cb90e47

class XLibraryContainer(XNameAccess_e2ab0cf6):
    """
    Provides access to a library system.

    See Also:
        `API XLibraryContainer <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1script_1_1XLibraryContainer.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.script'
    __ooo_full_ns__: str = 'com.sun.star.script.XLibraryContainer'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.script.XLibraryContainer'

    @abstractmethod
    def createLibrary(self, Name: str) -> 'XNameContainer_cb90e47':
        """
        Creates a new library.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
            com.sun.star.container.ElementExistException: ``ElementExistException``
        """
    @abstractmethod
    def createLibraryLink(self, Name: str, StorageURL: str, ReadOnly: bool) -> 'XNameAccess_e2ab0cf6':
        """
        Creates a link to an \"external\" library that then can be accessed using this library manager.
        
        The format of the StorageURL is a matter of the implementation. If the read only flag is set, the linked library cannot be modified. In this case, the returned interface really is only an XNameAccess. If ReadOnly is false (and the referenced storage allows write access) the returned interface also can be a com.sun.star.container.XNameContainer.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
            com.sun.star.container.ElementExistException: ``ElementExistException``
        """
    @abstractmethod
    def isLibraryLoaded(self, Name: str) -> bool:
        """
        returns true if the accessed library is already loaded from the storage, otherwise false.

        Raises:
            com.sun.star.container.NoSuchElementException: ``NoSuchElementException``
        """
    @abstractmethod
    def loadLibrary(self, Name: str) -> None:
        """
        Causes the accessed library to be loaded from its storage if it hasn't already been loaded.

        Raises:
            com.sun.star.container.NoSuchElementException: ``NoSuchElementException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
    @abstractmethod
    def removeLibrary(self, Name: str) -> None:
        """
        removes the library item with the specified name.
        
        If the accessed library item is a link only the link is removed, not the target library.

        Raises:
            com.sun.star.container.NoSuchElementException: ``NoSuchElementException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """

__all__ = ['XLibraryContainer']

