# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.script
from abc import abstractmethod
from .x_library_container2 import XLibraryContainer2 as XLibraryContainer2_1c490e9f

class XLibraryContainer3(XLibraryContainer2_1c490e9f):
    """
    Extension of XLibraryContainer2.

    See Also:
        `API XLibraryContainer3 <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1script_1_1XLibraryContainer3.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.script'
    __ooo_full_ns__: str = 'com.sun.star.script.XLibraryContainer3'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.script.XLibraryContainer3'

    @abstractmethod
    def getOriginalLibraryLinkURL(self, Name: str) -> str:
        """
        returns the location of the library link target.
        
        The returned URL is literally the same as the one provided in XLibraryContainer.createLibraryLink(). Otherwise the behavior is the same as XLibraryContainer2.getLibraryLinkURL()

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
            com.sun.star.container.NoSuchElementException: ``NoSuchElementException``
        """

__all__ = ['XLibraryContainer3']

