# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.sdb.application
import typing
from abc import abstractmethod
from ...lang.x_event_listener import XEventListener as XEventListener_c7230c4a
if typing.TYPE_CHECKING:
    from .copy_table_row_event import CopyTableRowEvent as CopyTableRowEvent_9be911c0

class XCopyTableListener(XEventListener_c7230c4a):
    """
    specifies the interface required to listen for progress in copying table rows via a CopyTableWizard.

    See Also:
        `API XCopyTableListener <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1sdb_1_1application_1_1XCopyTableListener.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sdb.application'
    __ooo_full_ns__: str = 'com.sun.star.sdb.application.XCopyTableListener'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.sdb.application.XCopyTableListener'

    @abstractmethod
    def copiedRow(self, Event: 'CopyTableRowEvent_9be911c0') -> None:
        """
        is called when a row was successfully copied.
        
        This method is called right after a row has been successfully copied. It might be used, for instance, to update a progress indicator.
        """
    @abstractmethod
    def copyRowError(self, Event: 'CopyTableRowEvent_9be911c0') -> int:
        """
        is called when copying a row failed.
        """
    @abstractmethod
    def copyingRow(self, Event: 'CopyTableRowEvent_9be911c0') -> None:
        """
        is called when a row is about to be copied.
        
        This method is called immediately before a row is copied. It might be used, for instance, to update a progress indicator.
        """

__all__ = ['XCopyTableListener']

