# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.sdb
import typing
from abc import abstractmethod
from ..ui.dialogs.x_executable_dialog import XExecutableDialog as XExecutableDialog_450f0fa1
if typing.TYPE_CHECKING:
    from ..awt.x_window import XWindow as XWindow_713b0924

class ErrorMessageDialog(XExecutableDialog_450f0fa1):
    """
    Service Class

    provides a dialog for displaying database related exceptions.
    
    If applications use any of the functionality provided in the modules com.sun.star.sdbc, com.sun.star.sdbcx and com.sun.star.sdb, they will - sooner or later - encounter com.sun.star.sdbc.SQLException 's.
    These exceptions can be chained, so the information wrapped in one single com.sun.star.sdbc.SQLException can be rather complex (e.g., every instance where such an exception is passing before it is finally caught, could append a com.sun.star.sdb.SQLContext to explain what it was doing), and they should be presented to the user in a consistent way.
    This can be reached by using this service.

    See Also:
        `API ErrorMessageDialog <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1sdb_1_1ErrorMessageDialog.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sdb'
    __ooo_full_ns__: str = 'com.sun.star.sdb.ErrorMessageDialog'
    __ooo_type_name__: str = 'service'

    @abstractmethod
    def create(self, initialTitle: str, parentWindow: 'XWindow_713b0924', sqlException: object) -> None:
        """
        allows initializing the dialog
        
        You do not need to call the initialize method directly, instead you may use the createInstanceWithArguments method of your com.sun.star.lang.XMultiServiceFactory.
        
        You specify a parameter by passing one (or more) com.sun.star.beans.PropertyValue object(s) to the initialize method, where the Name field contains a string describing which aspect you want to affect, and the Value field containing a value.
        Imagine the initialization values, as if you use com.sun.star.beans\">XPropertySet.setPropertyValue() of the com.sun.star.beans.XPropertySet interface ...
        allowed parameters are
        """


__all__ = ['ErrorMessageDialog']

