# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.sdb
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..sdbc.x_connection import XConnection as XConnection_a36a0b0c
    from ..task.x_interaction_handler import XInteractionHandler as XInteractionHandler_bf80e51

class XCompletedConnection(XInterface_8f010a43):
    """
    is used for establishing connections via a factory which is identified by its name.
    
    To complete the information needed for establishing a connection an interaction handler is used.

    See Also:
        `API XCompletedConnection <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1sdb_1_1XCompletedConnection.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sdb'
    __ooo_full_ns__: str = 'com.sun.star.sdb.XCompletedConnection'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.sdb.XCompletedConnection'

    @abstractmethod
    def connectWithCompletion(self, handler: 'XInteractionHandler_bf80e51') -> 'XConnection_a36a0b0c':
        """
        attempts to establish a database connection.
        
        If information is missing, such as a user's password, they are completed by user interaction.

        Raises:
            com.sun.star.sdbc.SQLException: ``SQLException``
        """

__all__ = ['XCompletedConnection']

