# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.sdbcx


class Privilege(object):
    """
    Const Class

    defines a list of flags (bitmaps) which determines the access rights of a user or a user group.
    
    This list may grow in the future.

    See Also:
        `API Privilege <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1sdbcx_1_1Privilege.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sdbcx'
    __ooo_full_ns__: str = 'com.sun.star.sdbcx.Privilege'
    __ooo_type_name__: str = 'const'

    SELECT = 1
    """
    indicates that a user is allowed to read the data.
    """
    INSERT = 2
    """
    indicates that a user is allowed to insert new data.
    """
    UPDATE = 4
    """
    indicates that a user is allowed to update data.
    """
    DELETE = 8
    """
    indicates that a user is allowed to delete data.
    """
    READ = 16
    """
    indicates that a user is allowed to read the structure of a definition object.
    """
    CREATE = 32
    """
    indicates that a user is allowed to create a definition object.
    """
    ALTER = 64
    """
    indicates that a user is allowed to alter an existing object.
    """
    REFERENCE = 128
    """
    indicates that a user is allowed to set foreign keys for a table.
    """
    DROP = 256
    """
    indicates that a user is allowed to drop a definition object.
    """

__all__ = ['Privilege']
