# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.sheet
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing
from .single_reference import SingleReference as SingleReference_e27e0d12


class ComplexReference(object):
    """
    Struct Class

    contains a reference to a cell range.

    See Also:
        `API ComplexReference <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1sheet_1_1ComplexReference.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.ComplexReference'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.sheet.ComplexReference'
    """Literal Constant ``com.sun.star.sheet.ComplexReference``"""

    def __init__(self, Reference1: typing.Optional[SingleReference_e27e0d12] = UNO_NONE, Reference2: typing.Optional[SingleReference_e27e0d12] = UNO_NONE) -> None:
        """
        Constructor

        Arguments:
            Reference1 (SingleReference, optional): Reference1 value.
            Reference2 (SingleReference, optional): Reference2 value.
        """
        super().__init__()

        if isinstance(Reference1, ComplexReference):
            oth: ComplexReference = Reference1
            self.Reference1 = oth.Reference1
            self.Reference2 = oth.Reference2
            return

        kargs = {
            "Reference1": Reference1,
            "Reference2": Reference2,
        }
        if kargs["Reference1"] is UNO_NONE:
            kargs["Reference1"] = None
        if kargs["Reference2"] is UNO_NONE:
            kargs["Reference2"] = None
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._reference1 = kwargs["Reference1"]
        self._reference2 = kwargs["Reference2"]


    @property
    def Reference1(self) -> SingleReference_e27e0d12:
        """
        is the first reference.
        """
        return self._reference1
    
    @Reference1.setter
    def Reference1(self, value: SingleReference_e27e0d12) -> None:
        self._reference1 = value

    @property
    def Reference2(self) -> SingleReference_e27e0d12:
        """
        is the second reference.
        """
        return self._reference2
    
    @Reference2.setter
    def Reference2(self, value: SingleReference_e27e0d12) -> None:
        self._reference2 = value


__all__ = ['ComplexReference']
