# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.sheet
import typing
from abc import abstractmethod
from ..container.x_named import XNamed as XNamed_a6520b08
if typing.TYPE_CHECKING:
    from ..container.x_index_access import XIndexAccess as XIndexAccess_f0910d6d
    from .x_sheet_filter_descriptor import XSheetFilterDescriptor as XSheetFilterDescriptor_47cc0ff7
    from ..table.cell_range_address import CellRangeAddress as CellRangeAddress_ec450d43

class XDataPilotDescriptor(XNamed_a6520b08):
    """
    provides access to the layout settings of a data pilot table.
    
    This interface extends the interface com.sun.star.container.XNamed which provides access to the name of the data pilot table used e.g. in collections.

    See Also:
        `API XDataPilotDescriptor <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1sheet_1_1XDataPilotDescriptor.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.XDataPilotDescriptor'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.sheet.XDataPilotDescriptor'

    @abstractmethod
    def getColumnFields(self) -> 'XIndexAccess_f0910d6d':
        """
        returns the collection of the data pilot fields used as column fields.
        """
    @abstractmethod
    def getDataFields(self) -> 'XIndexAccess_f0910d6d':
        """
        returns the collection of the data pilot fields used as data fields.
        """
    @abstractmethod
    def getDataPilotFields(self) -> 'XIndexAccess_f0910d6d':
        """
        returns the collection of all the data pilot fields.
        """
    @abstractmethod
    def getFilterDescriptor(self) -> 'XSheetFilterDescriptor_47cc0ff7':
        """
        returns the filter descriptor specifying which data from the source cell range are used for the data pilot table.
        """
    @abstractmethod
    def getHiddenFields(self) -> 'XIndexAccess_f0910d6d':
        """
        returns the collection of the data pilot fields not used as column, row, page, or data fields.
        """
    @abstractmethod
    def getPageFields(self) -> 'XIndexAccess_f0910d6d':
        """
        returns the collection of the data pilot fields used as page fields.
        """
    @abstractmethod
    def getRowFields(self) -> 'XIndexAccess_f0910d6d':
        """
        returns the collection of the data pilot fields used as row fields.
        """
    @abstractmethod
    def getSourceRange(self) -> 'CellRangeAddress_ec450d43':
        """
        returns the cell range containing the data for the data pilot table.
        """
    @abstractmethod
    def getTag(self) -> str:
        """
        returns an additional string stored in the data pilot table.
        """
    @abstractmethod
    def setSourceRange(self, aSourceRange: 'CellRangeAddress_ec450d43') -> None:
        """
        sets the cell range containing the data for the data pilot table.
        """
    @abstractmethod
    def setTag(self, aTag: str) -> None:
        """
        sets an additional string stored in the data pilot table.
        """

__all__ = ['XDataPilotDescriptor']

