# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.sheet
import typing
from abc import abstractmethod, ABC
if typing.TYPE_CHECKING:
    from .formula_token import FormulaToken as FormulaToken_bd1c0bf8
    from ..table.cell_address import CellAddress as CellAddress_ae5f0b56

class XFormulaParser(ABC):
    """
    converts between text and token representations of formulas.

    See Also:
        `API XFormulaParser <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1sheet_1_1XFormulaParser.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.XFormulaParser'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.sheet.XFormulaParser'

    @abstractmethod
    def parseFormula(self, aFormula: str, aReferencePos: 'CellAddress_ae5f0b56') -> 'typing.Tuple[FormulaToken_bd1c0bf8, ...]':
        """
        parses a formula into a sequence of tokens.
        """
    @abstractmethod
    def printFormula(self, aTokens: 'typing.Tuple[FormulaToken_bd1c0bf8, ...]', aReferencePos: 'CellAddress_ae5f0b56') -> str:
        """
        converts a formula into a string.
        """

__all__ = ['XFormulaParser']

