# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.sheet
import typing
from abc import abstractmethod
from ..container.x_index_access import XIndexAccess as XIndexAccess_f0910d6d
if typing.TYPE_CHECKING:
    from ..beans.property_value import PropertyValue as PropertyValue_c9610c73

class XSheetConditionalEntries(XIndexAccess_f0910d6d):
    """
    provides methods to add and remove conditions of a conditional format.

    See Also:
        `API XSheetConditionalEntries <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1sheet_1_1XSheetConditionalEntries.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.XSheetConditionalEntries'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.sheet.XSheetConditionalEntries'

    @abstractmethod
    def addNew(self, aConditionalEntry: 'typing.Tuple[PropertyValue_c9610c73, ...]') -> None:
        """
        adds a conditional entry to the format.
        
        Supported properties are:
        """
    @abstractmethod
    def clear(self) -> None:
        """
        clears all condition entries.
        """
    @abstractmethod
    def removeByIndex(self, nIndex: int) -> None:
        """
        removes a conditional entry from the format.
        """

__all__ = ['XSheetConditionalEntries']

