# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.table
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
from .border_line import BorderLine as BorderLine_a3f80af6
from ..util.color import Color as Color_68e908c5
import typing


class BorderLine2(BorderLine_a3f80af6):
    """
    Struct Class

    A border line, extended with line style.
    
    **since**
    
        LibreOffice 3.4

    See Also:
        `API BorderLine2 <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1table_1_1BorderLine2.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.table'
    __ooo_full_ns__: str = 'com.sun.star.table.BorderLine2'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.table.BorderLine2'
    """Literal Constant ``com.sun.star.table.BorderLine2``"""

    def __init__(self, Color: typing.Optional[Color_68e908c5] = Color_68e908c5(0), InnerLineWidth: typing.Optional[int] = 0, OuterLineWidth: typing.Optional[int] = 0, LineDistance: typing.Optional[int] = 0, LineStyle: typing.Optional[int] = 0, LineWidth: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Color (Color, optional): Color value.
            InnerLineWidth (int, optional): InnerLineWidth value.
            OuterLineWidth (int, optional): OuterLineWidth value.
            LineDistance (int, optional): LineDistance value.
            LineStyle (int, optional): LineStyle value.
            LineWidth (int, optional): LineWidth value.
        """

        if isinstance(Color, BorderLine2):
            oth: BorderLine2 = Color
            self.Color = oth.Color
            self.InnerLineWidth = oth.InnerLineWidth
            self.OuterLineWidth = oth.OuterLineWidth
            self.LineDistance = oth.LineDistance
            self.LineStyle = oth.LineStyle
            self.LineWidth = oth.LineWidth
            return

        kargs = {
            "Color": Color,
            "InnerLineWidth": InnerLineWidth,
            "OuterLineWidth": OuterLineWidth,
            "LineDistance": LineDistance,
            "LineStyle": LineStyle,
            "LineWidth": LineWidth,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._line_style = kwargs["LineStyle"]
        self._line_width = kwargs["LineWidth"]
        inst_keys = ('LineStyle', 'LineWidth')
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)


    @property
    def LineStyle(self) -> int:
        """
        Style of the border.
        """
        return self._line_style
    
    @LineStyle.setter
    def LineStyle(self, value: int) -> None:
        self._line_style = value

    @property
    def LineWidth(self) -> int:
        """
        Width of the border, this is the base to compute all the lines and gaps widths.
        
        These widths computations are based on the LineStyle property
        
        This property is prevailing on the old Out, In and Dist width from BorderLine. If this property is set to 0, then the other widths will be used to guess the border width.
        """
        return self._line_width
    
    @LineWidth.setter
    def LineWidth(self, value: int) -> None:
        self._line_width = value


__all__ = ['BorderLine2']
