# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.text


class BibliographyDataField(object):
    """
    Const Class

    These values define parts of bibliographic data.
    
    They are used to create a bibliography in a text document.
    
    Depending on the type of the data some of the fields will usually be left empty.
    
    **since**
    
        LibreOffice 7.3

    See Also:
        `API BibliographyDataField <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1text_1_1BibliographyDataField.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.text'
    __ooo_full_ns__: str = 'com.sun.star.text.BibliographyDataField'
    __ooo_type_name__: str = 'const'

    IDENTIFIER = 0
    """
    This field contains a unique identifier for the bibliographic data.
    """
    BIBILIOGRAPHIC_TYPE = 1
    """
    This field contains the type of the bibliographic reference.
    
    It is of the type BibliographyDataType.
    """
    ADDRESS = 2
    """
    This field contains the address of the publisher.
    """
    ANNOTE = 3
    """
    This field contains an annotation.
    """
    AUTHOR = 4
    """
    This field contains the name(s) of the author(s)
    """
    BOOKTITLE = 5
    """
    This field contains the title of the book.
    """
    CHAPTER = 6
    """
    This field contains the name or number of the chapter.
    """
    EDITION = 7
    """
    This field contains the number or name of the edition.
    """
    EDITOR = 8
    """
    This field contains the name(s) of the editor(s)
    """
    HOWPUBLISHED = 9
    """
    This field contains a description of the type of the publishing.
    """
    INSTITUTION = 10
    """
    This field contains the name of the institution where the publishing was created.
    """
    JOURNAL = 11
    """
    This field contains the name of the journal.
    """
    MONTH = 12
    """
    This field contains number or name of the month of the publishing.
    """
    NOTE = 13
    """
    This field contains a note.
    """
    NUMBER = 14
    """
    This field contains the number of the publishing.
    """
    ORGANIZATIONS = 15
    """
    This field contains the name of the organizations where the publishing was created.
    """
    PAGES = 16
    """
    This field contains the number(s) of the page(s) of the reference into a publishing.
    """
    PUBLISHER = 17
    """
    This field contains the name of the publisher.
    """
    SCHOOL = 18
    """
    This field contains the name of the university or school where the publishing was created.
    """
    SERIES = 19
    """
    This field contains the series of the publishing.
    """
    TITLE = 20
    """
    This field contains the title of the publishing.
    """
    REPORT_TYPE = 21
    """
    This field contains a description of the type of the report.
    """
    VOLUME = 22
    """
    This field contains the volume of the publishing.
    """
    YEAR = 23
    """
    This field contains the year when the publishing was created.
    """
    URL = 24
    """
    This field contains URL of the publishing.
    """
    CUSTOM1 = 25
    """
    This field contains user defined data.
    """
    CUSTOM2 = 26
    """
    This field contains user defined data.
    """
    CUSTOM3 = 27
    """
    This field contains user defined data.
    """
    CUSTOM4 = 28
    """
    This field contains user defined data.
    """
    CUSTOM5 = 29
    """
    This field contains user defined data.
    """
    ISBN = 30
    """
    This field contains the ISBN data of the publishing.
    """
    LOCAL_URL = 31
    """
    This field contains a local copy of the publishing.
    
    **since**
    
        LibreOffice 7.3
    """

__all__ = ['BibliographyDataField']
