# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.text.fieldmaster
from abc import abstractproperty
from ..text_field_master import TextFieldMaster as TextFieldMaster_d6410cc2

class SetExpression(TextFieldMaster_d6410cc2):
    """
    Service Class

    Specifies the service of a set expression field master.

    See Also:
        `API SetExpression <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1text_1_1fieldmaster_1_1SetExpression.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.text.fieldmaster'
    __ooo_full_ns__: str = 'com.sun.star.text.fieldmaster.SetExpression'
    __ooo_type_name__: str = 'service'

    @abstractproperty
    def ChapterNumberingLevel(self) -> int:
        """
        determines the number of the chapter.
        
        This values is used if the field master is set as number sequence.
        """

    @abstractproperty
    def NumberingSeparator(self) -> str:
        """
        determines the numbering separator string if the field master is set as number sequence.
        """

    @abstractproperty
    def SubType(self) -> int:
        """
        determines the type of the field as com.sun.star.text.SetVariableType
        """



__all__ = ['SetExpression']

