# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing


class Link(object):
    """
    Struct Class

    defines a link.

    See Also:
        `API Link <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1Link.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ucb'
    __ooo_full_ns__: str = 'com.sun.star.ucb.Link'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.ucb.Link'
    """Literal Constant ``com.sun.star.ucb.Link``"""

    def __init__(self, Source: typing.Optional[str] = '', Destination: typing.Optional[str] = '') -> None:
        """
        Constructor

        Arguments:
            Source (str, optional): Source value.
            Destination (str, optional): Destination value.
        """
        super().__init__()

        if isinstance(Source, Link):
            oth: Link = Source
            self.Source = oth.Source
            self.Destination = oth.Destination
            return

        kargs = {
            "Source": Source,
            "Destination": Destination,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._source = kwargs["Source"]
        self._destination = kwargs["Destination"]


    @property
    def Source(self) -> str:
        """
        contains the source URI of the link.
        """
        return self._source
    
    @Source.setter
    def Source(self, value: str) -> None:
        self._source = value

    @property
    def Destination(self) -> str:
        """
        contains the destination URI of the link.
        """
        return self._destination
    
    @Destination.setter
    def Destination(self, value: str) -> None:
        self._destination = value


__all__ = ['Link']
