# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing
from ..uno.exception import Exception as Exception_85530a09
from ..uno.x_interface import XInterface as XInterface_8f010a43

class UnsupportedDataSinkException(Exception_85530a09):
    """
    Exception Class

    This exception is used to indicate that the requested type of data sink is not supported.
    
    For example, each OpenCommandArgument supplied as argument of the command \"open\" contains such a data sink.

    See Also:
        `API UnsupportedDataSinkException <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1ucb_1_1UnsupportedDataSinkException.html>`_
    """

    __ooo_ns__: str = 'com.sun.star.ucb'
    __ooo_full_ns__: str = 'com.sun.star.ucb.UnsupportedDataSinkException'
    __ooo_type_name__: str = 'exception'
    __pyunointerface__: str = 'com.sun.star.ucb.UnsupportedDataSinkException'
    __pyunostruct__: str = 'com.sun.star.ucb.UnsupportedDataSinkException'

    typeName: str = 'com.sun.star.ucb.UnsupportedDataSinkException'
    """Literal Constant ``com.sun.star.ucb.UnsupportedDataSinkException``"""

    def __init__(self, Message: typing.Optional[str] = '', Context: typing.Optional[XInterface_8f010a43] = None, Sink: typing.Optional[XInterface_8f010a43] = None) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            Sink (XInterface, optional): Sink value.
        """
        kargs = {
            "Message": Message,
            "Context": Context,
            "Sink": Sink,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._sink = kwargs["Sink"]
        inst_keys = ('Sink',)
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)

    @property
    def Sink(self) -> XInterface_8f010a43:
        """
        contains the data sink that is not supported.
        """
        return self._sink
    
    @Sink.setter
    def Sink(self, value: XInterface_8f010a43) -> None:
        self._sink = value


__all__ = ['UnsupportedDataSinkException']

