# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.ui
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..beans.property_value import PropertyValue as PropertyValue_c9610c73
    from .xui_element_factory import XUIElementFactory as XUIElementFactory_d0280c7e

class XUIElementFactoryRegistration(XInterface_8f010a43):
    """
    is used to query, register and deregister user interface element factories.
    
    A user interface element factory is registered for a set of three properties.
    
    A combination of these three property values can uniquely identify every user interface element within OpenOffice.
    
    Currently the following user interface element types are defined:
    
    **since**
    
        OOo 2.0

    See Also:
        `API XUIElementFactoryRegistration <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1ui_1_1XUIElementFactoryRegistration.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ui'
    __ooo_full_ns__: str = 'com.sun.star.ui.XUIElementFactoryRegistration'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.ui.XUIElementFactoryRegistration'

    @abstractmethod
    def deregisterFactory(self, aType: str, aName: str, ModuleIdentifier: str) -> None:
        """
        function to remove a previously defined user interface element factory.
        
        Using this function can be very dangerous as other implementation with OpenOffice may not be able to create their user interface element anymore.

        Raises:
            com.sun.star.container.NoSuchElementException: ``NoSuchElementException``
        """
    @abstractmethod
    def getFactory(self, ResourceURL: str, ModuleIdentifier: str) -> 'XUIElementFactory_d0280c7e':
        """
        function to retrieve a previously registered user interface element factory.
        """
    @abstractmethod
    def getRegisteredFactories(self) -> 'typing.Tuple[typing.Tuple[PropertyValue_c9610c73, ...], ...]':
        """
        function to retrieve a list of all registered user interface element factories
        
        The following properties are defined:
        """
    @abstractmethod
    def registerFactory(self, aType: str, aName: str, aModuleIdentifier: str, aFactoryImplementationName: str) -> None:
        """
        function to register a user interface element factory.

        Raises:
            com.sun.star.container.ElementExistException: ``ElementExistException``
        """

__all__ = ['XUIElementFactoryRegistration']

