# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.uri
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .relative_uri_excess_parent_segments import RelativeUriExcessParentSegments as RelativeUriExcessParentSegments_c50412df
    from .x_uri_reference import XUriReference as XUriReference_afc30b6f

class XUriReferenceFactory(XInterface_8f010a43):
    """
    creates URI references.
    
    See RFC 3986 for a description of URI references and related terms.
    
    **since**
    
        OOo 2.0

    See Also:
        `API XUriReferenceFactory <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1uri_1_1XUriReferenceFactory.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.uri'
    __ooo_full_ns__: str = 'com.sun.star.uri.XUriReferenceFactory'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.uri.XUriReferenceFactory'

    @abstractmethod
    def makeAbsolute(self, baseUriReference: 'XUriReference_afc30b6f', uriReference: 'XUriReference_afc30b6f', processAdditionalSpecialSegments: bool, excessParentSegments: 'RelativeUriExcessParentSegments_c50412df') -> 'XUriReference_afc30b6f':
        """
        resolves a relative URI reference to absolute form.
        """
    @abstractmethod
    def makeRelative(self, baseUriReference: 'XUriReference_afc30b6f', uriReference: 'XUriReference_afc30b6f', preferAuthorityOverRelativePath: bool, preferAbsoluteOverRelativePath: bool, encodeRetainedSpecialSegments: bool) -> 'XUriReference_afc30b6f':
        """
        changes an absolute URI reference to relative form.
        """
    @abstractmethod
    def parse(self, uriReference: str) -> 'XUriReference_afc30b6f':
        """
        parses the textual representation of a URI reference.
        """

__all__ = ['XUriReferenceFactory']

