# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.util
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing


class AtomDescription(object):
    """
    Struct Class

    contains a string and the corresponding registered atom .

    See Also:
        `API AtomDescription <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1util_1_1AtomDescription.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.util'
    __ooo_full_ns__: str = 'com.sun.star.util.AtomDescription'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.util.AtomDescription'
    """Literal Constant ``com.sun.star.util.AtomDescription``"""

    def __init__(self, atom: typing.Optional[int] = 0, description: typing.Optional[str] = '') -> None:
        """
        Constructor

        Arguments:
            atom (int, optional): atom value.
            description (str, optional): description value.
        """
        super().__init__()

        if isinstance(atom, AtomDescription):
            oth: AtomDescription = atom
            self.atom = oth.atom
            self.description = oth.description
            return

        kargs = {
            "atom": atom,
            "description": description,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._atom = kwargs["atom"]
        self._description = kwargs["description"]


    @property
    def atom(self) -> int:
        """
        the atom itself
        """
        return self._atom
    
    @atom.setter
    def atom(self, value: int) -> None:
        self._atom = value

    @property
    def description(self) -> str:
        """
        the string it stands for
        """
        return self._description
    
    @description.setter
    def description(self, value: str) -> None:
        self._description = value


__all__ = ['AtomDescription']
