# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.util
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing
from .sort_field_type import SortFieldType as SortFieldType_bd500bf4


class SortField(object):
    """
    Struct Class

    describes a single field in a sort descriptor.
    
    .. deprecated::
    
        Class is deprecated.

    See Also:
        `API SortField <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1util_1_1SortField.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.util'
    __ooo_full_ns__: str = 'com.sun.star.util.SortField'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.util.SortField'
    """Literal Constant ``com.sun.star.util.SortField``"""

    def __init__(self, Field: typing.Optional[int] = 0, SortAscending: typing.Optional[bool] = False, FieldType: typing.Optional[SortFieldType_bd500bf4] = SortFieldType_bd500bf4.AUTOMATIC) -> None:
        """
        Constructor

        Arguments:
            Field (int, optional): Field value.
            SortAscending (bool, optional): SortAscending value.
            FieldType (SortFieldType, optional): FieldType value.
        """
        super().__init__()

        if isinstance(Field, SortField):
            oth: SortField = Field
            self.Field = oth.Field
            self.SortAscending = oth.SortAscending
            self.FieldType = oth.FieldType
            return

        kargs = {
            "Field": Field,
            "SortAscending": SortAscending,
            "FieldType": FieldType,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._field = kwargs["Field"]
        self._sort_ascending = kwargs["SortAscending"]
        self._field_type = kwargs["FieldType"]


    @property
    def Field(self) -> int:
        """
        index of the field in the table; 0-based.
        """
        return self._field
    
    @Field.setter
    def Field(self, value: int) -> None:
        self._field = value

    @property
    def SortAscending(self) -> bool:
        """
        TRUE if data are sorted in ascending order, FALSE if in descending order.
        """
        return self._sort_ascending
    
    @SortAscending.setter
    def SortAscending(self, value: bool) -> None:
        self._sort_ascending = value

    @property
    def FieldType(self) -> SortFieldType_bd500bf4:
        """
        type of contents in the field.
        """
        return self._field_type
    
    @FieldType.setter
    def FieldType(self, value: SortFieldType_bd500bf4) -> None:
        self._field_type = value


__all__ = ['SortField']
