# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.xml.crypto.sax
import typing
from abc import abstractmethod
from .xsax_event_keeper import XSAXEventKeeper as XSAXEventKeeper_65aa1044
if typing.TYPE_CHECKING:
    from .element_mark_priority import ElementMarkPriority as ElementMarkPriority_b02c1259

class XSecuritySAXEventKeeper(XSAXEventKeeper_65aa1044):
    """
    Interface of Security SAX Event Keeper.
    
    This interface is an extension of the XSAXEventKeeper interface, some security related features are added.

    See Also:
        `API XSecuritySAXEventKeeper <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1xml_1_1crypto_1_1sax_1_1XSecuritySAXEventKeeper.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.xml.crypto.sax'
    __ooo_full_ns__: str = 'com.sun.star.xml.crypto.sax.XSecuritySAXEventKeeper'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.xml.crypto.sax.XSecuritySAXEventKeeper'

    @abstractmethod
    def addSecurityElementCollector(self, priority: 'ElementMarkPriority_b02c1259', modifyElement: bool) -> int:
        """
        Adds a new element collector on the next element in the SAX event stream.
        """
    @abstractmethod
    def setSecurityId(self, id: int, securityId: int) -> None:
        """
        Sets security id for an element mark.
        """

__all__ = ['XSecuritySAXEventKeeper']

