# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.xml.sax
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing
from ...uno.exception import Exception as Exception_85530a09
from ...uno.x_interface import XInterface as XInterface_8f010a43

class SAXException(Exception_85530a09):
    """
    Exception Class

    encapsulates the details of an XML parse error or warning.
    
    This structure is a replacement for the Java class org.xml.sax.SAXException.
    
    Some abbreviations:

    See Also:
        `API SAXException <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1xml_1_1sax_1_1SAXException.html>`_
    """

    __ooo_ns__: str = 'com.sun.star.xml.sax'
    __ooo_full_ns__: str = 'com.sun.star.xml.sax.SAXException'
    __ooo_type_name__: str = 'exception'
    __pyunointerface__: str = 'com.sun.star.xml.sax.SAXException'
    __pyunostruct__: str = 'com.sun.star.xml.sax.SAXException'

    typeName: str = 'com.sun.star.xml.sax.SAXException'
    """Literal Constant ``com.sun.star.xml.sax.SAXException``"""

    def __init__(self, Message: typing.Optional[str] = '', Context: typing.Optional[XInterface_8f010a43] = None, WrappedException: typing.Optional[object] = None) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            WrappedException (object, optional): WrappedException value.
        """
        kargs = {
            "Message": Message,
            "Context": Context,
            "WrappedException": WrappedException,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._wrapped_exception = kwargs["WrappedException"]
        inst_keys = ('WrappedException',)
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)

    @property
    def WrappedException(self) -> object:
        """
        This field may contain a wrapped exception.
        """
        return self._wrapped_exception
    
    @WrappedException.setter
    def WrappedException(self, value: object) -> None:
        self._wrapped_exception = value


__all__ = ['SAXException']

