from __future__ import annotations

from crystal_toolkit.helpers.asymptote_renderer import (
    ASY_OBJS,
    _read_color,
    _read_properties,
)


def test_read_properties(standard_scenes):
    def _set_and_read_properties(scene):
        # make sure the _meta["asy"] attribute is set
        scene._meta = scene._meta or {}
        scene._meta["asy"] = scene._meta.get("asy", {})

        scene.prop0 = "scene"
        scene._meta["prop0"] = "meta"
        user_setting = {scene.type: {"prop0": "user"}}
        p0 = _read_properties(scene, property="prop0", user_settings=user_setting)
        assert p0 == "user"

        scene.prop1 = "scene"
        scene._meta["asy"]["prop1"] = "meta"
        p1 = _read_properties(scene, property="prop1")
        assert p1 == "meta"

    for k, v in standard_scenes.items():
        _set_and_read_properties(v)
        # Default color is used
        assert _read_color(v) is not None


def test_asymptote_renderer(standard_scenes):
    for k in ["lines", "spheres", "cylinders", "surface"]:
        asy_obj = ASY_OBJS[k].from_ctk(standard_scenes[k])
        asy_out = str(asy_obj)
        assert "draw" in asy_out.lower()
