# hoprd-config-tool


Tool to generate HOPRd identity, configuration, and docker-compose files from a single input where all required data is specified.

## Installation
```bash
➜ pip(3) install (-U) hoprd-config-tool
```

## Usage
To generate the required ressources (identities, configurations and docker-compose files) from a [config file](./.config/network_1.toml), run the following command:

```sh
➜ python -m hoprd-config-tool --params .config/network_1.toml
```

You can specify the root folder where identity and configuration files will be generated by appending the optional parameter `--folder <FOLDER>` which by default is set to `./.hoprd-nodes/`.

The generated docker compose file follows the default naming: `docker-compose.yml`

### Custom Docker networks

If you need the generated compose file to reference custom networks (for example
to attach the services to an existing external network) you can define them in
your configuration file under the `networks` key, using the same syntax as in a
regular `docker-compose.yml` file:

```toml
[networks.default]
name = "hoprd-network1"
external = true
```

The contents of this section are copied verbatim into the rendered compose file
and every generated service automatically references all declared networks.

### Using tagged values in TOML

The TOML params file can express the YAML tags used by the generated
configuration (for example `!AutoFunding`, `!AutoRedeeming`, or
`!ClosureFinalizer`) by embedding the tag in the array-of-table header:

```toml
[[config.hopr.strategy.strategies.AutoFunding]]
funding_amount = "500 xDAI"
min_stake_threshold = "100 HOPR"
```

The tool converts those entries into the appropriate YAML objects before
rendering the final `.cfg.yaml` files, so the output format remains unchanged.

### Naming nodes with surnames

Each entry in the `[[nodes]]` section can optionally embed the node's
`surname` directly into the table header to differentiate nodes within the same
params file:

```toml
[[nodes.alpha]]
safe_address = "SAFE_ADDRESS_1"
...
```

The surname in the header is converted to a slug (letters, numbers, and dashes
only) and used in every generated file path and docker-compose service name.
If a node omits the surname (for example by sticking with a plain `[[nodes]]`
entry) the tool falls back to the numeric index, preserving the existing
behavior.
