"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnEipEndpoint = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const _util_1 = require("./_util");
/**
 * Use an EC2 Instance as a Global Accelerator Endpoint
 */
class CfnEipEndpoint {
    constructor(eip, options = {}) {
        this.eip = eip;
        this.options = options;
        jsiiDeprecationWarnings._aws_cdk_aws_globalaccelerator_endpoints_CfnEipEndpointProps(options);
        _util_1.validateWeight(options.weight);
        this.region = core_1.Stack.of(eip).region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.eip.attrAllocationId,
            weight: this.options.weight,
        };
    }
}
exports.CfnEipEndpoint = CfnEipEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CfnEipEndpoint[_a] = { fqn: "@aws-cdk/aws-globalaccelerator-endpoints.CfnEipEndpoint", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWlwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZWlwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUVBLHdDQUFzQztBQUN0QyxtQ0FBeUM7QUFnQnpDOztHQUVHO0FBQ0gsTUFBYSxjQUFjO0lBR3pCLFlBQTZCLEdBQWUsRUFBbUIsVUFBK0IsRUFBRTtRQUFuRSxRQUFHLEdBQUgsR0FBRyxDQUFZO1FBQW1CLFlBQU8sR0FBUCxPQUFPLENBQTBCOztRQUM5RixzQkFBYyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUUvQixJQUFJLENBQUMsTUFBTSxHQUFHLFlBQUssQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUMsTUFBTSxDQUFDO0tBQ3BDO0lBRU0sMkJBQTJCO1FBQ2hDLE9BQU87WUFDTCxVQUFVLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0I7WUFDckMsTUFBTSxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTTtTQUN5QixDQUFDO0tBQ3hEOztBQWRILHdDQWVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZWMyIGZyb20gJ0Bhd3MtY2RrL2F3cy1lYzInO1xuaW1wb3J0ICogYXMgZ2EgZnJvbSAnQGF3cy1jZGsvYXdzLWdsb2JhbGFjY2VsZXJhdG9yJztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyB2YWxpZGF0ZVdlaWdodCB9IGZyb20gJy4vX3V0aWwnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGEgTmV0d29ya0xvYWRCYWxhbmNlckVuZHBvaW50XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuRWlwRW5kcG9pbnRQcm9wcyB7XG4gIC8qKlxuICAgKiBFbmRwb2ludCB3ZWlnaHQgYWNyb3NzIGFsbCBlbmRwb2ludHMgaW4gdGhlIGdyb3VwXG4gICAqXG4gICAqIE11c3QgYmUgYSB2YWx1ZSBiZXR3ZWVuIDAgYW5kIDI1NS5cbiAgICpcbiAgICogQGRlZmF1bHQgMTI4XG4gICAqL1xuICByZWFkb25seSB3ZWlnaHQ/OiBudW1iZXI7XG59XG5cbi8qKlxuICogVXNlIGFuIEVDMiBJbnN0YW5jZSBhcyBhIEdsb2JhbCBBY2NlbGVyYXRvciBFbmRwb2ludFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuRWlwRW5kcG9pbnQgaW1wbGVtZW50cyBnYS5JRW5kcG9pbnQge1xuICBwdWJsaWMgcmVhZG9ubHkgcmVnaW9uPzogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgZWlwOiBlYzIuQ2ZuRUlQLCBwcml2YXRlIHJlYWRvbmx5IG9wdGlvbnM6IENmbkVpcEVuZHBvaW50UHJvcHMgPSB7fSkge1xuICAgIHZhbGlkYXRlV2VpZ2h0KG9wdGlvbnMud2VpZ2h0KTtcblxuICAgIHRoaXMucmVnaW9uID0gU3RhY2sub2YoZWlwKS5yZWdpb247XG4gIH1cblxuICBwdWJsaWMgcmVuZGVyRW5kcG9pbnRDb25maWd1cmF0aW9uKCk6IGFueSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGVuZHBvaW50SWQ6IHRoaXMuZWlwLmF0dHJBbGxvY2F0aW9uSWQsXG4gICAgICB3ZWlnaHQ6IHRoaXMub3B0aW9ucy53ZWlnaHQsXG4gICAgfSBhcyBnYS5DZm5FbmRwb2ludEdyb3VwLkVuZHBvaW50Q29uZmlndXJhdGlvblByb3BlcnR5O1xuICB9XG59XG4iXX0=