/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import no.priv.garshol.duke.ConfigWriter;
import no.priv.garshol.duke.DataSource;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.Logger;
import no.priv.garshol.duke.datasources.Column;
import org.xml.sax.helpers.AttributeListImpl;

public abstract class ColumnarDataSource
implements DataSource {
    protected Map<String, Collection<Column>> columns = new HashMap<String, Collection<Column>>();
    protected Logger logger;

    public void addColumn(Column column) {
        Collection<Column> cols = this.columns.get(column.getName());
        if (cols == null) {
            cols = new ArrayList<Column>();
            this.columns.put(column.getName(), cols);
        }
        cols.add(column);
    }

    public Collection<Column> getColumn(String name) {
        return this.columns.get(name);
    }

    public Collection<Column> getColumns() {
        ArrayList<Column> all = new ArrayList<Column>(this.columns.size());
        for (Collection<Column> col : this.columns.values()) {
            all.addAll(col);
        }
        return all;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected abstract String getSourceName();

    protected void verifyProperty(String value, String name) {
        if (value == null) {
            throw new DukeConfigException("Missing '" + name + "' property to " + this.getSourceName() + " data source");
        }
    }

    protected void writeColumnsConfig(ConfigWriter cw) {
        for (Column col : this.getColumns()) {
            AttributeListImpl atts = new AttributeListImpl();
            atts.addAttribute("name", "CDATA", col.getName());
            atts.addAttribute("property", "CDATA", col.getProperty());
            if (col.getPrefix() != null) {
                atts.addAttribute("prefix", "CDATA", col.getPrefix());
            }
            if (col.getCleaner() != null) {
                atts.addAttribute("cleaner", "CDATA", col.getCleaner().getClass().getName());
            }
            if (col.isSplit()) {
                atts.addAttribute("split-on", "CDATA", col.getSplitOn());
            }
            cw.writeStartElement("column", atts);
            cw.writeEndElement("column");
        }
    }
}

