/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import junit.framework.Assert;
import no.priv.garshol.duke.comparators.MetaphoneComparator;
import org.junit.Test;

public class MetaphoneComparatorTest {
    @Test
    public void testEmpty() {
        this.check("", "");
    }

    @Test
    public void testIndia() {
        this.check("INT", "India");
    }

    @Test
    public void testSmith() {
        this.check("SM0", "Smith");
    }

    @Test
    public void testHowl() {
        this.check("HL", "Howl");
    }

    @Test
    public void testTesting() {
        this.check("TSTNK", "testing");
    }

    @Test
    public void testTesting2() {
        this.check("TSTNK", "TESTING");
    }

    @Test
    public void testThe() {
        this.check("0", "The");
    }

    @Test
    public void testThe2() {
        this.check("0", "the");
    }

    @Test
    public void testBrown() {
        this.check("BRN", "Brown");
    }

    @Test
    public void testFox() {
        this.check("FKS", "Fox");
    }

    @Test
    public void testJumped() {
        this.check("JMPT", "Jumped");
    }

    @Test
    public void testOver() {
        this.check("OFR", "Over");
    }

    @Test
    public void testLazy() {
        this.check("LS", "Lazy");
    }

    @Test
    public void testDogs() {
        this.check("TKS", "dOGS");
    }

    @Test
    public void testComb() {
        this.check("KM", "Comb");
    }

    @Test
    public void testTomb() {
        this.check("TM", "Tomb");
    }

    @Test
    public void testWomb() {
        this.check("WM", "Womb");
    }

    @Test
    public void testWhy() {
        this.check("W", "Why");
    }

    @Test
    public void testCiapo() {
        this.check("XP", "Ciapo");
    }

    @Test
    public void testI() {
        this.check("I", "I");
    }

    @Test
    public void testIkk() {
        this.check("IK", "IKK");
    }

    @Test
    public void testIk() {
        this.check("IK", "IK");
    }

    @Test
    public void testEek() {
        this.check("EK", "eek");
    }

    @Test
    public void testIkkikkikk() {
        this.check("IKKK", "Ikkikkikk");
    }

    @Test
    public void testHicc() {
        this.check("HKK", "Hicc");
    }

    @Test
    public void testKnife() {
        this.check("NF", "Knife");
    }

    @Test
    public void testCesar() {
        this.check("SSR", "cesar");
    }

    @Test
    public void testChe() {
        this.check("X", "che");
    }

    @Test
    public void testCIA() {
        this.check("X", "CIA");
    }

    @Test
    public void testSchia() {
        this.check("SK", "Schia");
    }

    @Test
    public void testCa() {
        this.check("K", "Ca");
    }

    @Test
    public void testDodgy() {
        this.check("TJ", "Dodgy");
    }

    @Test
    public void testDoggy() {
        this.check("TK", "Doggy");
    }

    @Test
    public void testGi() {
        this.check("J", "Gi");
    }

    @Test
    public void testDig() {
        this.check("TK", "Dig");
    }

    @Test
    public void testDoge() {
        this.check("TJ", "Doge");
    }

    @Test
    public void testDoughy() {
        this.check("T", "Doughy");
    }

    @Test
    public void testRough() {
        this.check("R", "Rough");
    }

    @Test
    public void testGherkin() {
        this.check("RKN", "Gherkin");
    }

    @Test
    public void testAgnes() {
        this.check("ANS", "Agnes");
    }

    @Test
    public void testAha() {
        this.check("AH", "Aha");
    }

    @Test
    public void testKahn() {
        this.check("KN", "Kahn");
    }

    @Test
    public void testB() {
        this.check("B", "B");
    }

    @Test
    public void testPackage() {
        this.check("PKJ", "Package");
    }

    @Test
    public void testRalph() {
        this.check("RLF", "Ralph");
    }

    @Test
    public void testQuintin() {
        this.check("KNTN", "Quintin");
    }

    @Test
    public void testShit() {
        this.check("XT", "Shit");
    }

    @Test
    public void testConversion() {
        this.check("KNFRXN", "Conversion");
    }

    @Test
    public void testMartian() {
        this.check("MRXN", "Martian");
    }

    @Test
    public void testAitch() {
        this.check("AX", "Aitch");
    }

    @Test
    public void testXnxnx() {
        this.check("SNKSNKS", "Xnxnx");
    }

    @Test
    public void testOhyes() {
        this.check("OHYS", "ohyes");
    }

    @Test
    public void testXavier() {
        this.check("SFR", "Xavier");
    }

    @Test
    public void testAerated() {
        this.check("ERTT", "Aerated");
    }

    @Test
    public void testWrite() {
        this.check("RT", "Write");
    }

    @Test
    public void testSverdrup() {
        this.check("SFRTRP", "sverdrup");
    }

    private void check(String key, String value) {
        Assert.assertEquals((String)("wrong key for '" + value + "'"), (String)key, (String)MetaphoneComparator.metaphone((String)value));
    }
}

