/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.ConfigurationImpl;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.PropertyImpl;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.comparators.ExactComparator;
import no.priv.garshol.duke.utils.TestUtils;
import org.junit.Before;
import org.junit.Test;

public abstract class DatabaseTest {
    protected Database db;
    protected ConfigurationImpl config;

    @Before
    public void setup() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        props.add(new PropertyImpl("NAME", (Comparator)comp, 0.3, 0.8));
        props.add(new PropertyImpl("EMAIL", (Comparator)comp, 0.3, 0.8));
        this.config = new ConfigurationImpl();
        this.config.setProperties(props);
        this.config.setThreshold(0.85);
        this.config.setMaybeThreshold(0.8);
        this.db = this.createDatabase((Configuration)this.config);
    }

    public abstract Database createDatabase(Configuration var1) throws IOException;

    @Test
    public void testTrivial() throws IOException {
        Record record = TestUtils.makeRecord("ID", "1", "NAME", "AND", "EMAIL", "BBBBB");
        this.db.index(record);
        this.db.commit();
        record = this.db.findRecordById("1");
        Assert.assertTrue((String)"no record found", (record != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"wrong ID", (String)"1", (String)record.getValue("ID"));
        Assert.assertEquals((String)"wrong EMAIL", (String)"BBBBB", (String)record.getValue("EMAIL"));
    }

    @Test
    public void testBackslash() throws IOException {
        String name = "\"Lastname, Firstname \\(external\\)\"";
        Record record = TestUtils.makeRecord("ID", "1", "NAME", name, "EMAIL", "BBBBB");
        this.db.index(record);
        this.db.commit();
        Record record2 = TestUtils.makeRecord("NAME", "\"lastname, firstname \\(external\\)\"");
        this.db.findCandidateMatches(record2);
    }

    @Test
    public void testBNode() throws IOException {
        Record record = TestUtils.makeRecord("ID", "_:RHUKdfPM299", "NAME", "AND", "EMAIL", "BBBBB");
        this.db.index(record);
        this.db.commit();
        record = this.db.findRecordById("_:RHUKdfPM299");
        Assert.assertTrue((String)"no record found", (record != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"wrong ID", (String)"_:RHUKdfPM299", (String)record.getValue("ID"));
    }

    @Test
    public void testURI() throws IOException {
        Record record = TestUtils.makeRecord("ID", "http://norman.walsh.name/knows/who/robin-berjon", "NAME", "AND", "EMAIL", "BBBBB");
        this.db.index(record);
        this.db.commit();
        record = this.db.findRecordById("http://norman.walsh.name/knows/who/robin-berjon");
        Assert.assertTrue((String)"no record found", (record != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"wrong ID", (String)"http://norman.walsh.name/knows/who/robin-berjon", (String)record.getValue("ID"));
    }

    @Test
    public void testTrivialFind() throws IOException {
        Record record = TestUtils.makeRecord("ID", "1", "NAME", "AND", "EMAIL", "BBBBB");
        this.db.index(record);
        this.db.commit();
        Collection cands = this.db.findCandidateMatches(record);
        Assert.assertEquals((String)"no record found", (int)1, (int)cands.size());
        Assert.assertEquals((String)"wrong ID", (String)"1", (String)((Record)cands.iterator().next()).getValue("ID"));
    }

    @Test
    public void testRecordImplementation() throws IOException {
        Record record = TestUtils.makeRecord("ID", "1", "NAME", "AND", "EMAIL", "BBBBB");
        this.db.index(record);
        this.db.commit();
        record = this.db.findRecordById("1");
        Assert.assertEquals((String)"wrong ID", (String)"1", (String)record.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"AND", (String)record.getValue("NAME"));
        Assert.assertEquals((String)"wrong EMAIL", (String)"BBBBB", (String)record.getValue("EMAIL"));
        Collection props = record.getProperties();
        Assert.assertEquals((String)"wrong number of properties", (int)3, (int)props.size());
        Assert.assertTrue((String)"no ID", (boolean)props.contains("ID"));
        Assert.assertTrue((String)"no NAME", (boolean)props.contains("NAME"));
        Assert.assertTrue((String)"no EMAIL", (boolean)props.contains("EMAIL"));
    }

    @Test
    public void testBoostAt1() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        props.add(new PropertyImpl("NAME", (Comparator)comp, 0.3, 1.0));
        props.add(new PropertyImpl("EMAIL", (Comparator)comp, 0.3, 0.8));
        this.config = new ConfigurationImpl();
        this.config.setProperties(props);
        this.config.setThreshold(0.85);
        this.config.setMaybeThreshold(0.8);
        this.db = this.createDatabase((Configuration)this.config);
        Record record = TestUtils.makeRecord("ID", "1", "NAME", "George", "EMAIL", "BBBBB");
        this.db.index(record);
        this.db.commit();
        Collection cands = this.db.findCandidateMatches(record);
        Assert.assertEquals((String)"no record found", (int)1, (int)cands.size());
        Assert.assertEquals((String)"wrong ID", (String)"1", (String)((Record)cands.iterator().next()).getValue("ID"));
    }
}

