/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases;

import java.io.IOException;
import java.util.Collection;
import junit.framework.Assert;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.databases.DatabaseTest;
import no.priv.garshol.duke.utils.TestUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class PersistentDatabaseTest
extends DatabaseTest {
    @Rule
    public TemporaryFolder tmpdir = new TemporaryFolder();

    @Test
    public void testPersistence() throws IOException {
        Assert.assertTrue((String)"database claims to be in-memory", (!this.db.isInMemory() ? 1 : 0) != 0);
        Record record = TestUtils.makeRecord("ID", "1", "NAME", "AND", "EMAIL", "BBBBB");
        this.db.index(record);
        this.db.commit();
        this.db.close();
        this.db = this.createDatabase((Configuration)this.config);
        Record r = this.db.findRecordById("1");
        Assert.assertTrue((String)"record not found after reopening", (r != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"wrong ID", (String)"1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"AND", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong EMAIL", (String)"BBBBB", (String)r.getValue("EMAIL"));
        Collection recs = this.db.findCandidateMatches(record);
        Assert.assertEquals((String)"wrong number of records found", (int)1, (int)recs.size());
        r = (Record)recs.iterator().next();
        Assert.assertEquals((String)"wrong ID", (String)"1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"AND", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong EMAIL", (String)"BBBBB", (String)r.getValue("EMAIL"));
    }

    @Test
    public void testOverwrite() throws IOException {
        Assert.assertTrue((String)"database claims to be in-memory", (!this.db.isInMemory() ? 1 : 0) != 0);
        Record record = TestUtils.makeRecord("ID", "1", "NAME", "AND", "EMAIL", "BBBBB");
        this.db.index(record);
        this.db.commit();
        this.db.close();
        this.db = this.createDatabase((Configuration)this.config);
        this.db.setOverwrite(true);
        Record r = this.db.findRecordById("1");
        Assert.assertTrue((String)"record found after reopening, despite overwrite", (r == null ? 1 : 0) != 0);
    }

    @Test
    public void testChangeRecord() throws IOException {
        Assert.assertTrue((String)"database claims to be in-memory", (!this.db.isInMemory() ? 1 : 0) != 0);
        Record record = TestUtils.makeRecord("ID", "1", "NAME", "AND", "EMAIL", "BBBBB");
        this.db.index(record);
        this.db.commit();
        this.db.close();
        this.db = this.createDatabase((Configuration)this.config);
        Record record2 = TestUtils.makeRecord("ID", "1", "NAME", "LARS", "EMAIL", "BARS");
        this.db.index(record2);
        this.db.commit();
        Record r = this.db.findRecordById("1");
        Assert.assertTrue((String)"record not found", (r != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"wrong ID", (String)"1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"LARS", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong EMAIL", (String)"BARS", (String)r.getValue("EMAIL"));
        Collection recs = this.db.findCandidateMatches(record2);
        Assert.assertEquals((String)"wrong number of records found", (int)1, (int)recs.size());
        r = (Record)recs.iterator().next();
        Assert.assertEquals((String)"wrong ID", (String)"1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"LARS", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong EMAIL", (String)"BARS", (String)r.getValue("EMAIL"));
        recs = this.db.findCandidateMatches(record);
        Assert.assertEquals((String)"wrong number of records found", (int)0, (int)recs.size());
    }
}

