/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.genetic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.ConfigurationImpl;
import no.priv.garshol.duke.DataSource;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.PropertyImpl;
import no.priv.garshol.duke.comparators.ExactComparator;
import no.priv.garshol.duke.databases.InMemoryDatabase;
import no.priv.garshol.duke.datasources.CSVDataSource;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.genetic.GeneticAlgorithm;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ActiveLearningTest {
    @Rule
    public TemporaryFolder tmpdir = new TemporaryFolder();

    @Test
    public void testSmallData() throws IOException {
        File outfile = this.tmpdir.newFile("test.csv");
        FileWriter out = new FileWriter(outfile);
        out.write("id;name;age\n");
        out.write("1;LMG;39\n");
        out.write("2;GOG;40\n");
        out.write("3;GDM;29\n");
        out.write("4;AB;49\n");
        out.close();
        File tstfile = this.tmpdir.newFile("testfile.csv");
        out = new FileWriter(tstfile);
        out.close();
        CSVDataSource csv = new CSVDataSource();
        csv.setSeparator(';');
        csv.setInputFile(outfile.getAbsolutePath());
        csv.addColumn(new Column("id", null, null, null));
        csv.addColumn(new Column("name", null, null, null));
        csv.addColumn(new Column("age", null, null, null));
        ConfigurationImpl cfg = new ConfigurationImpl();
        cfg.addDatabase((Database)new InMemoryDatabase());
        cfg.addDataSource(0, (DataSource)csv);
        ExactComparator cmp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("id"));
        props.add(new PropertyImpl("name", (Comparator)cmp, 0.0, 1.0));
        props.add(new PropertyImpl("age", (Comparator)cmp, 0.0, 1.0));
        cfg.setProperties(props);
        GeneticAlgorithm gen = new GeneticAlgorithm((Configuration)cfg, tstfile.getAbsolutePath(), true);
        gen.setQuiet(true);
        gen.run();
    }
}

