/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases.es;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordImpl;
import no.priv.garshol.duke.databases.es.StorageType;
import no.priv.garshol.duke.utils.Utils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;

public class ElasticSearchDatabase
implements Database {
    private static final int HOST_PORT_DEFAULT = 9300;
    private static final String[] DATA_SUBDIRS = new String[]{"data", "work", "logs"};
    private Configuration config;
    private Property idProperty;
    private boolean overwrite;
    private Client client;
    private Node node;
    private String cluster = "duke-es";
    private boolean clientOnly = false;
    private boolean local = true;
    private boolean clientSniff = true;
    private StorageType storageType = StorageType.MEMORY;
    private String dataFolder;
    private Collection<String> tAddresses;
    private Analyzer analyzer = new StandardAnalyzer();
    private BulkRequestBuilder bulkRequest;
    private int bulkRequestCounter;
    private int bulkSize = 5000;
    private String indexName = "duke";
    private String indexType = "record";
    private int maxSearchHits = 100;

    private void init() {
        Collection identityProperties;
        this.setupConnection();
        IndicesExistsResponse response = (IndicesExistsResponse)this.client.admin().indices().exists(new IndicesExistsRequest(new String[]{this.indexName})).actionGet();
        boolean forceCreate = false;
        if (response.isExists() && !this.overwrite) {
            this.client.admin().indices().prepareDelete(new String[]{this.indexName}).execute().actionGet();
            forceCreate = true;
        }
        if (!response.isExists() || forceCreate) {
            CreateIndexResponse create = (CreateIndexResponse)this.client.admin().indices().prepareCreate(this.indexName).execute().actionGet();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for index to settle in", e);
            }
            if (!create.isAcknowledged()) {
                throw new IllegalArgumentException("Could not create index: " + this.indexName);
            }
        }
        if ((identityProperties = this.config.getIdentityProperties()) == null || identityProperties.size() != 1) {
            throw new IllegalStateException("Unable to handle entities without single id");
        }
        this.idProperty = (Property)Iterables.get((Iterable)identityProperties, (int)0);
        ImmutableSettings.Builder indexSettings = ImmutableSettings.settingsBuilder();
        indexSettings.put("refresh_interval", -1);
        this.client.admin().indices().prepareUpdateSettings(new String[]{this.indexName}).setSettings((Settings.Builder)indexSettings).execute().actionGet();
        this.bulkRequest = this.client.prepareBulk();
    }

    private void setupConnection() {
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
        settings.put("cluster.name", this.cluster);
        if (this.tAddresses == null) {
            NodeBuilder builder = NodeBuilder.nodeBuilder();
            File dFolder = null;
            if (this.dataFolder == null) {
                dFolder = Utils.createTempDirectory((String)"duke-es");
            } else {
                dFolder = new File(this.dataFolder);
                if (!dFolder.exists()) {
                    dFolder.mkdirs();
                }
            }
            System.out.println("ElasicSearch node folder " + dFolder);
            for (String sub : DATA_SUBDIRS) {
                String subdir = dFolder.getPath() + File.separator + sub;
                File f = new File(subdir);
                if (!f.exists()) {
                    f.mkdirs();
                }
                settings.put("path." + sub, subdir);
            }
            if (this.storageType == StorageType.MEMORY) {
                settings.put("index.store.type", "memory");
            }
            builder.settings(settings.build());
            this.node = builder.client(this.clientOnly).local(this.local).node();
            this.client = this.node.client();
        } else {
            settings.put("client.transport.sniff", this.clientSniff);
            this.client = new TransportClient(settings.build());
            for (String address : this.tAddresses) {
                String[] hostparts = address.split(":");
                String hostname = hostparts[0];
                int hostport = 9300;
                if (hostparts.length == 2) {
                    hostport = Integer.parseInt(hostparts[1]);
                }
                ((TransportClient)this.client).addTransportAddress((TransportAddress)new InetSocketTransportAddress(hostname, hostport));
            }
        }
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
        System.out.println("ElasticSearch Health Check " + actionGet);
    }

    public boolean isInMemory() {
        return this.storageType == StorageType.MEMORY;
    }

    public void index(Record record) {
        if (this.client == null) {
            this.init();
        }
        String id = null;
        HashMap<String, Object> json = new HashMap<String, Object>();
        for (String propname : record.getProperties()) {
            Property prop = this.config.getPropertyByName(propname);
            if (prop == null) {
                throw new DukeConfigException("Record has property " + propname + " for which there is no configuration");
            }
            if (prop.isIdProperty()) {
                id = record.getValue(propname);
                continue;
            }
            Collection values = record.getValues(propname);
            if (values == null || values.isEmpty()) continue;
            if (values.size() == 1) {
                json.put(propname, Iterables.get((Iterable)values, (int)0));
                continue;
            }
            json.put(propname, values);
        }
        this.addToIndex(id, json);
    }

    public void commit() {
        if (this.client != null) {
            this.flushIndex(true);
            this.client.admin().indices().refresh(new RefreshRequest(new String[]{this.indexName})).actionGet();
            ImmutableSettings.Builder indexSettings = ImmutableSettings.settingsBuilder();
            indexSettings.put("refresh_interval", 1);
            this.client.admin().indices().prepareUpdateSettings(new String[]{this.indexName}).setSettings((Settings.Builder)indexSettings).execute().actionGet();
            this.client.admin().indices().prepareOptimize(new String[]{this.indexName}).setMaxNumSegments(5).execute().actionGet();
        }
    }

    public Record findRecordById(String id) {
        GetResponse getResponse = (GetResponse)this.client.prepareGet(this.indexName, this.indexType, id).execute().actionGet();
        return this.readFromSource(getResponse.getId(), getResponse.getSource());
    }

    public Collection<Record> findCandidateMatches(Record record) {
        SearchHit[] results;
        ArrayList<Record> records = new ArrayList<Record>();
        BoolQueryBuilder bqb = QueryBuilders.boolQuery();
        for (Property prop : this.config.getLookupProperties()) {
            String propName = prop.getName();
            boolean required = prop.getLookupBehaviour() == Property.Lookup.REQUIRED;
            Collection values = record.getValues(propName);
            if (values == null) continue;
            StringBuilder queryString = new StringBuilder();
            for (String v : values) {
                try {
                    TokenStream tokenStream = this.analyzer.tokenStream(propName, (Reader)new StringReader(v));
                    tokenStream.reset();
                    CharTermAttribute attr = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
                    while (tokenStream.incrementToken()) {
                        queryString.append(attr.toString()).append(" ");
                    }
                    tokenStream.close();
                }
                catch (IOException e) {
                    throw new DukeException("Error parsing input string '" + v + "' in field " + propName);
                }
            }
            Float boostFactor = this.getBoostFactor(prop.getHighProbability());
            if (queryString.length() <= 0) continue;
            QueryStringQueryBuilder qsqb = QueryBuilders.queryString((String)queryString.toString().trim()).defaultField(propName).boost(boostFactor.floatValue());
            bqb = required ? bqb.must((QueryBuilder)qsqb) : bqb.should((QueryBuilder)qsqb);
        }
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setTypes(new String[]{this.indexType}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)bqb).setSize(this.maxSearchHits).execute().actionGet();
        for (SearchHit hit : results = response.getHits().getHits()) {
            records.add(this.readFromSource(hit.getId(), hit.getSource()));
        }
        return records;
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        if (this.node != null && !this.node.isClosed()) {
            this.node.close();
            this.node = null;
        }
    }

    public String toString() {
        return "ElasticSearchDatabase [idProperty=" + this.idProperty + ", overwrite=" + this.overwrite + ", client=" + this.client + ", node=" + this.node + ", cluster=" + this.cluster + ", clientOnly=" + this.clientOnly + ", local=" + this.local + ", clientSniff=" + this.clientSniff + ", storageType=" + (Object)((Object)this.storageType) + ", dataFolder=" + this.dataFolder + ", tAddresses=" + this.tAddresses + ", bulkSize=" + this.bulkSize + ", indexName=" + this.indexName + ", indexType=" + this.indexType + ", maxSearchHits=" + this.maxSearchHits + "]";
    }

    private Record readFromSource(String id, Map<String, Object> source) {
        RecordImpl record = null;
        if (source != null) {
            record = new RecordImpl();
            record.addValue(this.idProperty.getName(), id);
            for (String key : source.keySet()) {
                Object value = source.get(key);
                if (value instanceof Collection) {
                    for (Object v : (Collection)value) {
                        record.addValue(key, v.toString());
                    }
                    continue;
                }
                record.addValue(key, value.toString());
            }
        }
        return record;
    }

    private void addToIndex(String id, Map<String, Object> json) {
        this.bulkRequest.add(this.client.prepareIndex(this.indexName, this.indexType, id).setSource(json));
        ++this.bulkRequestCounter;
        this.flushIndex(false);
    }

    private void flushIndex(boolean force) {
        if (force && this.bulkRequestCounter > 0 || this.bulkRequestCounter >= this.bulkSize) {
            BulkResponse bulkResponse = (BulkResponse)this.bulkRequest.execute().actionGet();
            if (bulkResponse.hasFailures()) {
                throw new DukeException(bulkResponse.buildFailureMessage());
            }
            this.bulkRequestCounter = 0;
            this.bulkRequest = this.client.prepareBulk();
        }
    }

    private Float getBoostFactor(double probability) {
        return Float.valueOf((float)Math.sqrt(1.0 / ((1.0 - probability) * 2.0)));
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setMaxSearchHits(int maxSearchHits) {
        this.maxSearchHits = maxSearchHits;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }
}

