'''
# AWS::Lex Construct Library

<!--BEGIN STABILITY BANNER-->---


![cfn-resources: Stable](https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge)

> All classes with the `Cfn` prefix in this module ([CFN Resources](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) are always stable and safe to use.

---
<!--END STABILITY BANNER-->

This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.

```python
import aws_cdk.aws_lex as lex
```

<!--BEGIN CFNONLY DISCLAIMER-->

There are no official hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet. Here are some suggestions on how to proceed:

* Search [Construct Hub for Lex construct libraries](https://constructs.dev/search?q=lex)
* Use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, in the same way you would use [the CloudFormation AWS::Lex resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_Lex.html) directly.

<!--BEGIN CFNONLY DISCLAIMER-->

There are no hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet.
However, you can still use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, and use this service exactly as you would using CloudFormation directly.

For more information on the resources and properties available for this service, see the [CloudFormation documentation for AWS::Lex](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_Lex.html).

(Read the [CDK Contributing Guide](https://github.com/aws/aws-cdk/blob/master/CONTRIBUTING.md) and submit an RFC if you are interested in contributing to this construct library.)

<!--END CFNONLY DISCLAIMER-->
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from ._jsii import *

import aws_cdk.core as _aws_cdk_core_f4b25747


@jsii.implements(_aws_cdk_core_f4b25747.IInspectable)
class CfnBot(
    _aws_cdk_core_f4b25747.CfnResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@aws-cdk/aws-lex.CfnBot",
):
    '''A CloudFormation ``AWS::Lex::Bot``.

    .. epigraph::

       Amazon Lex V2 is the only supported version in AWS CloudFormation .

    Specifies an Amazon Lex conversational bot.

    You must configure an intent based on the ``AMAZON.FallbackIntent`` built-in intent. If you don't add one, creating the bot will fail.

    :cloudformationResource: AWS::Lex::Bot
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        import aws_cdk.aws_lex as lex
        
        # data_privacy: Any
        # sentiment_analysis_settings: Any
        # slot_value_override_property_: lex.CfnBot.SlotValueOverrideProperty
        
        cfn_bot = lex.CfnBot(self, "MyCfnBot",
            data_privacy=data_privacy,
            idle_session_ttl_in_seconds=123,
            name="name",
            role_arn="roleArn",
        
            # the properties below are optional
            auto_build_bot_locales=False,
            bot_file_s3_location=lex.CfnBot.S3LocationProperty(
                s3_bucket="s3Bucket",
                s3_object_key="s3ObjectKey",
        
                # the properties below are optional
                s3_object_version="s3ObjectVersion"
            ),
            bot_locales=[lex.CfnBot.BotLocaleProperty(
                locale_id="localeId",
                nlu_confidence_threshold=123,
        
                # the properties below are optional
                custom_vocabulary=lex.CfnBot.CustomVocabularyProperty(
                    custom_vocabulary_items=[lex.CfnBot.CustomVocabularyItemProperty(
                        phrase="phrase",
        
                        # the properties below are optional
                        display_as="displayAs",
                        weight=123
                    )]
                ),
                description="description",
                intents=[lex.CfnBot.IntentProperty(
                    name="name",
        
                    # the properties below are optional
                    description="description",
                    dialog_code_hook=lex.CfnBot.DialogCodeHookSettingProperty(
                        enabled=False
                    ),
                    fulfillment_code_hook=lex.CfnBot.FulfillmentCodeHookSettingProperty(
                        enabled=False,
        
                        # the properties below are optional
                        fulfillment_updates_specification=lex.CfnBot.FulfillmentUpdatesSpecificationProperty(
                            active=False,
        
                            # the properties below are optional
                            start_response=lex.CfnBot.FulfillmentStartResponseSpecificationProperty(
                                delay_in_seconds=123,
                                message_groups=[lex.CfnBot.MessageGroupProperty(
                                    message=lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
        
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    ),
        
                                    # the properties below are optional
                                    variations=[lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
        
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    )]
                                )],
        
                                # the properties below are optional
                                allow_interrupt=False
                            ),
                            timeout_in_seconds=123,
                            update_response=lex.CfnBot.FulfillmentUpdateResponseSpecificationProperty(
                                frequency_in_seconds=123,
                                message_groups=[lex.CfnBot.MessageGroupProperty(
                                    message=lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
        
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    ),
        
                                    # the properties below are optional
                                    variations=[lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
        
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    )]
                                )],
        
                                # the properties below are optional
                                allow_interrupt=False
                            )
                        ),
                        is_active=False,
                        post_fulfillment_status_specification=lex.CfnBot.PostFulfillmentStatusSpecificationProperty(
                            failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                    condition=lex.CfnBot.ConditionProperty(
                                        expression_string="expressionString"
                                    ),
                                    name="name",
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
        
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
        
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
        
                                    # the properties below are optional
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
        
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
        
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
        
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
        
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                )],
                                default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
        
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
        
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
        
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
        
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
        
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
        
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                ),
                                is_active=False
                            ),
                            failure_next_step=lex.CfnBot.DialogStateProperty(
                                dialog_action=lex.CfnBot.DialogActionProperty(
                                    type="type",
        
                                    # the properties below are optional
                                    slot_to_elicit="slotToElicit",
                                    suppress_next_message=False
                                ),
                                intent=lex.CfnBot.IntentOverrideProperty(
                                    name="name",
                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                        slot_name="slotName",
                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                            shape="shape",
                                            value=lex.CfnBot.SlotValueProperty(
                                                interpreted_value="interpretedValue"
                                            ),
                                            values=[slot_value_override_property_]
                                        )
                                    )]
                                ),
                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                    key="key",
        
                                    # the properties below are optional
                                    value="value"
                                )]
                            ),
                            failure_response=lex.CfnBot.ResponseSpecificationProperty(
                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                    message=lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
        
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    ),
        
                                    # the properties below are optional
                                    variations=[lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
        
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    )]
                                )],
        
                                # the properties below are optional
                                allow_interrupt=False
                            ),
                            success_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                    condition=lex.CfnBot.ConditionProperty(
                                        expression_string="expressionString"
                                    ),
                                    name="name",
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
        
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
        
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
        
                                    # the properties below are optional
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
        
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
        
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
        
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
        
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                )],
                                default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
        
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
        
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
        
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
        
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
        
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
        
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                ),
                                is_active=False
                            ),
                            success_next_step=lex.CfnBot.DialogStateProperty(
                                dialog_action=lex.CfnBot.DialogActionProperty(
                                    type="type",
        
                                    # the properties below are optional
                                    slot_to_elicit="slotToElicit",
                                    suppress_next_message=False
                                ),
                                intent=lex.CfnBot.IntentOverrideProperty(
                                    name="name",
                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                        slot_name="slotName",
                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                            shape="shape",
                                            value=lex.CfnBot.SlotValueProperty(
                                                interpreted_value="interpretedValue"
                                            ),
                                            values=[slot_value_override_property_]
                                        )
                                    )]
                                ),
                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                    key="key",
        
                                    # the properties below are optional
                                    value="value"
                                )]
                            ),
                            success_response=lex.CfnBot.ResponseSpecificationProperty(
                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                    message=lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
        
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    ),
        
                                    # the properties below are optional
                                    variations=[lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
        
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    )]
                                )],
        
                                # the properties below are optional
                                allow_interrupt=False
                            ),
                            timeout_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                    condition=lex.CfnBot.ConditionProperty(
                                        expression_string="expressionString"
                                    ),
                                    name="name",
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
        
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
        
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
        
                                    # the properties below are optional
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
        
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
        
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
        
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
        
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                )],
                                default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
        
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
        
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
        
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
        
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
        
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
        
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                ),
                                is_active=False
                            ),
                            timeout_next_step=lex.CfnBot.DialogStateProperty(
                                dialog_action=lex.CfnBot.DialogActionProperty(
                                    type="type",
        
                                    # the properties below are optional
                                    slot_to_elicit="slotToElicit",
                                    suppress_next_message=False
                                ),
                                intent=lex.CfnBot.IntentOverrideProperty(
                                    name="name",
                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                        slot_name="slotName",
                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                            shape="shape",
                                            value=lex.CfnBot.SlotValueProperty(
                                                interpreted_value="interpretedValue"
                                            ),
                                            values=[slot_value_override_property_]
                                        )
                                    )]
                                ),
                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                    key="key",
        
                                    # the properties below are optional
                                    value="value"
                                )]
                            ),
                            timeout_response=lex.CfnBot.ResponseSpecificationProperty(
                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                    message=lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
        
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    ),
        
                                    # the properties below are optional
                                    variations=[lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
        
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    )]
                                )],
        
                                # the properties below are optional
                                allow_interrupt=False
                            )
                        )
                    ),
                    initial_response_setting=lex.CfnBot.InitialResponseSettingProperty(
                        code_hook=lex.CfnBot.DialogCodeHookInvocationSettingProperty(
                            enable_code_hook_invocation=False,
                            is_active=False,
                            post_code_hook_specification=lex.CfnBot.PostDialogCodeHookInvocationSpecificationProperty(
                                failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                    conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                        condition=lex.CfnBot.ConditionProperty(
                                            expression_string="expressionString"
                                        ),
                                        name="name",
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
        
                                        # the properties below are optional
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    )],
                                    default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    ),
                                    is_active=False
                                ),
                                failure_next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                failure_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                ),
                                success_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                    conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                        condition=lex.CfnBot.ConditionProperty(
                                            expression_string="expressionString"
                                        ),
                                        name="name",
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
        
                                        # the properties below are optional
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    )],
                                    default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    ),
                                    is_active=False
                                ),
                                success_next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                success_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                ),
                                timeout_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                    conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                        condition=lex.CfnBot.ConditionProperty(
                                            expression_string="expressionString"
                                        ),
                                        name="name",
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
        
                                        # the properties below are optional
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    )],
                                    default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    ),
                                    is_active=False
                                ),
                                timeout_next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                timeout_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
        
                            # the properties below are optional
                            invocation_label="invocationLabel"
                        ),
                        conditional=lex.CfnBot.ConditionalSpecificationProperty(
                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                condition=lex.CfnBot.ConditionProperty(
                                    expression_string="expressionString"
                                ),
                                name="name",
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
        
                                # the properties below are optional
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            )],
                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
                            is_active=False
                        ),
                        initial_response=lex.CfnBot.ResponseSpecificationProperty(
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
        
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
        
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
        
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
        
                            # the properties below are optional
                            allow_interrupt=False
                        ),
                        next_step=lex.CfnBot.DialogStateProperty(
                            dialog_action=lex.CfnBot.DialogActionProperty(
                                type="type",
        
                                # the properties below are optional
                                slot_to_elicit="slotToElicit",
                                suppress_next_message=False
                            ),
                            intent=lex.CfnBot.IntentOverrideProperty(
                                name="name",
                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                    slot_name="slotName",
                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                        shape="shape",
                                        value=lex.CfnBot.SlotValueProperty(
                                            interpreted_value="interpretedValue"
                                        ),
                                        values=[slot_value_override_property_]
                                    )
                                )]
                            ),
                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                key="key",
        
                                # the properties below are optional
                                value="value"
                            )]
                        )
                    ),
                    input_contexts=[lex.CfnBot.InputContextProperty(
                        name="name"
                    )],
                    intent_closing_setting=lex.CfnBot.IntentClosingSettingProperty(
                        closing_response=lex.CfnBot.ResponseSpecificationProperty(
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
        
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
        
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
        
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
        
                            # the properties below are optional
                            allow_interrupt=False
                        ),
                        conditional=lex.CfnBot.ConditionalSpecificationProperty(
                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                condition=lex.CfnBot.ConditionProperty(
                                    expression_string="expressionString"
                                ),
                                name="name",
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
        
                                # the properties below are optional
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            )],
                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
                            is_active=False
                        ),
                        is_active=False,
                        next_step=lex.CfnBot.DialogStateProperty(
                            dialog_action=lex.CfnBot.DialogActionProperty(
                                type="type",
        
                                # the properties below are optional
                                slot_to_elicit="slotToElicit",
                                suppress_next_message=False
                            ),
                            intent=lex.CfnBot.IntentOverrideProperty(
                                name="name",
                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                    slot_name="slotName",
                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                        shape="shape",
                                        value=lex.CfnBot.SlotValueProperty(
                                            interpreted_value="interpretedValue"
                                        ),
                                        values=[slot_value_override_property_]
                                    )
                                )]
                            ),
                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                key="key",
        
                                # the properties below are optional
                                value="value"
                            )]
                        )
                    ),
                    intent_confirmation_setting=lex.CfnBot.IntentConfirmationSettingProperty(
                        prompt_specification=lex.CfnBot.PromptSpecificationProperty(
                            max_retries=123,
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
        
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
        
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
        
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
        
                            # the properties below are optional
                            allow_interrupt=False,
                            message_selection_strategy="messageSelectionStrategy",
                            prompt_attempts_specification={
                                "prompt_attempts_specification_key": lex.CfnBot.PromptAttemptSpecificationProperty(
                                    allowed_input_types=lex.CfnBot.AllowedInputTypesProperty(
                                        allow_audio_input=False,
                                        allow_dtmf_input=False
                                    ),
        
                                    # the properties below are optional
                                    allow_interrupt=False,
                                    audio_and_dtmf_input_specification=lex.CfnBot.AudioAndDTMFInputSpecificationProperty(
                                        start_timeout_ms=123,
        
                                        # the properties below are optional
                                        audio_specification=lex.CfnBot.AudioSpecificationProperty(
                                            end_timeout_ms=123,
                                            max_length_ms=123
                                        ),
                                        dtmf_specification=lex.CfnBot.DTMFSpecificationProperty(
                                            deletion_character="deletionCharacter",
                                            end_character="endCharacter",
                                            end_timeout_ms=123,
                                            max_length=123
                                        )
                                    ),
                                    text_input_specification=lex.CfnBot.TextInputSpecificationProperty(
                                        start_timeout_ms=123
                                    )
                                )
                            }
                        ),
        
                        # the properties below are optional
                        code_hook=lex.CfnBot.DialogCodeHookInvocationSettingProperty(
                            enable_code_hook_invocation=False,
                            is_active=False,
                            post_code_hook_specification=lex.CfnBot.PostDialogCodeHookInvocationSpecificationProperty(
                                failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                    conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                        condition=lex.CfnBot.ConditionProperty(
                                            expression_string="expressionString"
                                        ),
                                        name="name",
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
        
                                        # the properties below are optional
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    )],
                                    default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    ),
                                    is_active=False
                                ),
                                failure_next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                failure_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                ),
                                success_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                    conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                        condition=lex.CfnBot.ConditionProperty(
                                            expression_string="expressionString"
                                        ),
                                        name="name",
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
        
                                        # the properties below are optional
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    )],
                                    default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    ),
                                    is_active=False
                                ),
                                success_next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                success_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                ),
                                timeout_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                    conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                        condition=lex.CfnBot.ConditionProperty(
                                            expression_string="expressionString"
                                        ),
                                        name="name",
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
        
                                        # the properties below are optional
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    )],
                                    default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    ),
                                    is_active=False
                                ),
                                timeout_next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                timeout_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
        
                            # the properties below are optional
                            invocation_label="invocationLabel"
                        ),
                        confirmation_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                condition=lex.CfnBot.ConditionProperty(
                                    expression_string="expressionString"
                                ),
                                name="name",
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
        
                                # the properties below are optional
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            )],
                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
                            is_active=False
                        ),
                        confirmation_next_step=lex.CfnBot.DialogStateProperty(
                            dialog_action=lex.CfnBot.DialogActionProperty(
                                type="type",
        
                                # the properties below are optional
                                slot_to_elicit="slotToElicit",
                                suppress_next_message=False
                            ),
                            intent=lex.CfnBot.IntentOverrideProperty(
                                name="name",
                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                    slot_name="slotName",
                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                        shape="shape",
                                        value=lex.CfnBot.SlotValueProperty(
                                            interpreted_value="interpretedValue"
                                        ),
                                        values=[slot_value_override_property_]
                                    )
                                )]
                            ),
                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                key="key",
        
                                # the properties below are optional
                                value="value"
                            )]
                        ),
                        confirmation_response=lex.CfnBot.ResponseSpecificationProperty(
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
        
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
        
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
        
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
        
                            # the properties below are optional
                            allow_interrupt=False
                        ),
                        declination_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                condition=lex.CfnBot.ConditionProperty(
                                    expression_string="expressionString"
                                ),
                                name="name",
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
        
                                # the properties below are optional
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            )],
                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
                            is_active=False
                        ),
                        declination_next_step=lex.CfnBot.DialogStateProperty(
                            dialog_action=lex.CfnBot.DialogActionProperty(
                                type="type",
        
                                # the properties below are optional
                                slot_to_elicit="slotToElicit",
                                suppress_next_message=False
                            ),
                            intent=lex.CfnBot.IntentOverrideProperty(
                                name="name",
                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                    slot_name="slotName",
                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                        shape="shape",
                                        value=lex.CfnBot.SlotValueProperty(
                                            interpreted_value="interpretedValue"
                                        ),
                                        values=[slot_value_override_property_]
                                    )
                                )]
                            ),
                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                key="key",
        
                                # the properties below are optional
                                value="value"
                            )]
                        ),
                        declination_response=lex.CfnBot.ResponseSpecificationProperty(
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
        
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
        
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
        
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
        
                            # the properties below are optional
                            allow_interrupt=False
                        ),
                        elicitation_code_hook=lex.CfnBot.ElicitationCodeHookInvocationSettingProperty(
                            enable_code_hook_invocation=False,
        
                            # the properties below are optional
                            invocation_label="invocationLabel"
                        ),
                        failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                condition=lex.CfnBot.ConditionProperty(
                                    expression_string="expressionString"
                                ),
                                name="name",
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
        
                                # the properties below are optional
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            )],
                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
                            is_active=False
                        ),
                        failure_next_step=lex.CfnBot.DialogStateProperty(
                            dialog_action=lex.CfnBot.DialogActionProperty(
                                type="type",
        
                                # the properties below are optional
                                slot_to_elicit="slotToElicit",
                                suppress_next_message=False
                            ),
                            intent=lex.CfnBot.IntentOverrideProperty(
                                name="name",
                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                    slot_name="slotName",
                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                        shape="shape",
                                        value=lex.CfnBot.SlotValueProperty(
                                            interpreted_value="interpretedValue"
                                        ),
                                        values=[slot_value_override_property_]
                                    )
                                )]
                            ),
                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                key="key",
        
                                # the properties below are optional
                                value="value"
                            )]
                        ),
                        failure_response=lex.CfnBot.ResponseSpecificationProperty(
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
        
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
        
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
        
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
        
                            # the properties below are optional
                            allow_interrupt=False
                        ),
                        is_active=False
                    ),
                    kendra_configuration=lex.CfnBot.KendraConfigurationProperty(
                        kendra_index="kendraIndex",
        
                        # the properties below are optional
                        query_filter_string="queryFilterString",
                        query_filter_string_enabled=False
                    ),
                    output_contexts=[lex.CfnBot.OutputContextProperty(
                        name="name",
                        time_to_live_in_seconds=123,
                        turns_to_live=123
                    )],
                    parent_intent_signature="parentIntentSignature",
                    sample_utterances=[lex.CfnBot.SampleUtteranceProperty(
                        utterance="utterance"
                    )],
                    slot_priorities=[lex.CfnBot.SlotPriorityProperty(
                        priority=123,
                        slot_name="slotName"
                    )],
                    slots=[lex.CfnBot.SlotProperty(
                        name="name",
                        slot_type_name="slotTypeName",
                        value_elicitation_setting=lex.CfnBot.SlotValueElicitationSettingProperty(
                            slot_constraint="slotConstraint",
        
                            # the properties below are optional
                            default_value_specification=lex.CfnBot.SlotDefaultValueSpecificationProperty(
                                default_value_list=[lex.CfnBot.SlotDefaultValueProperty(
                                    default_value="defaultValue"
                                )]
                            ),
                            prompt_specification=lex.CfnBot.PromptSpecificationProperty(
                                max_retries=123,
                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                    message=lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
        
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    ),
        
                                    # the properties below are optional
                                    variations=[lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
        
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    )]
                                )],
        
                                # the properties below are optional
                                allow_interrupt=False,
                                message_selection_strategy="messageSelectionStrategy",
                                prompt_attempts_specification={
                                    "prompt_attempts_specification_key": lex.CfnBot.PromptAttemptSpecificationProperty(
                                        allowed_input_types=lex.CfnBot.AllowedInputTypesProperty(
                                            allow_audio_input=False,
                                            allow_dtmf_input=False
                                        ),
        
                                        # the properties below are optional
                                        allow_interrupt=False,
                                        audio_and_dtmf_input_specification=lex.CfnBot.AudioAndDTMFInputSpecificationProperty(
                                            start_timeout_ms=123,
        
                                            # the properties below are optional
                                            audio_specification=lex.CfnBot.AudioSpecificationProperty(
                                                end_timeout_ms=123,
                                                max_length_ms=123
                                            ),
                                            dtmf_specification=lex.CfnBot.DTMFSpecificationProperty(
                                                deletion_character="deletionCharacter",
                                                end_character="endCharacter",
                                                end_timeout_ms=123,
                                                max_length=123
                                            )
                                        ),
                                        text_input_specification=lex.CfnBot.TextInputSpecificationProperty(
                                            start_timeout_ms=123
                                        )
                                    )
                                }
                            ),
                            sample_utterances=[lex.CfnBot.SampleUtteranceProperty(
                                utterance="utterance"
                            )],
                            slot_capture_setting=lex.CfnBot.SlotCaptureSettingProperty(
                                capture_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                    conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                        condition=lex.CfnBot.ConditionProperty(
                                            expression_string="expressionString"
                                        ),
                                        name="name",
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
        
                                        # the properties below are optional
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    )],
                                    default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    ),
                                    is_active=False
                                ),
                                capture_next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                capture_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                ),
                                code_hook=lex.CfnBot.DialogCodeHookInvocationSettingProperty(
                                    enable_code_hook_invocation=False,
                                    is_active=False,
                                    post_code_hook_specification=lex.CfnBot.PostDialogCodeHookInvocationSpecificationProperty(
                                        failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                                condition=lex.CfnBot.ConditionProperty(
                                                    expression_string="expressionString"
                                                ),
                                                name="name",
                                                next_step=lex.CfnBot.DialogStateProperty(
                                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                                        type="type",
        
                                                        # the properties below are optional
                                                        slot_to_elicit="slotToElicit",
                                                        suppress_next_message=False
                                                    ),
                                                    intent=lex.CfnBot.IntentOverrideProperty(
                                                        name="name",
                                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                            slot_name="slotName",
                                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                                shape="shape",
                                                                value=lex.CfnBot.SlotValueProperty(
                                                                    interpreted_value="interpretedValue"
                                                                ),
                                                                values=[slot_value_override_property_]
                                                            )
                                                        )]
                                                    ),
                                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                        key="key",
        
                                                        # the properties below are optional
                                                        value="value"
                                                    )]
                                                ),
        
                                                # the properties below are optional
                                                response=lex.CfnBot.ResponseSpecificationProperty(
                                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                        message=lex.CfnBot.MessageProperty(
                                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                value="value"
                                                            ),
                                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                title="title",
        
                                                                # the properties below are optional
                                                                buttons=[lex.CfnBot.ButtonProperty(
                                                                    text="text",
                                                                    value="value"
                                                                )],
                                                                image_url="imageUrl",
                                                                subtitle="subtitle"
                                                            ),
                                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                value="value"
                                                            ),
                                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                value="value"
                                                            )
                                                        ),
        
                                                        # the properties below are optional
                                                        variations=[lex.CfnBot.MessageProperty(
                                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                value="value"
                                                            ),
                                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                title="title",
        
                                                                # the properties below are optional
                                                                buttons=[lex.CfnBot.ButtonProperty(
                                                                    text="text",
                                                                    value="value"
                                                                )],
                                                                image_url="imageUrl",
                                                                subtitle="subtitle"
                                                            ),
                                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                value="value"
                                                            ),
                                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                value="value"
                                                            )
                                                        )]
                                                    )],
        
                                                    # the properties below are optional
                                                    allow_interrupt=False
                                                )
                                            )],
                                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                                next_step=lex.CfnBot.DialogStateProperty(
                                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                                        type="type",
        
                                                        # the properties below are optional
                                                        slot_to_elicit="slotToElicit",
                                                        suppress_next_message=False
                                                    ),
                                                    intent=lex.CfnBot.IntentOverrideProperty(
                                                        name="name",
                                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                            slot_name="slotName",
                                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                                shape="shape",
                                                                value=lex.CfnBot.SlotValueProperty(
                                                                    interpreted_value="interpretedValue"
                                                                ),
                                                                values=[slot_value_override_property_]
                                                            )
                                                        )]
                                                    ),
                                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                        key="key",
        
                                                        # the properties below are optional
                                                        value="value"
                                                    )]
                                                ),
                                                response=lex.CfnBot.ResponseSpecificationProperty(
                                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                        message=lex.CfnBot.MessageProperty(
                                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                value="value"
                                                            ),
                                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                title="title",
        
                                                                # the properties below are optional
                                                                buttons=[lex.CfnBot.ButtonProperty(
                                                                    text="text",
                                                                    value="value"
                                                                )],
                                                                image_url="imageUrl",
                                                                subtitle="subtitle"
                                                            ),
                                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                value="value"
                                                            ),
                                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                value="value"
                                                            )
                                                        ),
        
                                                        # the properties below are optional
                                                        variations=[lex.CfnBot.MessageProperty(
                                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                value="value"
                                                            ),
                                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                title="title",
        
                                                                # the properties below are optional
                                                                buttons=[lex.CfnBot.ButtonProperty(
                                                                    text="text",
                                                                    value="value"
                                                                )],
                                                                image_url="imageUrl",
                                                                subtitle="subtitle"
                                                            ),
                                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                value="value"
                                                            ),
                                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                value="value"
                                                            )
                                                        )]
                                                    )],
        
                                                    # the properties below are optional
                                                    allow_interrupt=False
                                                )
                                            ),
                                            is_active=False
                                        ),
                                        failure_next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        failure_response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        ),
                                        success_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                                condition=lex.CfnBot.ConditionProperty(
                                                    expression_string="expressionString"
                                                ),
                                                name="name",
                                                next_step=lex.CfnBot.DialogStateProperty(
                                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                                        type="type",
        
                                                        # the properties below are optional
                                                        slot_to_elicit="slotToElicit",
                                                        suppress_next_message=False
                                                    ),
                                                    intent=lex.CfnBot.IntentOverrideProperty(
                                                        name="name",
                                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                            slot_name="slotName",
                                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                                shape="shape",
                                                                value=lex.CfnBot.SlotValueProperty(
                                                                    interpreted_value="interpretedValue"
                                                                ),
                                                                values=[slot_value_override_property_]
                                                            )
                                                        )]
                                                    ),
                                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                        key="key",
        
                                                        # the properties below are optional
                                                        value="value"
                                                    )]
                                                ),
        
                                                # the properties below are optional
                                                response=lex.CfnBot.ResponseSpecificationProperty(
                                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                        message=lex.CfnBot.MessageProperty(
                                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                value="value"
                                                            ),
                                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                title="title",
        
                                                                # the properties below are optional
                                                                buttons=[lex.CfnBot.ButtonProperty(
                                                                    text="text",
                                                                    value="value"
                                                                )],
                                                                image_url="imageUrl",
                                                                subtitle="subtitle"
                                                            ),
                                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                value="value"
                                                            ),
                                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                value="value"
                                                            )
                                                        ),
        
                                                        # the properties below are optional
                                                        variations=[lex.CfnBot.MessageProperty(
                                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                value="value"
                                                            ),
                                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                title="title",
        
                                                                # the properties below are optional
                                                                buttons=[lex.CfnBot.ButtonProperty(
                                                                    text="text",
                                                                    value="value"
                                                                )],
                                                                image_url="imageUrl",
                                                                subtitle="subtitle"
                                                            ),
                                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                value="value"
                                                            ),
                                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                value="value"
                                                            )
                                                        )]
                                                    )],
        
                                                    # the properties below are optional
                                                    allow_interrupt=False
                                                )
                                            )],
                                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                                next_step=lex.CfnBot.DialogStateProperty(
                                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                                        type="type",
        
                                                        # the properties below are optional
                                                        slot_to_elicit="slotToElicit",
                                                        suppress_next_message=False
                                                    ),
                                                    intent=lex.CfnBot.IntentOverrideProperty(
                                                        name="name",
                                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                            slot_name="slotName",
                                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                                shape="shape",
                                                                value=lex.CfnBot.SlotValueProperty(
                                                                    interpreted_value="interpretedValue"
                                                                ),
                                                                values=[slot_value_override_property_]
                                                            )
                                                        )]
                                                    ),
                                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                        key="key",
        
                                                        # the properties below are optional
                                                        value="value"
                                                    )]
                                                ),
                                                response=lex.CfnBot.ResponseSpecificationProperty(
                                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                        message=lex.CfnBot.MessageProperty(
                                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                value="value"
                                                            ),
                                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                title="title",
        
                                                                # the properties below are optional
                                                                buttons=[lex.CfnBot.ButtonProperty(
                                                                    text="text",
                                                                    value="value"
                                                                )],
                                                                image_url="imageUrl",
                                                                subtitle="subtitle"
                                                            ),
                                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                value="value"
                                                            ),
                                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                value="value"
                                                            )
                                                        ),
        
                                                        # the properties below are optional
                                                        variations=[lex.CfnBot.MessageProperty(
                                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                value="value"
                                                            ),
                                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                title="title",
        
                                                                # the properties below are optional
                                                                buttons=[lex.CfnBot.ButtonProperty(
                                                                    text="text",
                                                                    value="value"
                                                                )],
                                                                image_url="imageUrl",
                                                                subtitle="subtitle"
                                                            ),
                                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                value="value"
                                                            ),
                                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                value="value"
                                                            )
                                                        )]
                                                    )],
        
                                                    # the properties below are optional
                                                    allow_interrupt=False
                                                )
                                            ),
                                            is_active=False
                                        ),
                                        success_next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        success_response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        ),
                                        timeout_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                                condition=lex.CfnBot.ConditionProperty(
                                                    expression_string="expressionString"
                                                ),
                                                name="name",
                                                next_step=lex.CfnBot.DialogStateProperty(
                                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                                        type="type",
        
                                                        # the properties below are optional
                                                        slot_to_elicit="slotToElicit",
                                                        suppress_next_message=False
                                                    ),
                                                    intent=lex.CfnBot.IntentOverrideProperty(
                                                        name="name",
                                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                            slot_name="slotName",
                                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                                shape="shape",
                                                                value=lex.CfnBot.SlotValueProperty(
                                                                    interpreted_value="interpretedValue"
                                                                ),
                                                                values=[slot_value_override_property_]
                                                            )
                                                        )]
                                                    ),
                                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                        key="key",
        
                                                        # the properties below are optional
                                                        value="value"
                                                    )]
                                                ),
        
                                                # the properties below are optional
                                                response=lex.CfnBot.ResponseSpecificationProperty(
                                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                        message=lex.CfnBot.MessageProperty(
                                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                value="value"
                                                            ),
                                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                title="title",
        
                                                                # the properties below are optional
                                                                buttons=[lex.CfnBot.ButtonProperty(
                                                                    text="text",
                                                                    value="value"
                                                                )],
                                                                image_url="imageUrl",
                                                                subtitle="subtitle"
                                                            ),
                                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                value="value"
                                                            ),
                                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                value="value"
                                                            )
                                                        ),
        
                                                        # the properties below are optional
                                                        variations=[lex.CfnBot.MessageProperty(
                                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                value="value"
                                                            ),
                                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                title="title",
        
                                                                # the properties below are optional
                                                                buttons=[lex.CfnBot.ButtonProperty(
                                                                    text="text",
                                                                    value="value"
                                                                )],
                                                                image_url="imageUrl",
                                                                subtitle="subtitle"
                                                            ),
                                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                value="value"
                                                            ),
                                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                value="value"
                                                            )
                                                        )]
                                                    )],
        
                                                    # the properties below are optional
                                                    allow_interrupt=False
                                                )
                                            )],
                                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                                next_step=lex.CfnBot.DialogStateProperty(
                                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                                        type="type",
        
                                                        # the properties below are optional
                                                        slot_to_elicit="slotToElicit",
                                                        suppress_next_message=False
                                                    ),
                                                    intent=lex.CfnBot.IntentOverrideProperty(
                                                        name="name",
                                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                            slot_name="slotName",
                                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                                shape="shape",
                                                                value=lex.CfnBot.SlotValueProperty(
                                                                    interpreted_value="interpretedValue"
                                                                ),
                                                                values=[slot_value_override_property_]
                                                            )
                                                        )]
                                                    ),
                                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                        key="key",
        
                                                        # the properties below are optional
                                                        value="value"
                                                    )]
                                                ),
                                                response=lex.CfnBot.ResponseSpecificationProperty(
                                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                        message=lex.CfnBot.MessageProperty(
                                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                value="value"
                                                            ),
                                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                title="title",
        
                                                                # the properties below are optional
                                                                buttons=[lex.CfnBot.ButtonProperty(
                                                                    text="text",
                                                                    value="value"
                                                                )],
                                                                image_url="imageUrl",
                                                                subtitle="subtitle"
                                                            ),
                                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                value="value"
                                                            ),
                                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                value="value"
                                                            )
                                                        ),
        
                                                        # the properties below are optional
                                                        variations=[lex.CfnBot.MessageProperty(
                                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                value="value"
                                                            ),
                                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                title="title",
        
                                                                # the properties below are optional
                                                                buttons=[lex.CfnBot.ButtonProperty(
                                                                    text="text",
                                                                    value="value"
                                                                )],
                                                                image_url="imageUrl",
                                                                subtitle="subtitle"
                                                            ),
                                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                value="value"
                                                            ),
                                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                value="value"
                                                            )
                                                        )]
                                                    )],
        
                                                    # the properties below are optional
                                                    allow_interrupt=False
                                                )
                                            ),
                                            is_active=False
                                        ),
                                        timeout_next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        timeout_response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    ),
        
                                    # the properties below are optional
                                    invocation_label="invocationLabel"
                                ),
                                elicitation_code_hook=lex.CfnBot.ElicitationCodeHookInvocationSettingProperty(
                                    enable_code_hook_invocation=False,
        
                                    # the properties below are optional
                                    invocation_label="invocationLabel"
                                ),
                                failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                    conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                        condition=lex.CfnBot.ConditionProperty(
                                            expression_string="expressionString"
                                        ),
                                        name="name",
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
        
                                        # the properties below are optional
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    )],
                                    default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
        
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
        
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
        
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
        
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
        
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    ),
                                    is_active=False
                                ),
                                failure_next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
        
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
        
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                failure_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
                            wait_and_continue_specification=lex.CfnBot.WaitAndContinueSpecificationProperty(
                                continue_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                ),
                                waiting_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                ),
        
                                # the properties below are optional
                                is_active=False,
                                still_waiting_response=lex.CfnBot.StillWaitingResponseSpecificationProperty(
                                    frequency_in_seconds=123,
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
        
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                                    timeout_in_seconds=123,
        
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            )
                        ),
        
                        # the properties below are optional
                        description="description",
                        multiple_values_setting=lex.CfnBot.MultipleValuesSettingProperty(
                            allow_multiple_values=False
                        ),
                        obfuscation_setting=lex.CfnBot.ObfuscationSettingProperty(
                            obfuscation_setting_type="obfuscationSettingType"
                        )
                    )]
                )],
                slot_types=[lex.CfnBot.SlotTypeProperty(
                    name="name",
        
                    # the properties below are optional
                    description="description",
                    external_source_setting=lex.CfnBot.ExternalSourceSettingProperty(
                        grammar_slot_type_setting=lex.CfnBot.GrammarSlotTypeSettingProperty(
                            source=lex.CfnBot.GrammarSlotTypeSourceProperty(
                                s3_bucket_name="s3BucketName",
                                s3_object_key="s3ObjectKey",
        
                                # the properties below are optional
                                kms_key_arn="kmsKeyArn"
                            )
                        )
                    ),
                    parent_slot_type_signature="parentSlotTypeSignature",
                    slot_type_values=[lex.CfnBot.SlotTypeValueProperty(
                        sample_value=lex.CfnBot.SampleValueProperty(
                            value="value"
                        ),
        
                        # the properties below are optional
                        synonyms=[lex.CfnBot.SampleValueProperty(
                            value="value"
                        )]
                    )],
                    value_selection_setting=lex.CfnBot.SlotValueSelectionSettingProperty(
                        resolution_strategy="resolutionStrategy",
        
                        # the properties below are optional
                        advanced_recognition_setting=lex.CfnBot.AdvancedRecognitionSettingProperty(
                            audio_recognition_strategy="audioRecognitionStrategy"
                        ),
                        regex_filter=lex.CfnBot.SlotValueRegexFilterProperty(
                            pattern="pattern"
                        )
                    )
                )],
                voice_settings=lex.CfnBot.VoiceSettingsProperty(
                    voice_id="voiceId",
        
                    # the properties below are optional
                    engine="engine"
                )
            )],
            bot_tags=[CfnTag(
                key="key",
                value="value"
            )],
            description="description",
            test_bot_alias_settings=lex.CfnBot.TestBotAliasSettingsProperty(
                bot_alias_locale_settings=[lex.CfnBot.BotAliasLocaleSettingsItemProperty(
                    bot_alias_locale_setting=lex.CfnBot.BotAliasLocaleSettingsProperty(
                        enabled=False,
        
                        # the properties below are optional
                        code_hook_specification=lex.CfnBot.CodeHookSpecificationProperty(
                            lambda_code_hook=lex.CfnBot.LambdaCodeHookProperty(
                                code_hook_interface_version="codeHookInterfaceVersion",
                                lambda_arn="lambdaArn"
                            )
                        )
                    ),
                    locale_id="localeId"
                )],
                conversation_log_settings=lex.CfnBot.ConversationLogSettingsProperty(
                    audio_log_settings=[lex.CfnBot.AudioLogSettingProperty(
                        destination=lex.CfnBot.AudioLogDestinationProperty(
                            s3_bucket=lex.CfnBot.S3BucketLogDestinationProperty(
                                log_prefix="logPrefix",
                                s3_bucket_arn="s3BucketArn",
        
                                # the properties below are optional
                                kms_key_arn="kmsKeyArn"
                            )
                        ),
                        enabled=False
                    )],
                    text_log_settings=[lex.CfnBot.TextLogSettingProperty(
                        destination=lex.CfnBot.TextLogDestinationProperty(
                            cloud_watch=lex.CfnBot.CloudWatchLogGroupLogDestinationProperty(
                                cloud_watch_log_group_arn="cloudWatchLogGroupArn",
                                log_prefix="logPrefix"
                            )
                        ),
                        enabled=False
                    )]
                ),
                description="description",
                sentiment_analysis_settings=sentiment_analysis_settings
            ),
            test_bot_alias_tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _aws_cdk_core_f4b25747.Construct,
        id: builtins.str,
        *,
        data_privacy: typing.Any,
        idle_session_ttl_in_seconds: jsii.Number,
        name: builtins.str,
        role_arn: builtins.str,
        auto_build_bot_locales: typing.Optional[typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]] = None,
        bot_file_s3_location: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.S3LocationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        bot_locales: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.BotLocaleProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        bot_tags: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union[_aws_cdk_core_f4b25747.CfnTag, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        description: typing.Optional[builtins.str] = None,
        test_bot_alias_settings: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.TestBotAliasSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        test_bot_alias_tags: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union[_aws_cdk_core_f4b25747.CfnTag, typing.Dict[builtins.str, typing.Any]]]]]] = None,
    ) -> None:
        '''Create a new ``AWS::Lex::Bot``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param data_privacy: By default, data stored by Amazon Lex is encrypted. The ``DataPrivacy`` structure provides settings that determine how Amazon Lex handles special cases of securing the data for your bot.
        :param idle_session_ttl_in_seconds: The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout. You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
        :param name: The name of the bot locale.
        :param role_arn: The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
        :param auto_build_bot_locales: Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.
        :param bot_file_s3_location: The Amazon S3 location of files used to import a bot. The files must be in the import format specified in `JSON format for importing and exporting <https://docs.aws.amazon.com/lexv2/latest/dg/import-export-format.html>`_ in the *Amazon Lex developer guide.*
        :param bot_locales: A list of locales for the bot.
        :param bot_tags: A list of tags to add to the bot. You can only add tags when you import a bot. You can't use the ``UpdateBot`` operation to update tags. To update tags, use the ``TagResource`` operation.
        :param description: The description of the version.
        :param test_bot_alias_settings: Specifies configuration settings for the alias used to test the bot. If the ``TestBotAliasSettings`` property is not specified, the settings are configured with default values.
        :param test_bot_alias_tags: A list of tags to add to the test alias for a bot. You can only add tags when you import a bot. You can't use the ``UpdateAlias`` operation to update tags. To update tags on the test alias, use the ``TagResource`` operation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c32b6ba3ac1a11f523aed5f511585db6c68f66ab488d13ff9f3b1bc0343ece29)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnBotProps(
            data_privacy=data_privacy,
            idle_session_ttl_in_seconds=idle_session_ttl_in_seconds,
            name=name,
            role_arn=role_arn,
            auto_build_bot_locales=auto_build_bot_locales,
            bot_file_s3_location=bot_file_s3_location,
            bot_locales=bot_locales,
            bot_tags=bot_tags,
            description=description,
            test_bot_alias_settings=test_bot_alias_settings,
            test_bot_alias_tags=test_bot_alias_tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _aws_cdk_core_f4b25747.TreeInspector) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__45b44e6f55c1aaee99c24639c213099abed1c7b704a641a541f2389206b4d3d3)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7489eac65be2b6a4f6b60cc2d23e4020bb81c653e4e58dba47143f64169d4d42)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the bot.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The unique identifier of the bot.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="dataPrivacy")
    def data_privacy(self) -> typing.Any:
        '''By default, data stored by Amazon Lex is encrypted.

        The ``DataPrivacy`` structure provides settings that determine how Amazon Lex handles special cases of securing the data for your bot.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html#cfn-lex-bot-dataprivacy
        '''
        return typing.cast(typing.Any, jsii.get(self, "dataPrivacy"))

    @data_privacy.setter
    def data_privacy(self, value: typing.Any) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__291daf3180cba7471a77ba47ca5526f76d5a822c77c6bae56a81cb20f791cca5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataPrivacy", value)

    @builtins.property
    @jsii.member(jsii_name="idleSessionTtlInSeconds")
    def idle_session_ttl_in_seconds(self) -> jsii.Number:
        '''The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.

        A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.

        You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html#cfn-lex-bot-idlesessionttlinseconds
        '''
        return typing.cast(jsii.Number, jsii.get(self, "idleSessionTtlInSeconds"))

    @idle_session_ttl_in_seconds.setter
    def idle_session_ttl_in_seconds(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f19fcce7464c109d027ceae526882382993870083562b90a6141a2ae436a3342)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "idleSessionTtlInSeconds", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The name of the bot locale.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html#cfn-lex-bot-name
        '''
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c6ae8fbab2b0706d58b4bf9de2e780913a84dd1b83350ca240fa0ac6b1fed03)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html#cfn-lex-bot-rolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aa106447fbd5f28c2a8191871ce76e3723a1f4afe8173e6c9cb4650cb18554e5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value)

    @builtins.property
    @jsii.member(jsii_name="autoBuildBotLocales")
    def auto_build_bot_locales(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]]:
        '''Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html#cfn-lex-bot-autobuildbotlocales
        '''
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]], jsii.get(self, "autoBuildBotLocales"))

    @auto_build_bot_locales.setter
    def auto_build_bot_locales(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__63f293142c9e68ba1b9f6235a9eef8f0ee35368682cc04e5b506d970d4370b90)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "autoBuildBotLocales", value)

    @builtins.property
    @jsii.member(jsii_name="botFileS3Location")
    def bot_file_s3_location(
        self,
    ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.S3LocationProperty"]]:
        '''The Amazon S3 location of files used to import a bot.

        The files must be in the import format specified in `JSON format for importing and exporting <https://docs.aws.amazon.com/lexv2/latest/dg/import-export-format.html>`_ in the *Amazon Lex developer guide.*

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html#cfn-lex-bot-botfiles3location
        '''
        return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.S3LocationProperty"]], jsii.get(self, "botFileS3Location"))

    @bot_file_s3_location.setter
    def bot_file_s3_location(
        self,
        value: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.S3LocationProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__362bfaf577ca696673ce60d5989301ba1e228a4483e8ef08bb5b78da418898f5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "botFileS3Location", value)

    @builtins.property
    @jsii.member(jsii_name="botLocales")
    def bot_locales(
        self,
    ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.BotLocaleProperty"]]]]:
        '''A list of locales for the bot.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html#cfn-lex-bot-botlocales
        '''
        return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.BotLocaleProperty"]]]], jsii.get(self, "botLocales"))

    @bot_locales.setter
    def bot_locales(
        self,
        value: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.BotLocaleProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__06b917a2f613fe9b4a599279d725f726837b1659e25847d4170d03f9b499976d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "botLocales", value)

    @builtins.property
    @jsii.member(jsii_name="botTags")
    def bot_tags(
        self,
    ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, _aws_cdk_core_f4b25747.CfnTag]]]]:
        '''A list of tags to add to the bot.

        You can only add tags when you import a bot. You can't use the ``UpdateBot`` operation to update tags. To update tags, use the ``TagResource`` operation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html#cfn-lex-bot-bottags
        '''
        return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, _aws_cdk_core_f4b25747.CfnTag]]]], jsii.get(self, "botTags"))

    @bot_tags.setter
    def bot_tags(
        self,
        value: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, _aws_cdk_core_f4b25747.CfnTag]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8c8732ebd90cc3092165edf7b3b336ce71cd94af1dac75b9d3c49317796e8c35)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "botTags", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''The description of the version.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html#cfn-lex-bot-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__36dd3001a021a12cb0baf96ff20897eff6402523f5390ef16db0498805a78917)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="testBotAliasSettings")
    def test_bot_alias_settings(
        self,
    ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.TestBotAliasSettingsProperty"]]:
        '''Specifies configuration settings for the alias used to test the bot.

        If the ``TestBotAliasSettings`` property is not specified, the settings are configured with default values.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html#cfn-lex-bot-testbotaliassettings
        '''
        return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.TestBotAliasSettingsProperty"]], jsii.get(self, "testBotAliasSettings"))

    @test_bot_alias_settings.setter
    def test_bot_alias_settings(
        self,
        value: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.TestBotAliasSettingsProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0486714edae70bd4cf7e2f138408212a8a7a3ed8c7703d5dbb06e7495c3254a5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "testBotAliasSettings", value)

    @builtins.property
    @jsii.member(jsii_name="testBotAliasTags")
    def test_bot_alias_tags(
        self,
    ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, _aws_cdk_core_f4b25747.CfnTag]]]]:
        '''A list of tags to add to the test alias for a bot.

        You can only add tags when you import a bot. You can't use the ``UpdateAlias`` operation to update tags. To update tags on the test alias, use the ``TagResource`` operation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html#cfn-lex-bot-testbotaliastags
        '''
        return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, _aws_cdk_core_f4b25747.CfnTag]]]], jsii.get(self, "testBotAliasTags"))

    @test_bot_alias_tags.setter
    def test_bot_alias_tags(
        self,
        value: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, _aws_cdk_core_f4b25747.CfnTag]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f8a878428d06d0371f39dac4b3340f1aba7fb3e1f726d4e7b74fc9ba5cff5093)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "testBotAliasTags", value)

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.AdvancedRecognitionSettingProperty",
        jsii_struct_bases=[],
        name_mapping={"audio_recognition_strategy": "audioRecognitionStrategy"},
    )
    class AdvancedRecognitionSettingProperty:
        def __init__(
            self,
            *,
            audio_recognition_strategy: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Provides settings that enable advanced recognition settings for slot values.

            :param audio_recognition_strategy: Enables using the slot values as a custom vocabulary for recognizing user utterances.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-advancedrecognitionsetting.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                advanced_recognition_setting_property = lex.CfnBot.AdvancedRecognitionSettingProperty(
                    audio_recognition_strategy="audioRecognitionStrategy"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f18434d84262bd1b58a1e22a7ee7af3f5bde045708f19369d9cb2d77a669f4ca)
                check_type(argname="argument audio_recognition_strategy", value=audio_recognition_strategy, expected_type=type_hints["audio_recognition_strategy"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if audio_recognition_strategy is not None:
                self._values["audio_recognition_strategy"] = audio_recognition_strategy

        @builtins.property
        def audio_recognition_strategy(self) -> typing.Optional[builtins.str]:
            '''Enables using the slot values as a custom vocabulary for recognizing user utterances.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-advancedrecognitionsetting.html#cfn-lex-bot-advancedrecognitionsetting-audiorecognitionstrategy
            '''
            result = self._values.get("audio_recognition_strategy")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AdvancedRecognitionSettingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.AllowedInputTypesProperty",
        jsii_struct_bases=[],
        name_mapping={
            "allow_audio_input": "allowAudioInput",
            "allow_dtmf_input": "allowDtmfInput",
        },
    )
    class AllowedInputTypesProperty:
        def __init__(
            self,
            *,
            allow_audio_input: typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable],
            allow_dtmf_input: typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable],
        ) -> None:
            '''Specifies the allowed input types.

            :param allow_audio_input: Indicates whether audio input is allowed.
            :param allow_dtmf_input: Indicates whether DTMF input is allowed.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-allowedinputtypes.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                allowed_input_types_property = lex.CfnBot.AllowedInputTypesProperty(
                    allow_audio_input=False,
                    allow_dtmf_input=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__81adb7683e742175fc26c6909829061374e32cd0ffca6a1498fdf1ec2679d53b)
                check_type(argname="argument allow_audio_input", value=allow_audio_input, expected_type=type_hints["allow_audio_input"])
                check_type(argname="argument allow_dtmf_input", value=allow_dtmf_input, expected_type=type_hints["allow_dtmf_input"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "allow_audio_input": allow_audio_input,
                "allow_dtmf_input": allow_dtmf_input,
            }

        @builtins.property
        def allow_audio_input(
            self,
        ) -> typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]:
            '''Indicates whether audio input is allowed.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-allowedinputtypes.html#cfn-lex-bot-allowedinputtypes-allowaudioinput
            '''
            result = self._values.get("allow_audio_input")
            assert result is not None, "Required property 'allow_audio_input' is missing"
            return typing.cast(typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable], result)

        @builtins.property
        def allow_dtmf_input(
            self,
        ) -> typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]:
            '''Indicates whether DTMF input is allowed.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-allowedinputtypes.html#cfn-lex-bot-allowedinputtypes-allowdtmfinput
            '''
            result = self._values.get("allow_dtmf_input")
            assert result is not None, "Required property 'allow_dtmf_input' is missing"
            return typing.cast(typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AllowedInputTypesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.AudioAndDTMFInputSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "start_timeout_ms": "startTimeoutMs",
            "audio_specification": "audioSpecification",
            "dtmf_specification": "dtmfSpecification",
        },
    )
    class AudioAndDTMFInputSpecificationProperty:
        def __init__(
            self,
            *,
            start_timeout_ms: jsii.Number,
            audio_specification: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.AudioSpecificationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            dtmf_specification: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.DTMFSpecificationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies the audio and DTMF input specification.

            :param start_timeout_ms: Time for which a bot waits before assuming that the customer isn't going to speak or press a key. This timeout is shared between Audio and DTMF inputs.
            :param audio_specification: Specifies the settings on audio input.
            :param dtmf_specification: Specifies the settings on DTMF input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audioanddtmfinputspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                audio_and_dTMFInput_specification_property = lex.CfnBot.AudioAndDTMFInputSpecificationProperty(
                    start_timeout_ms=123,
                
                    # the properties below are optional
                    audio_specification=lex.CfnBot.AudioSpecificationProperty(
                        end_timeout_ms=123,
                        max_length_ms=123
                    ),
                    dtmf_specification=lex.CfnBot.DTMFSpecificationProperty(
                        deletion_character="deletionCharacter",
                        end_character="endCharacter",
                        end_timeout_ms=123,
                        max_length=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__172847647b14e44f8713aab62364b1fb02bf11ca42de2d2202906964a14389f3)
                check_type(argname="argument start_timeout_ms", value=start_timeout_ms, expected_type=type_hints["start_timeout_ms"])
                check_type(argname="argument audio_specification", value=audio_specification, expected_type=type_hints["audio_specification"])
                check_type(argname="argument dtmf_specification", value=dtmf_specification, expected_type=type_hints["dtmf_specification"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "start_timeout_ms": start_timeout_ms,
            }
            if audio_specification is not None:
                self._values["audio_specification"] = audio_specification
            if dtmf_specification is not None:
                self._values["dtmf_specification"] = dtmf_specification

        @builtins.property
        def start_timeout_ms(self) -> jsii.Number:
            '''Time for which a bot waits before assuming that the customer isn't going to speak or press a key.

            This timeout is shared between Audio and DTMF inputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audioanddtmfinputspecification.html#cfn-lex-bot-audioanddtmfinputspecification-starttimeoutms
            '''
            result = self._values.get("start_timeout_ms")
            assert result is not None, "Required property 'start_timeout_ms' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def audio_specification(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.AudioSpecificationProperty"]]:
            '''Specifies the settings on audio input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audioanddtmfinputspecification.html#cfn-lex-bot-audioanddtmfinputspecification-audiospecification
            '''
            result = self._values.get("audio_specification")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.AudioSpecificationProperty"]], result)

        @builtins.property
        def dtmf_specification(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.DTMFSpecificationProperty"]]:
            '''Specifies the settings on DTMF input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audioanddtmfinputspecification.html#cfn-lex-bot-audioanddtmfinputspecification-dtmfspecification
            '''
            result = self._values.get("dtmf_specification")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.DTMFSpecificationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioAndDTMFInputSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.AudioLogDestinationProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_bucket": "s3Bucket"},
    )
    class AudioLogDestinationProperty:
        def __init__(
            self,
            *,
            s3_bucket: typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.S3BucketLogDestinationProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The location of audio log files collected when conversation logging is enabled for a bot.

            :param s3_bucket: Specifies the Amazon S3 bucket where the audio files are stored.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologdestination.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                audio_log_destination_property = lex.CfnBot.AudioLogDestinationProperty(
                    s3_bucket=lex.CfnBot.S3BucketLogDestinationProperty(
                        log_prefix="logPrefix",
                        s3_bucket_arn="s3BucketArn",
                
                        # the properties below are optional
                        kms_key_arn="kmsKeyArn"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cd16255160f7020b858d622bde765d4d99dbbef63f0e46d978da9697782fde15)
                check_type(argname="argument s3_bucket", value=s3_bucket, expected_type=type_hints["s3_bucket"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_bucket": s3_bucket,
            }

        @builtins.property
        def s3_bucket(
            self,
        ) -> typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.S3BucketLogDestinationProperty"]:
            '''Specifies the Amazon S3 bucket where the audio files are stored.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologdestination.html#cfn-lex-bot-audiologdestination-s3bucket
            '''
            result = self._values.get("s3_bucket")
            assert result is not None, "Required property 's3_bucket' is missing"
            return typing.cast(typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.S3BucketLogDestinationProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioLogDestinationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.AudioLogSettingProperty",
        jsii_struct_bases=[],
        name_mapping={"destination": "destination", "enabled": "enabled"},
    )
    class AudioLogSettingProperty:
        def __init__(
            self,
            *,
            destination: typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.AudioLogDestinationProperty", typing.Dict[builtins.str, typing.Any]]],
            enabled: typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable],
        ) -> None:
            '''Settings for logging audio of conversations between Amazon Lex and a user.

            You specify whether to log audio and the Amazon S3 bucket where the audio file is stored.

            :param destination: Specifies the location of the audio log files collected when conversation logging is enabled for a bot.
            :param enabled: Determines whether audio logging in enabled for the bot.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologsetting.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                audio_log_setting_property = lex.CfnBot.AudioLogSettingProperty(
                    destination=lex.CfnBot.AudioLogDestinationProperty(
                        s3_bucket=lex.CfnBot.S3BucketLogDestinationProperty(
                            log_prefix="logPrefix",
                            s3_bucket_arn="s3BucketArn",
                
                            # the properties below are optional
                            kms_key_arn="kmsKeyArn"
                        )
                    ),
                    enabled=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__012e5b81ba543678c2746364b2307194ee37ec7d0469da50bef4f95cfc3a087e)
                check_type(argname="argument destination", value=destination, expected_type=type_hints["destination"])
                check_type(argname="argument enabled", value=enabled, expected_type=type_hints["enabled"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "destination": destination,
                "enabled": enabled,
            }

        @builtins.property
        def destination(
            self,
        ) -> typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.AudioLogDestinationProperty"]:
            '''Specifies the location of the audio log files collected when conversation logging is enabled for a bot.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologsetting.html#cfn-lex-bot-audiologsetting-destination
            '''
            result = self._values.get("destination")
            assert result is not None, "Required property 'destination' is missing"
            return typing.cast(typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.AudioLogDestinationProperty"], result)

        @builtins.property
        def enabled(
            self,
        ) -> typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]:
            '''Determines whether audio logging in enabled for the bot.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologsetting.html#cfn-lex-bot-audiologsetting-enabled
            '''
            result = self._values.get("enabled")
            assert result is not None, "Required property 'enabled' is missing"
            return typing.cast(typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioLogSettingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.AudioSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "end_timeout_ms": "endTimeoutMs",
            "max_length_ms": "maxLengthMs",
        },
    )
    class AudioSpecificationProperty:
        def __init__(
            self,
            *,
            end_timeout_ms: jsii.Number,
            max_length_ms: jsii.Number,
        ) -> None:
            '''Specifies the audio input specifications.

            :param end_timeout_ms: Time for which a bot waits after the customer stops speaking to assume the utterance is finished.
            :param max_length_ms: Time for how long Amazon Lex waits before speech input is truncated and the speech is returned to application.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiospecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                audio_specification_property = lex.CfnBot.AudioSpecificationProperty(
                    end_timeout_ms=123,
                    max_length_ms=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5dd5779b162d84386570c114b99f0561c027760c1f39856a6e320bfcbe356569)
                check_type(argname="argument end_timeout_ms", value=end_timeout_ms, expected_type=type_hints["end_timeout_ms"])
                check_type(argname="argument max_length_ms", value=max_length_ms, expected_type=type_hints["max_length_ms"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "end_timeout_ms": end_timeout_ms,
                "max_length_ms": max_length_ms,
            }

        @builtins.property
        def end_timeout_ms(self) -> jsii.Number:
            '''Time for which a bot waits after the customer stops speaking to assume the utterance is finished.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiospecification.html#cfn-lex-bot-audiospecification-endtimeoutms
            '''
            result = self._values.get("end_timeout_ms")
            assert result is not None, "Required property 'end_timeout_ms' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def max_length_ms(self) -> jsii.Number:
            '''Time for how long Amazon Lex waits before speech input is truncated and the speech is returned to application.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiospecification.html#cfn-lex-bot-audiospecification-maxlengthms
            '''
            result = self._values.get("max_length_ms")
            assert result is not None, "Required property 'max_length_ms' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.BotAliasLocaleSettingsItemProperty",
        jsii_struct_bases=[],
        name_mapping={
            "bot_alias_locale_setting": "botAliasLocaleSetting",
            "locale_id": "localeId",
        },
    )
    class BotAliasLocaleSettingsItemProperty:
        def __init__(
            self,
            *,
            bot_alias_locale_setting: typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.BotAliasLocaleSettingsProperty", typing.Dict[builtins.str, typing.Any]]],
            locale_id: builtins.str,
        ) -> None:
            '''Specifies locale settings for a single locale.

            :param bot_alias_locale_setting: Specifies locale settings for a locale.
            :param locale_id: Specifies the locale that the settings apply to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettingsitem.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                bot_alias_locale_settings_item_property = lex.CfnBot.BotAliasLocaleSettingsItemProperty(
                    bot_alias_locale_setting=lex.CfnBot.BotAliasLocaleSettingsProperty(
                        enabled=False,
                
                        # the properties below are optional
                        code_hook_specification=lex.CfnBot.CodeHookSpecificationProperty(
                            lambda_code_hook=lex.CfnBot.LambdaCodeHookProperty(
                                code_hook_interface_version="codeHookInterfaceVersion",
                                lambda_arn="lambdaArn"
                            )
                        )
                    ),
                    locale_id="localeId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__adf654f112e0ec8396c9ff8eb83dc7e4bde049f41919e0f85aed475d81029485)
                check_type(argname="argument bot_alias_locale_setting", value=bot_alias_locale_setting, expected_type=type_hints["bot_alias_locale_setting"])
                check_type(argname="argument locale_id", value=locale_id, expected_type=type_hints["locale_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "bot_alias_locale_setting": bot_alias_locale_setting,
                "locale_id": locale_id,
            }

        @builtins.property
        def bot_alias_locale_setting(
            self,
        ) -> typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.BotAliasLocaleSettingsProperty"]:
            '''Specifies locale settings for a locale.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettingsitem.html#cfn-lex-bot-botaliaslocalesettingsitem-botaliaslocalesetting
            '''
            result = self._values.get("bot_alias_locale_setting")
            assert result is not None, "Required property 'bot_alias_locale_setting' is missing"
            return typing.cast(typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.BotAliasLocaleSettingsProperty"], result)

        @builtins.property
        def locale_id(self) -> builtins.str:
            '''Specifies the locale that the settings apply to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettingsitem.html#cfn-lex-bot-botaliaslocalesettingsitem-localeid
            '''
            result = self._values.get("locale_id")
            assert result is not None, "Required property 'locale_id' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BotAliasLocaleSettingsItemProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.BotAliasLocaleSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enabled": "enabled",
            "code_hook_specification": "codeHookSpecification",
        },
    )
    class BotAliasLocaleSettingsProperty:
        def __init__(
            self,
            *,
            enabled: typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable],
            code_hook_specification: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.CodeHookSpecificationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies settings that are unique to a locale.

            For example, you can use different Lambda function depending on the bot's locale.

            :param enabled: Determines whether the locale is enabled for the bot. If the value is ``false`` , the locale isn't available for use.
            :param code_hook_specification: Specifies the Lambda function that should be used in the locale.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                bot_alias_locale_settings_property = lex.CfnBot.BotAliasLocaleSettingsProperty(
                    enabled=False,
                
                    # the properties below are optional
                    code_hook_specification=lex.CfnBot.CodeHookSpecificationProperty(
                        lambda_code_hook=lex.CfnBot.LambdaCodeHookProperty(
                            code_hook_interface_version="codeHookInterfaceVersion",
                            lambda_arn="lambdaArn"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cf9aba6c3be74203c6592e57e7ea556c6428e5be7b09bd85b32211ec142bbb2e)
                check_type(argname="argument enabled", value=enabled, expected_type=type_hints["enabled"])
                check_type(argname="argument code_hook_specification", value=code_hook_specification, expected_type=type_hints["code_hook_specification"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "enabled": enabled,
            }
            if code_hook_specification is not None:
                self._values["code_hook_specification"] = code_hook_specification

        @builtins.property
        def enabled(
            self,
        ) -> typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]:
            '''Determines whether the locale is enabled for the bot.

            If the value is ``false`` , the locale isn't available for use.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettings.html#cfn-lex-bot-botaliaslocalesettings-enabled
            '''
            result = self._values.get("enabled")
            assert result is not None, "Required property 'enabled' is missing"
            return typing.cast(typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable], result)

        @builtins.property
        def code_hook_specification(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.CodeHookSpecificationProperty"]]:
            '''Specifies the Lambda function that should be used in the locale.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettings.html#cfn-lex-bot-botaliaslocalesettings-codehookspecification
            '''
            result = self._values.get("code_hook_specification")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.CodeHookSpecificationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BotAliasLocaleSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.BotLocaleProperty",
        jsii_struct_bases=[],
        name_mapping={
            "locale_id": "localeId",
            "nlu_confidence_threshold": "nluConfidenceThreshold",
            "custom_vocabulary": "customVocabulary",
            "description": "description",
            "intents": "intents",
            "slot_types": "slotTypes",
            "voice_settings": "voiceSettings",
        },
    )
    class BotLocaleProperty:
        def __init__(
            self,
            *,
            locale_id: builtins.str,
            nlu_confidence_threshold: jsii.Number,
            custom_vocabulary: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.CustomVocabularyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            description: typing.Optional[builtins.str] = None,
            intents: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.IntentProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            slot_types: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.SlotTypeProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            voice_settings: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.VoiceSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Provides configuration information for a locale.

            :param locale_id: The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales.
            :param nlu_confidence_threshold: Determines the threshold where Amazon Lex will insert the ``AMAZON.FallbackIntent`` , ``AMAZON.KendraSearchIntent`` , or both when returning alternative intents. You must configure an ``AMAZON.FallbackIntent`` . ``AMAZON.KendraSearchIntent`` is only inserted if it is configured for the bot.
            :param custom_vocabulary: Specifies a custom vocabulary to use with a specific locale.
            :param description: A description of the bot locale. Use this to help identify the bot locale in lists.
            :param intents: One or more intents defined for the locale.
            :param slot_types: One or more slot types defined for the locale.
            :param voice_settings: Defines settings for using an Amazon Polly voice to communicate with a user.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                # slot_value_override_property_: lex.CfnBot.SlotValueOverrideProperty
                
                bot_locale_property = lex.CfnBot.BotLocaleProperty(
                    locale_id="localeId",
                    nlu_confidence_threshold=123,
                
                    # the properties below are optional
                    custom_vocabulary=lex.CfnBot.CustomVocabularyProperty(
                        custom_vocabulary_items=[lex.CfnBot.CustomVocabularyItemProperty(
                            phrase="phrase",
                
                            # the properties below are optional
                            display_as="displayAs",
                            weight=123
                        )]
                    ),
                    description="description",
                    intents=[lex.CfnBot.IntentProperty(
                        name="name",
                
                        # the properties below are optional
                        description="description",
                        dialog_code_hook=lex.CfnBot.DialogCodeHookSettingProperty(
                            enabled=False
                        ),
                        fulfillment_code_hook=lex.CfnBot.FulfillmentCodeHookSettingProperty(
                            enabled=False,
                
                            # the properties below are optional
                            fulfillment_updates_specification=lex.CfnBot.FulfillmentUpdatesSpecificationProperty(
                                active=False,
                
                                # the properties below are optional
                                start_response=lex.CfnBot.FulfillmentStartResponseSpecificationProperty(
                                    delay_in_seconds=123,
                                    message_groups=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                ),
                                timeout_in_seconds=123,
                                update_response=lex.CfnBot.FulfillmentUpdateResponseSpecificationProperty(
                                    frequency_in_seconds=123,
                                    message_groups=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
                            is_active=False,
                            post_fulfillment_status_specification=lex.CfnBot.PostFulfillmentStatusSpecificationProperty(
                                failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                    conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                        condition=lex.CfnBot.ConditionProperty(
                                            expression_string="expressionString"
                                        ),
                                        name="name",
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
                
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
                
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                
                                        # the properties below are optional
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
                
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
                
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
                
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
                
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    )],
                                    default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
                
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
                
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
                
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
                
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
                
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
                
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    ),
                                    is_active=False
                                ),
                                failure_next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                failure_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                ),
                                success_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                    conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                        condition=lex.CfnBot.ConditionProperty(
                                            expression_string="expressionString"
                                        ),
                                        name="name",
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
                
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
                
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                
                                        # the properties below are optional
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
                
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
                
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
                
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
                
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    )],
                                    default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
                
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
                
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
                
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
                
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
                
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
                
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    ),
                                    is_active=False
                                ),
                                success_next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                success_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                ),
                                timeout_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                    conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                        condition=lex.CfnBot.ConditionProperty(
                                            expression_string="expressionString"
                                        ),
                                        name="name",
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
                
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
                
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                
                                        # the properties below are optional
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
                
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
                
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
                
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
                
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    )],
                                    default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                        next_step=lex.CfnBot.DialogStateProperty(
                                            dialog_action=lex.CfnBot.DialogActionProperty(
                                                type="type",
                
                                                # the properties below are optional
                                                slot_to_elicit="slotToElicit",
                                                suppress_next_message=False
                                            ),
                                            intent=lex.CfnBot.IntentOverrideProperty(
                                                name="name",
                                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                    slot_name="slotName",
                                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                        shape="shape",
                                                        value=lex.CfnBot.SlotValueProperty(
                                                            interpreted_value="interpretedValue"
                                                        ),
                                                        values=[slot_value_override_property_]
                                                    )
                                                )]
                                            ),
                                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                key="key",
                
                                                # the properties below are optional
                                                value="value"
                                            )]
                                        ),
                                        response=lex.CfnBot.ResponseSpecificationProperty(
                                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                message=lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
                
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                ),
                
                                                # the properties below are optional
                                                variations=[lex.CfnBot.MessageProperty(
                                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                        value="value"
                                                    ),
                                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                        title="title",
                
                                                        # the properties below are optional
                                                        buttons=[lex.CfnBot.ButtonProperty(
                                                            text="text",
                                                            value="value"
                                                        )],
                                                        image_url="imageUrl",
                                                        subtitle="subtitle"
                                                    ),
                                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                        value="value"
                                                    ),
                                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                        value="value"
                                                    )
                                                )]
                                            )],
                
                                            # the properties below are optional
                                            allow_interrupt=False
                                        )
                                    ),
                                    is_active=False
                                ),
                                timeout_next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                timeout_response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            )
                        ),
                        initial_response_setting=lex.CfnBot.InitialResponseSettingProperty(
                            code_hook=lex.CfnBot.DialogCodeHookInvocationSettingProperty(
                                enable_code_hook_invocation=False,
                                is_active=False,
                                post_code_hook_specification=lex.CfnBot.PostDialogCodeHookInvocationSpecificationProperty(
                                    failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                        conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                            condition=lex.CfnBot.ConditionProperty(
                                                expression_string="expressionString"
                                            ),
                                            name="name",
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                
                                            # the properties below are optional
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        )],
                                        default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        ),
                                        is_active=False
                                    ),
                                    failure_next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    failure_response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    ),
                                    success_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                        conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                            condition=lex.CfnBot.ConditionProperty(
                                                expression_string="expressionString"
                                            ),
                                            name="name",
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                
                                            # the properties below are optional
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        )],
                                        default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        ),
                                        is_active=False
                                    ),
                                    success_next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    success_response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    ),
                                    timeout_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                        conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                            condition=lex.CfnBot.ConditionProperty(
                                                expression_string="expressionString"
                                            ),
                                            name="name",
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                
                                            # the properties below are optional
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        )],
                                        default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        ),
                                        is_active=False
                                    ),
                                    timeout_next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    timeout_response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                ),
                
                                # the properties below are optional
                                invocation_label="invocationLabel"
                            ),
                            conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                    condition=lex.CfnBot.ConditionProperty(
                                        expression_string="expressionString"
                                    ),
                                    name="name",
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                
                                    # the properties below are optional
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                )],
                                default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                ),
                                is_active=False
                            ),
                            initial_response=lex.CfnBot.ResponseSpecificationProperty(
                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                    message=lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
                
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    ),
                
                                    # the properties below are optional
                                    variations=[lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
                
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    )]
                                )],
                
                                # the properties below are optional
                                allow_interrupt=False
                            ),
                            next_step=lex.CfnBot.DialogStateProperty(
                                dialog_action=lex.CfnBot.DialogActionProperty(
                                    type="type",
                
                                    # the properties below are optional
                                    slot_to_elicit="slotToElicit",
                                    suppress_next_message=False
                                ),
                                intent=lex.CfnBot.IntentOverrideProperty(
                                    name="name",
                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                        slot_name="slotName",
                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                            shape="shape",
                                            value=lex.CfnBot.SlotValueProperty(
                                                interpreted_value="interpretedValue"
                                            ),
                                            values=[slot_value_override_property_]
                                        )
                                    )]
                                ),
                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                    key="key",
                
                                    # the properties below are optional
                                    value="value"
                                )]
                            )
                        ),
                        input_contexts=[lex.CfnBot.InputContextProperty(
                            name="name"
                        )],
                        intent_closing_setting=lex.CfnBot.IntentClosingSettingProperty(
                            closing_response=lex.CfnBot.ResponseSpecificationProperty(
                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                    message=lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
                
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    ),
                
                                    # the properties below are optional
                                    variations=[lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
                
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    )]
                                )],
                
                                # the properties below are optional
                                allow_interrupt=False
                            ),
                            conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                    condition=lex.CfnBot.ConditionProperty(
                                        expression_string="expressionString"
                                    ),
                                    name="name",
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                
                                    # the properties below are optional
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                )],
                                default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                ),
                                is_active=False
                            ),
                            is_active=False,
                            next_step=lex.CfnBot.DialogStateProperty(
                                dialog_action=lex.CfnBot.DialogActionProperty(
                                    type="type",
                
                                    # the properties below are optional
                                    slot_to_elicit="slotToElicit",
                                    suppress_next_message=False
                                ),
                                intent=lex.CfnBot.IntentOverrideProperty(
                                    name="name",
                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                        slot_name="slotName",
                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                            shape="shape",
                                            value=lex.CfnBot.SlotValueProperty(
                                                interpreted_value="interpretedValue"
                                            ),
                                            values=[slot_value_override_property_]
                                        )
                                    )]
                                ),
                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                    key="key",
                
                                    # the properties below are optional
                                    value="value"
                                )]
                            )
                        ),
                        intent_confirmation_setting=lex.CfnBot.IntentConfirmationSettingProperty(
                            prompt_specification=lex.CfnBot.PromptSpecificationProperty(
                                max_retries=123,
                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                    message=lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
                
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    ),
                
                                    # the properties below are optional
                                    variations=[lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
                
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    )]
                                )],
                
                                # the properties below are optional
                                allow_interrupt=False,
                                message_selection_strategy="messageSelectionStrategy",
                                prompt_attempts_specification={
                                    "prompt_attempts_specification_key": lex.CfnBot.PromptAttemptSpecificationProperty(
                                        allowed_input_types=lex.CfnBot.AllowedInputTypesProperty(
                                            allow_audio_input=False,
                                            allow_dtmf_input=False
                                        ),
                
                                        # the properties below are optional
                                        allow_interrupt=False,
                                        audio_and_dtmf_input_specification=lex.CfnBot.AudioAndDTMFInputSpecificationProperty(
                                            start_timeout_ms=123,
                
                                            # the properties below are optional
                                            audio_specification=lex.CfnBot.AudioSpecificationProperty(
                                                end_timeout_ms=123,
                                                max_length_ms=123
                                            ),
                                            dtmf_specification=lex.CfnBot.DTMFSpecificationProperty(
                                                deletion_character="deletionCharacter",
                                                end_character="endCharacter",
                                                end_timeout_ms=123,
                                                max_length=123
                                            )
                                        ),
                                        text_input_specification=lex.CfnBot.TextInputSpecificationProperty(
                                            start_timeout_ms=123
                                        )
                                    )
                                }
                            ),
                
                            # the properties below are optional
                            code_hook=lex.CfnBot.DialogCodeHookInvocationSettingProperty(
                                enable_code_hook_invocation=False,
                                is_active=False,
                                post_code_hook_specification=lex.CfnBot.PostDialogCodeHookInvocationSpecificationProperty(
                                    failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                        conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                            condition=lex.CfnBot.ConditionProperty(
                                                expression_string="expressionString"
                                            ),
                                            name="name",
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                
                                            # the properties below are optional
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        )],
                                        default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        ),
                                        is_active=False
                                    ),
                                    failure_next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    failure_response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    ),
                                    success_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                        conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                            condition=lex.CfnBot.ConditionProperty(
                                                expression_string="expressionString"
                                            ),
                                            name="name",
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                
                                            # the properties below are optional
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        )],
                                        default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        ),
                                        is_active=False
                                    ),
                                    success_next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    success_response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    ),
                                    timeout_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                        conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                            condition=lex.CfnBot.ConditionProperty(
                                                expression_string="expressionString"
                                            ),
                                            name="name",
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                
                                            # the properties below are optional
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        )],
                                        default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        ),
                                        is_active=False
                                    ),
                                    timeout_next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    timeout_response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                ),
                
                                # the properties below are optional
                                invocation_label="invocationLabel"
                            ),
                            confirmation_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                    condition=lex.CfnBot.ConditionProperty(
                                        expression_string="expressionString"
                                    ),
                                    name="name",
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                
                                    # the properties below are optional
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                )],
                                default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                ),
                                is_active=False
                            ),
                            confirmation_next_step=lex.CfnBot.DialogStateProperty(
                                dialog_action=lex.CfnBot.DialogActionProperty(
                                    type="type",
                
                                    # the properties below are optional
                                    slot_to_elicit="slotToElicit",
                                    suppress_next_message=False
                                ),
                                intent=lex.CfnBot.IntentOverrideProperty(
                                    name="name",
                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                        slot_name="slotName",
                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                            shape="shape",
                                            value=lex.CfnBot.SlotValueProperty(
                                                interpreted_value="interpretedValue"
                                            ),
                                            values=[slot_value_override_property_]
                                        )
                                    )]
                                ),
                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                    key="key",
                
                                    # the properties below are optional
                                    value="value"
                                )]
                            ),
                            confirmation_response=lex.CfnBot.ResponseSpecificationProperty(
                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                    message=lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
                
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    ),
                
                                    # the properties below are optional
                                    variations=[lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
                
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    )]
                                )],
                
                                # the properties below are optional
                                allow_interrupt=False
                            ),
                            declination_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                    condition=lex.CfnBot.ConditionProperty(
                                        expression_string="expressionString"
                                    ),
                                    name="name",
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                
                                    # the properties below are optional
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                )],
                                default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                ),
                                is_active=False
                            ),
                            declination_next_step=lex.CfnBot.DialogStateProperty(
                                dialog_action=lex.CfnBot.DialogActionProperty(
                                    type="type",
                
                                    # the properties below are optional
                                    slot_to_elicit="slotToElicit",
                                    suppress_next_message=False
                                ),
                                intent=lex.CfnBot.IntentOverrideProperty(
                                    name="name",
                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                        slot_name="slotName",
                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                            shape="shape",
                                            value=lex.CfnBot.SlotValueProperty(
                                                interpreted_value="interpretedValue"
                                            ),
                                            values=[slot_value_override_property_]
                                        )
                                    )]
                                ),
                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                    key="key",
                
                                    # the properties below are optional
                                    value="value"
                                )]
                            ),
                            declination_response=lex.CfnBot.ResponseSpecificationProperty(
                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                    message=lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
                
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    ),
                
                                    # the properties below are optional
                                    variations=[lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
                
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    )]
                                )],
                
                                # the properties below are optional
                                allow_interrupt=False
                            ),
                            elicitation_code_hook=lex.CfnBot.ElicitationCodeHookInvocationSettingProperty(
                                enable_code_hook_invocation=False,
                
                                # the properties below are optional
                                invocation_label="invocationLabel"
                            ),
                            failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                    condition=lex.CfnBot.ConditionProperty(
                                        expression_string="expressionString"
                                    ),
                                    name="name",
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                
                                    # the properties below are optional
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                )],
                                default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                    next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                ),
                                is_active=False
                            ),
                            failure_next_step=lex.CfnBot.DialogStateProperty(
                                dialog_action=lex.CfnBot.DialogActionProperty(
                                    type="type",
                
                                    # the properties below are optional
                                    slot_to_elicit="slotToElicit",
                                    suppress_next_message=False
                                ),
                                intent=lex.CfnBot.IntentOverrideProperty(
                                    name="name",
                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                        slot_name="slotName",
                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                            shape="shape",
                                            value=lex.CfnBot.SlotValueProperty(
                                                interpreted_value="interpretedValue"
                                            ),
                                            values=[slot_value_override_property_]
                                        )
                                    )]
                                ),
                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                    key="key",
                
                                    # the properties below are optional
                                    value="value"
                                )]
                            ),
                            failure_response=lex.CfnBot.ResponseSpecificationProperty(
                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                    message=lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
                
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    ),
                
                                    # the properties below are optional
                                    variations=[lex.CfnBot.MessageProperty(
                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                            value="value"
                                        ),
                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                            title="title",
                
                                            # the properties below are optional
                                            buttons=[lex.CfnBot.ButtonProperty(
                                                text="text",
                                                value="value"
                                            )],
                                            image_url="imageUrl",
                                            subtitle="subtitle"
                                        ),
                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                            value="value"
                                        ),
                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                            value="value"
                                        )
                                    )]
                                )],
                
                                # the properties below are optional
                                allow_interrupt=False
                            ),
                            is_active=False
                        ),
                        kendra_configuration=lex.CfnBot.KendraConfigurationProperty(
                            kendra_index="kendraIndex",
                
                            # the properties below are optional
                            query_filter_string="queryFilterString",
                            query_filter_string_enabled=False
                        ),
                        output_contexts=[lex.CfnBot.OutputContextProperty(
                            name="name",
                            time_to_live_in_seconds=123,
                            turns_to_live=123
                        )],
                        parent_intent_signature="parentIntentSignature",
                        sample_utterances=[lex.CfnBot.SampleUtteranceProperty(
                            utterance="utterance"
                        )],
                        slot_priorities=[lex.CfnBot.SlotPriorityProperty(
                            priority=123,
                            slot_name="slotName"
                        )],
                        slots=[lex.CfnBot.SlotProperty(
                            name="name",
                            slot_type_name="slotTypeName",
                            value_elicitation_setting=lex.CfnBot.SlotValueElicitationSettingProperty(
                                slot_constraint="slotConstraint",
                
                                # the properties below are optional
                                default_value_specification=lex.CfnBot.SlotDefaultValueSpecificationProperty(
                                    default_value_list=[lex.CfnBot.SlotDefaultValueProperty(
                                        default_value="defaultValue"
                                    )]
                                ),
                                prompt_specification=lex.CfnBot.PromptSpecificationProperty(
                                    max_retries=123,
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False,
                                    message_selection_strategy="messageSelectionStrategy",
                                    prompt_attempts_specification={
                                        "prompt_attempts_specification_key": lex.CfnBot.PromptAttemptSpecificationProperty(
                                            allowed_input_types=lex.CfnBot.AllowedInputTypesProperty(
                                                allow_audio_input=False,
                                                allow_dtmf_input=False
                                            ),
                
                                            # the properties below are optional
                                            allow_interrupt=False,
                                            audio_and_dtmf_input_specification=lex.CfnBot.AudioAndDTMFInputSpecificationProperty(
                                                start_timeout_ms=123,
                
                                                # the properties below are optional
                                                audio_specification=lex.CfnBot.AudioSpecificationProperty(
                                                    end_timeout_ms=123,
                                                    max_length_ms=123
                                                ),
                                                dtmf_specification=lex.CfnBot.DTMFSpecificationProperty(
                                                    deletion_character="deletionCharacter",
                                                    end_character="endCharacter",
                                                    end_timeout_ms=123,
                                                    max_length=123
                                                )
                                            ),
                                            text_input_specification=lex.CfnBot.TextInputSpecificationProperty(
                                                start_timeout_ms=123
                                            )
                                        )
                                    }
                                ),
                                sample_utterances=[lex.CfnBot.SampleUtteranceProperty(
                                    utterance="utterance"
                                )],
                                slot_capture_setting=lex.CfnBot.SlotCaptureSettingProperty(
                                    capture_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                        conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                            condition=lex.CfnBot.ConditionProperty(
                                                expression_string="expressionString"
                                            ),
                                            name="name",
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                
                                            # the properties below are optional
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        )],
                                        default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        ),
                                        is_active=False
                                    ),
                                    capture_next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    capture_response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    ),
                                    code_hook=lex.CfnBot.DialogCodeHookInvocationSettingProperty(
                                        enable_code_hook_invocation=False,
                                        is_active=False,
                                        post_code_hook_specification=lex.CfnBot.PostDialogCodeHookInvocationSpecificationProperty(
                                            failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                                conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                                    condition=lex.CfnBot.ConditionProperty(
                                                        expression_string="expressionString"
                                                    ),
                                                    name="name",
                                                    next_step=lex.CfnBot.DialogStateProperty(
                                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                                            type="type",
                
                                                            # the properties below are optional
                                                            slot_to_elicit="slotToElicit",
                                                            suppress_next_message=False
                                                        ),
                                                        intent=lex.CfnBot.IntentOverrideProperty(
                                                            name="name",
                                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                                slot_name="slotName",
                                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                                    shape="shape",
                                                                    value=lex.CfnBot.SlotValueProperty(
                                                                        interpreted_value="interpretedValue"
                                                                    ),
                                                                    values=[slot_value_override_property_]
                                                                )
                                                            )]
                                                        ),
                                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                            key="key",
                
                                                            # the properties below are optional
                                                            value="value"
                                                        )]
                                                    ),
                
                                                    # the properties below are optional
                                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                            message=lex.CfnBot.MessageProperty(
                                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                    value="value"
                                                                ),
                                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                    title="title",
                
                                                                    # the properties below are optional
                                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                                        text="text",
                                                                        value="value"
                                                                    )],
                                                                    image_url="imageUrl",
                                                                    subtitle="subtitle"
                                                                ),
                                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                    value="value"
                                                                ),
                                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                    value="value"
                                                                )
                                                            ),
                
                                                            # the properties below are optional
                                                            variations=[lex.CfnBot.MessageProperty(
                                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                    value="value"
                                                                ),
                                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                    title="title",
                
                                                                    # the properties below are optional
                                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                                        text="text",
                                                                        value="value"
                                                                    )],
                                                                    image_url="imageUrl",
                                                                    subtitle="subtitle"
                                                                ),
                                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                    value="value"
                                                                ),
                                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                    value="value"
                                                                )
                                                            )]
                                                        )],
                
                                                        # the properties below are optional
                                                        allow_interrupt=False
                                                    )
                                                )],
                                                default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                                    next_step=lex.CfnBot.DialogStateProperty(
                                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                                            type="type",
                
                                                            # the properties below are optional
                                                            slot_to_elicit="slotToElicit",
                                                            suppress_next_message=False
                                                        ),
                                                        intent=lex.CfnBot.IntentOverrideProperty(
                                                            name="name",
                                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                                slot_name="slotName",
                                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                                    shape="shape",
                                                                    value=lex.CfnBot.SlotValueProperty(
                                                                        interpreted_value="interpretedValue"
                                                                    ),
                                                                    values=[slot_value_override_property_]
                                                                )
                                                            )]
                                                        ),
                                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                            key="key",
                
                                                            # the properties below are optional
                                                            value="value"
                                                        )]
                                                    ),
                                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                            message=lex.CfnBot.MessageProperty(
                                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                    value="value"
                                                                ),
                                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                    title="title",
                
                                                                    # the properties below are optional
                                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                                        text="text",
                                                                        value="value"
                                                                    )],
                                                                    image_url="imageUrl",
                                                                    subtitle="subtitle"
                                                                ),
                                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                    value="value"
                                                                ),
                                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                    value="value"
                                                                )
                                                            ),
                
                                                            # the properties below are optional
                                                            variations=[lex.CfnBot.MessageProperty(
                                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                    value="value"
                                                                ),
                                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                    title="title",
                
                                                                    # the properties below are optional
                                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                                        text="text",
                                                                        value="value"
                                                                    )],
                                                                    image_url="imageUrl",
                                                                    subtitle="subtitle"
                                                                ),
                                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                    value="value"
                                                                ),
                                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                    value="value"
                                                                )
                                                            )]
                                                        )],
                
                                                        # the properties below are optional
                                                        allow_interrupt=False
                                                    )
                                                ),
                                                is_active=False
                                            ),
                                            failure_next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                                            failure_response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            ),
                                            success_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                                conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                                    condition=lex.CfnBot.ConditionProperty(
                                                        expression_string="expressionString"
                                                    ),
                                                    name="name",
                                                    next_step=lex.CfnBot.DialogStateProperty(
                                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                                            type="type",
                
                                                            # the properties below are optional
                                                            slot_to_elicit="slotToElicit",
                                                            suppress_next_message=False
                                                        ),
                                                        intent=lex.CfnBot.IntentOverrideProperty(
                                                            name="name",
                                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                                slot_name="slotName",
                                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                                    shape="shape",
                                                                    value=lex.CfnBot.SlotValueProperty(
                                                                        interpreted_value="interpretedValue"
                                                                    ),
                                                                    values=[slot_value_override_property_]
                                                                )
                                                            )]
                                                        ),
                                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                            key="key",
                
                                                            # the properties below are optional
                                                            value="value"
                                                        )]
                                                    ),
                
                                                    # the properties below are optional
                                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                            message=lex.CfnBot.MessageProperty(
                                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                    value="value"
                                                                ),
                                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                    title="title",
                
                                                                    # the properties below are optional
                                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                                        text="text",
                                                                        value="value"
                                                                    )],
                                                                    image_url="imageUrl",
                                                                    subtitle="subtitle"
                                                                ),
                                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                    value="value"
                                                                ),
                                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                    value="value"
                                                                )
                                                            ),
                
                                                            # the properties below are optional
                                                            variations=[lex.CfnBot.MessageProperty(
                                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                    value="value"
                                                                ),
                                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                    title="title",
                
                                                                    # the properties below are optional
                                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                                        text="text",
                                                                        value="value"
                                                                    )],
                                                                    image_url="imageUrl",
                                                                    subtitle="subtitle"
                                                                ),
                                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                    value="value"
                                                                ),
                                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                    value="value"
                                                                )
                                                            )]
                                                        )],
                
                                                        # the properties below are optional
                                                        allow_interrupt=False
                                                    )
                                                )],
                                                default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                                    next_step=lex.CfnBot.DialogStateProperty(
                                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                                            type="type",
                
                                                            # the properties below are optional
                                                            slot_to_elicit="slotToElicit",
                                                            suppress_next_message=False
                                                        ),
                                                        intent=lex.CfnBot.IntentOverrideProperty(
                                                            name="name",
                                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                                slot_name="slotName",
                                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                                    shape="shape",
                                                                    value=lex.CfnBot.SlotValueProperty(
                                                                        interpreted_value="interpretedValue"
                                                                    ),
                                                                    values=[slot_value_override_property_]
                                                                )
                                                            )]
                                                        ),
                                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                            key="key",
                
                                                            # the properties below are optional
                                                            value="value"
                                                        )]
                                                    ),
                                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                            message=lex.CfnBot.MessageProperty(
                                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                    value="value"
                                                                ),
                                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                    title="title",
                
                                                                    # the properties below are optional
                                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                                        text="text",
                                                                        value="value"
                                                                    )],
                                                                    image_url="imageUrl",
                                                                    subtitle="subtitle"
                                                                ),
                                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                    value="value"
                                                                ),
                                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                    value="value"
                                                                )
                                                            ),
                
                                                            # the properties below are optional
                                                            variations=[lex.CfnBot.MessageProperty(
                                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                    value="value"
                                                                ),
                                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                    title="title",
                
                                                                    # the properties below are optional
                                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                                        text="text",
                                                                        value="value"
                                                                    )],
                                                                    image_url="imageUrl",
                                                                    subtitle="subtitle"
                                                                ),
                                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                    value="value"
                                                                ),
                                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                    value="value"
                                                                )
                                                            )]
                                                        )],
                
                                                        # the properties below are optional
                                                        allow_interrupt=False
                                                    )
                                                ),
                                                is_active=False
                                            ),
                                            success_next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                                            success_response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            ),
                                            timeout_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                                conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                                    condition=lex.CfnBot.ConditionProperty(
                                                        expression_string="expressionString"
                                                    ),
                                                    name="name",
                                                    next_step=lex.CfnBot.DialogStateProperty(
                                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                                            type="type",
                
                                                            # the properties below are optional
                                                            slot_to_elicit="slotToElicit",
                                                            suppress_next_message=False
                                                        ),
                                                        intent=lex.CfnBot.IntentOverrideProperty(
                                                            name="name",
                                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                                slot_name="slotName",
                                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                                    shape="shape",
                                                                    value=lex.CfnBot.SlotValueProperty(
                                                                        interpreted_value="interpretedValue"
                                                                    ),
                                                                    values=[slot_value_override_property_]
                                                                )
                                                            )]
                                                        ),
                                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                            key="key",
                
                                                            # the properties below are optional
                                                            value="value"
                                                        )]
                                                    ),
                
                                                    # the properties below are optional
                                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                            message=lex.CfnBot.MessageProperty(
                                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                    value="value"
                                                                ),
                                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                    title="title",
                
                                                                    # the properties below are optional
                                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                                        text="text",
                                                                        value="value"
                                                                    )],
                                                                    image_url="imageUrl",
                                                                    subtitle="subtitle"
                                                                ),
                                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                    value="value"
                                                                ),
                                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                    value="value"
                                                                )
                                                            ),
                
                                                            # the properties below are optional
                                                            variations=[lex.CfnBot.MessageProperty(
                                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                    value="value"
                                                                ),
                                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                    title="title",
                
                                                                    # the properties below are optional
                                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                                        text="text",
                                                                        value="value"
                                                                    )],
                                                                    image_url="imageUrl",
                                                                    subtitle="subtitle"
                                                                ),
                                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                    value="value"
                                                                ),
                                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                    value="value"
                                                                )
                                                            )]
                                                        )],
                
                                                        # the properties below are optional
                                                        allow_interrupt=False
                                                    )
                                                )],
                                                default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                                    next_step=lex.CfnBot.DialogStateProperty(
                                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                                            type="type",
                
                                                            # the properties below are optional
                                                            slot_to_elicit="slotToElicit",
                                                            suppress_next_message=False
                                                        ),
                                                        intent=lex.CfnBot.IntentOverrideProperty(
                                                            name="name",
                                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                                slot_name="slotName",
                                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                                    shape="shape",
                                                                    value=lex.CfnBot.SlotValueProperty(
                                                                        interpreted_value="interpretedValue"
                                                                    ),
                                                                    values=[slot_value_override_property_]
                                                                )
                                                            )]
                                                        ),
                                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                            key="key",
                
                                                            # the properties below are optional
                                                            value="value"
                                                        )]
                                                    ),
                                                    response=lex.CfnBot.ResponseSpecificationProperty(
                                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                            message=lex.CfnBot.MessageProperty(
                                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                    value="value"
                                                                ),
                                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                    title="title",
                
                                                                    # the properties below are optional
                                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                                        text="text",
                                                                        value="value"
                                                                    )],
                                                                    image_url="imageUrl",
                                                                    subtitle="subtitle"
                                                                ),
                                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                    value="value"
                                                                ),
                                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                    value="value"
                                                                )
                                                            ),
                
                                                            # the properties below are optional
                                                            variations=[lex.CfnBot.MessageProperty(
                                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                                    value="value"
                                                                ),
                                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                                    title="title",
                
                                                                    # the properties below are optional
                                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                                        text="text",
                                                                        value="value"
                                                                    )],
                                                                    image_url="imageUrl",
                                                                    subtitle="subtitle"
                                                                ),
                                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                                    value="value"
                                                                ),
                                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                                    value="value"
                                                                )
                                                            )]
                                                        )],
                
                                                        # the properties below are optional
                                                        allow_interrupt=False
                                                    )
                                                ),
                                                is_active=False
                                            ),
                                            timeout_next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                                            timeout_response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        ),
                
                                        # the properties below are optional
                                        invocation_label="invocationLabel"
                                    ),
                                    elicitation_code_hook=lex.CfnBot.ElicitationCodeHookInvocationSettingProperty(
                                        enable_code_hook_invocation=False,
                
                                        # the properties below are optional
                                        invocation_label="invocationLabel"
                                    ),
                                    failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                                        conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                            condition=lex.CfnBot.ConditionProperty(
                                                expression_string="expressionString"
                                            ),
                                            name="name",
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                
                                            # the properties below are optional
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        )],
                                        default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                            next_step=lex.CfnBot.DialogStateProperty(
                                                dialog_action=lex.CfnBot.DialogActionProperty(
                                                    type="type",
                
                                                    # the properties below are optional
                                                    slot_to_elicit="slotToElicit",
                                                    suppress_next_message=False
                                                ),
                                                intent=lex.CfnBot.IntentOverrideProperty(
                                                    name="name",
                                                    slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                        slot_name="slotName",
                                                        slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                            shape="shape",
                                                            value=lex.CfnBot.SlotValueProperty(
                                                                interpreted_value="interpretedValue"
                                                            ),
                                                            values=[slot_value_override_property_]
                                                        )
                                                    )]
                                                ),
                                                session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                                    key="key",
                
                                                    # the properties below are optional
                                                    value="value"
                                                )]
                                            ),
                                            response=lex.CfnBot.ResponseSpecificationProperty(
                                                message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                                    message=lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    ),
                
                                                    # the properties below are optional
                                                    variations=[lex.CfnBot.MessageProperty(
                                                        custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                            value="value"
                                                        ),
                                                        image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                            title="title",
                
                                                            # the properties below are optional
                                                            buttons=[lex.CfnBot.ButtonProperty(
                                                                text="text",
                                                                value="value"
                                                            )],
                                                            image_url="imageUrl",
                                                            subtitle="subtitle"
                                                        ),
                                                        plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                            value="value"
                                                        ),
                                                        ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                            value="value"
                                                        )
                                                    )]
                                                )],
                
                                                # the properties below are optional
                                                allow_interrupt=False
                                            )
                                        ),
                                        is_active=False
                                    ),
                                    failure_next_step=lex.CfnBot.DialogStateProperty(
                                        dialog_action=lex.CfnBot.DialogActionProperty(
                                            type="type",
                
                                            # the properties below are optional
                                            slot_to_elicit="slotToElicit",
                                            suppress_next_message=False
                                        ),
                                        intent=lex.CfnBot.IntentOverrideProperty(
                                            name="name",
                                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                                slot_name="slotName",
                                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                    shape="shape",
                                                    value=lex.CfnBot.SlotValueProperty(
                                                        interpreted_value="interpretedValue"
                                                    ),
                                                    values=[slot_value_override_property_]
                                                )
                                            )]
                                        ),
                                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                            key="key",
                
                                            # the properties below are optional
                                            value="value"
                                        )]
                                    ),
                                    failure_response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                ),
                                wait_and_continue_specification=lex.CfnBot.WaitAndContinueSpecificationProperty(
                                    continue_response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    ),
                                    waiting_response=lex.CfnBot.ResponseSpecificationProperty(
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    ),
                
                                    # the properties below are optional
                                    is_active=False,
                                    still_waiting_response=lex.CfnBot.StillWaitingResponseSpecificationProperty(
                                        frequency_in_seconds=123,
                                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                            message=lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            ),
                
                                            # the properties below are optional
                                            variations=[lex.CfnBot.MessageProperty(
                                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                    value="value"
                                                ),
                                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                    title="title",
                
                                                    # the properties below are optional
                                                    buttons=[lex.CfnBot.ButtonProperty(
                                                        text="text",
                                                        value="value"
                                                    )],
                                                    image_url="imageUrl",
                                                    subtitle="subtitle"
                                                ),
                                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                    value="value"
                                                ),
                                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                    value="value"
                                                )
                                            )]
                                        )],
                                        timeout_in_seconds=123,
                
                                        # the properties below are optional
                                        allow_interrupt=False
                                    )
                                )
                            ),
                
                            # the properties below are optional
                            description="description",
                            multiple_values_setting=lex.CfnBot.MultipleValuesSettingProperty(
                                allow_multiple_values=False
                            ),
                            obfuscation_setting=lex.CfnBot.ObfuscationSettingProperty(
                                obfuscation_setting_type="obfuscationSettingType"
                            )
                        )]
                    )],
                    slot_types=[lex.CfnBot.SlotTypeProperty(
                        name="name",
                
                        # the properties below are optional
                        description="description",
                        external_source_setting=lex.CfnBot.ExternalSourceSettingProperty(
                            grammar_slot_type_setting=lex.CfnBot.GrammarSlotTypeSettingProperty(
                                source=lex.CfnBot.GrammarSlotTypeSourceProperty(
                                    s3_bucket_name="s3BucketName",
                                    s3_object_key="s3ObjectKey",
                
                                    # the properties below are optional
                                    kms_key_arn="kmsKeyArn"
                                )
                            )
                        ),
                        parent_slot_type_signature="parentSlotTypeSignature",
                        slot_type_values=[lex.CfnBot.SlotTypeValueProperty(
                            sample_value=lex.CfnBot.SampleValueProperty(
                                value="value"
                            ),
                
                            # the properties below are optional
                            synonyms=[lex.CfnBot.SampleValueProperty(
                                value="value"
                            )]
                        )],
                        value_selection_setting=lex.CfnBot.SlotValueSelectionSettingProperty(
                            resolution_strategy="resolutionStrategy",
                
                            # the properties below are optional
                            advanced_recognition_setting=lex.CfnBot.AdvancedRecognitionSettingProperty(
                                audio_recognition_strategy="audioRecognitionStrategy"
                            ),
                            regex_filter=lex.CfnBot.SlotValueRegexFilterProperty(
                                pattern="pattern"
                            )
                        )
                    )],
                    voice_settings=lex.CfnBot.VoiceSettingsProperty(
                        voice_id="voiceId",
                
                        # the properties below are optional
                        engine="engine"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__14a82cce828e0d9278905a24c9a75cf3e90c46735547a8a8dd170d77fb8b24dc)
                check_type(argname="argument locale_id", value=locale_id, expected_type=type_hints["locale_id"])
                check_type(argname="argument nlu_confidence_threshold", value=nlu_confidence_threshold, expected_type=type_hints["nlu_confidence_threshold"])
                check_type(argname="argument custom_vocabulary", value=custom_vocabulary, expected_type=type_hints["custom_vocabulary"])
                check_type(argname="argument description", value=description, expected_type=type_hints["description"])
                check_type(argname="argument intents", value=intents, expected_type=type_hints["intents"])
                check_type(argname="argument slot_types", value=slot_types, expected_type=type_hints["slot_types"])
                check_type(argname="argument voice_settings", value=voice_settings, expected_type=type_hints["voice_settings"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "locale_id": locale_id,
                "nlu_confidence_threshold": nlu_confidence_threshold,
            }
            if custom_vocabulary is not None:
                self._values["custom_vocabulary"] = custom_vocabulary
            if description is not None:
                self._values["description"] = description
            if intents is not None:
                self._values["intents"] = intents
            if slot_types is not None:
                self._values["slot_types"] = slot_types
            if voice_settings is not None:
                self._values["voice_settings"] = voice_settings

        @builtins.property
        def locale_id(self) -> builtins.str:
            '''The identifier of the language and locale that the bot will be used in.

            The string must match one of the supported locales.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-localeid
            '''
            result = self._values.get("locale_id")
            assert result is not None, "Required property 'locale_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def nlu_confidence_threshold(self) -> jsii.Number:
            '''Determines the threshold where Amazon Lex will insert the ``AMAZON.FallbackIntent`` , ``AMAZON.KendraSearchIntent`` , or both when returning alternative intents. You must configure an ``AMAZON.FallbackIntent`` . ``AMAZON.KendraSearchIntent`` is only inserted if it is configured for the bot.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-nluconfidencethreshold
            '''
            result = self._values.get("nlu_confidence_threshold")
            assert result is not None, "Required property 'nlu_confidence_threshold' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def custom_vocabulary(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.CustomVocabularyProperty"]]:
            '''Specifies a custom vocabulary to use with a specific locale.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-customvocabulary
            '''
            result = self._values.get("custom_vocabulary")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.CustomVocabularyProperty"]], result)

        @builtins.property
        def description(self) -> typing.Optional[builtins.str]:
            '''A description of the bot locale.

            Use this to help identify the bot locale in lists.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-description
            '''
            result = self._values.get("description")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def intents(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.IntentProperty"]]]]:
            '''One or more intents defined for the locale.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-intents
            '''
            result = self._values.get("intents")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.IntentProperty"]]]], result)

        @builtins.property
        def slot_types(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.SlotTypeProperty"]]]]:
            '''One or more slot types defined for the locale.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-slottypes
            '''
            result = self._values.get("slot_types")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.SlotTypeProperty"]]]], result)

        @builtins.property
        def voice_settings(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.VoiceSettingsProperty"]]:
            '''Defines settings for using an Amazon Polly voice to communicate with a user.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-voicesettings
            '''
            result = self._values.get("voice_settings")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.VoiceSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BotLocaleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.ButtonProperty",
        jsii_struct_bases=[],
        name_mapping={"text": "text", "value": "value"},
    )
    class ButtonProperty:
        def __init__(self, *, text: builtins.str, value: builtins.str) -> None:
            '''Describes a button to use on a response card used to gather slot values from a user.

            :param text: The text that appears on the button. Use this to tell the user what value is returned when they choose this button.
            :param value: The value returned to Amazon Lex when the user chooses this button. This must be one of the slot values configured for the slot.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-button.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                button_property = lex.CfnBot.ButtonProperty(
                    text="text",
                    value="value"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e07b0e828670df93418cdfd89bf0925e98396b9ebab2dc888ab2f620545f6269)
                check_type(argname="argument text", value=text, expected_type=type_hints["text"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "text": text,
                "value": value,
            }

        @builtins.property
        def text(self) -> builtins.str:
            '''The text that appears on the button.

            Use this to tell the user what value is returned when they choose this button.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-button.html#cfn-lex-bot-button-text
            '''
            result = self._values.get("text")
            assert result is not None, "Required property 'text' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def value(self) -> builtins.str:
            '''The value returned to Amazon Lex when the user chooses this button.

            This must be one of the slot values configured for the slot.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-button.html#cfn-lex-bot-button-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ButtonProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.CloudWatchLogGroupLogDestinationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "cloud_watch_log_group_arn": "cloudWatchLogGroupArn",
            "log_prefix": "logPrefix",
        },
    )
    class CloudWatchLogGroupLogDestinationProperty:
        def __init__(
            self,
            *,
            cloud_watch_log_group_arn: builtins.str,
            log_prefix: builtins.str,
        ) -> None:
            '''The Amazon CloudWatch Logs log group where the text and metadata logs are delivered.

            The log group must exist before you enable logging.

            :param cloud_watch_log_group_arn: The Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered.
            :param log_prefix: The prefix of the log stream name within the log group that you specified.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-cloudwatchloggrouplogdestination.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                cloud_watch_log_group_log_destination_property = lex.CfnBot.CloudWatchLogGroupLogDestinationProperty(
                    cloud_watch_log_group_arn="cloudWatchLogGroupArn",
                    log_prefix="logPrefix"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__806f4b049b50e6479a3b78ea5e58b022bc96989949b937c40e2470f9da95fff4)
                check_type(argname="argument cloud_watch_log_group_arn", value=cloud_watch_log_group_arn, expected_type=type_hints["cloud_watch_log_group_arn"])
                check_type(argname="argument log_prefix", value=log_prefix, expected_type=type_hints["log_prefix"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "cloud_watch_log_group_arn": cloud_watch_log_group_arn,
                "log_prefix": log_prefix,
            }

        @builtins.property
        def cloud_watch_log_group_arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-cloudwatchloggrouplogdestination.html#cfn-lex-bot-cloudwatchloggrouplogdestination-cloudwatchloggrouparn
            '''
            result = self._values.get("cloud_watch_log_group_arn")
            assert result is not None, "Required property 'cloud_watch_log_group_arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def log_prefix(self) -> builtins.str:
            '''The prefix of the log stream name within the log group that you specified.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-cloudwatchloggrouplogdestination.html#cfn-lex-bot-cloudwatchloggrouplogdestination-logprefix
            '''
            result = self._values.get("log_prefix")
            assert result is not None, "Required property 'log_prefix' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CloudWatchLogGroupLogDestinationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.CodeHookSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"lambda_code_hook": "lambdaCodeHook"},
    )
    class CodeHookSpecificationProperty:
        def __init__(
            self,
            *,
            lambda_code_hook: typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.LambdaCodeHookProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''Contains information about code hooks that Amazon Lex calls during a conversation.

            :param lambda_code_hook: Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-codehookspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                code_hook_specification_property = lex.CfnBot.CodeHookSpecificationProperty(
                    lambda_code_hook=lex.CfnBot.LambdaCodeHookProperty(
                        code_hook_interface_version="codeHookInterfaceVersion",
                        lambda_arn="lambdaArn"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3c6f628e13f551982d33a31b7c68467c2e75d803b98bb7bbe438f0d221d19feb)
                check_type(argname="argument lambda_code_hook", value=lambda_code_hook, expected_type=type_hints["lambda_code_hook"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "lambda_code_hook": lambda_code_hook,
            }

        @builtins.property
        def lambda_code_hook(
            self,
        ) -> typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.LambdaCodeHookProperty"]:
            '''Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-codehookspecification.html#cfn-lex-bot-codehookspecification-lambdacodehook
            '''
            result = self._values.get("lambda_code_hook")
            assert result is not None, "Required property 'lambda_code_hook' is missing"
            return typing.cast(typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.LambdaCodeHookProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CodeHookSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.ConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"expression_string": "expressionString"},
    )
    class ConditionProperty:
        def __init__(self, *, expression_string: builtins.str) -> None:
            '''Provides an expression that evaluates to true or false.

            :param expression_string: The expression string that is evaluated.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-condition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                condition_property = lex.CfnBot.ConditionProperty(
                    expression_string="expressionString"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__dbf57bb866a2b377e9a00725e125b045b4115adba4ce7924f289df75ce60673e)
                check_type(argname="argument expression_string", value=expression_string, expected_type=type_hints["expression_string"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "expression_string": expression_string,
            }

        @builtins.property
        def expression_string(self) -> builtins.str:
            '''The expression string that is evaluated.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-condition.html#cfn-lex-bot-condition-expressionstring
            '''
            result = self._values.get("expression_string")
            assert result is not None, "Required property 'expression_string' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.ConditionalBranchProperty",
        jsii_struct_bases=[],
        name_mapping={
            "condition": "condition",
            "name": "name",
            "next_step": "nextStep",
            "response": "response",
        },
    )
    class ConditionalBranchProperty:
        def __init__(
            self,
            *,
            condition: typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.ConditionProperty", typing.Dict[builtins.str, typing.Any]]],
            name: builtins.str,
            next_step: typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.DialogStateProperty", typing.Dict[builtins.str, typing.Any]]],
            response: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.ResponseSpecificationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A set of actions that Amazon Lex should run if the condition is matched.

            :param condition: Contains the expression to evaluate. If the condition is true, the branch's actions are taken.
            :param name: The name of the branch.
            :param next_step: The next step in the conversation.
            :param response: Specifies a list of message groups that Amazon Lex uses to respond the user input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                # slot_value_override_property_: lex.CfnBot.SlotValueOverrideProperty
                
                conditional_branch_property = lex.CfnBot.ConditionalBranchProperty(
                    condition=lex.CfnBot.ConditionProperty(
                        expression_string="expressionString"
                    ),
                    name="name",
                    next_step=lex.CfnBot.DialogStateProperty(
                        dialog_action=lex.CfnBot.DialogActionProperty(
                            type="type",
                
                            # the properties below are optional
                            slot_to_elicit="slotToElicit",
                            suppress_next_message=False
                        ),
                        intent=lex.CfnBot.IntentOverrideProperty(
                            name="name",
                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                slot_name="slotName",
                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                    shape="shape",
                                    value=lex.CfnBot.SlotValueProperty(
                                        interpreted_value="interpretedValue"
                                    ),
                                    values=[slot_value_override_property_]
                                )
                            )]
                        ),
                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                            key="key",
                
                            # the properties below are optional
                            value="value"
                        )]
                    ),
                
                    # the properties below are optional
                    response=lex.CfnBot.ResponseSpecificationProperty(
                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                            message=lex.CfnBot.MessageProperty(
                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                    value="value"
                                ),
                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                    title="title",
                
                                    # the properties below are optional
                                    buttons=[lex.CfnBot.ButtonProperty(
                                        text="text",
                                        value="value"
                                    )],
                                    image_url="imageUrl",
                                    subtitle="subtitle"
                                ),
                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                    value="value"
                                ),
                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                    value="value"
                                )
                            ),
                
                            # the properties below are optional
                            variations=[lex.CfnBot.MessageProperty(
                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                    value="value"
                                ),
                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                    title="title",
                
                                    # the properties below are optional
                                    buttons=[lex.CfnBot.ButtonProperty(
                                        text="text",
                                        value="value"
                                    )],
                                    image_url="imageUrl",
                                    subtitle="subtitle"
                                ),
                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                    value="value"
                                ),
                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                    value="value"
                                )
                            )]
                        )],
                
                        # the properties below are optional
                        allow_interrupt=False
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c359700cba2940c8c4516c8ae4286465f9b65cf9dd2e7e17b69c50bf5da488f2)
                check_type(argname="argument condition", value=condition, expected_type=type_hints["condition"])
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument next_step", value=next_step, expected_type=type_hints["next_step"])
                check_type(argname="argument response", value=response, expected_type=type_hints["response"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "condition": condition,
                "name": name,
                "next_step": next_step,
            }
            if response is not None:
                self._values["response"] = response

        @builtins.property
        def condition(
            self,
        ) -> typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.ConditionProperty"]:
            '''Contains the expression to evaluate.

            If the condition is true, the branch's actions are taken.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html#cfn-lex-bot-conditionalbranch-condition
            '''
            result = self._values.get("condition")
            assert result is not None, "Required property 'condition' is missing"
            return typing.cast(typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.ConditionProperty"], result)

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the branch.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html#cfn-lex-bot-conditionalbranch-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def next_step(
            self,
        ) -> typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.DialogStateProperty"]:
            '''The next step in the conversation.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html#cfn-lex-bot-conditionalbranch-nextstep
            '''
            result = self._values.get("next_step")
            assert result is not None, "Required property 'next_step' is missing"
            return typing.cast(typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.DialogStateProperty"], result)

        @builtins.property
        def response(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.ResponseSpecificationProperty"]]:
            '''Specifies a list of message groups that Amazon Lex uses to respond the user input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html#cfn-lex-bot-conditionalbranch-response
            '''
            result = self._values.get("response")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.ResponseSpecificationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionalBranchProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.ConditionalSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "conditional_branches": "conditionalBranches",
            "default_branch": "defaultBranch",
            "is_active": "isActive",
        },
    )
    class ConditionalSpecificationProperty:
        def __init__(
            self,
            *,
            conditional_branches: typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.ConditionalBranchProperty", typing.Dict[builtins.str, typing.Any]]]]],
            default_branch: typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.DefaultConditionalBranchProperty", typing.Dict[builtins.str, typing.Any]]],
            is_active: typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable],
        ) -> None:
            '''Provides a list of conditional branches.

            Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition.

            :param conditional_branches: A list of conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true.
            :param default_branch: The conditional branch that should be followed when the conditions for other branches are not satisfied. A conditional branch is made up of a condition, a response and a next step.
            :param is_active: Determines whether a conditional branch is active. When ``IsActive`` is false, the conditions are not evaluated.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                # slot_value_override_property_: lex.CfnBot.SlotValueOverrideProperty
                
                conditional_specification_property = lex.CfnBot.ConditionalSpecificationProperty(
                    conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                        condition=lex.CfnBot.ConditionProperty(
                            expression_string="expressionString"
                        ),
                        name="name",
                        next_step=lex.CfnBot.DialogStateProperty(
                            dialog_action=lex.CfnBot.DialogActionProperty(
                                type="type",
                
                                # the properties below are optional
                                slot_to_elicit="slotToElicit",
                                suppress_next_message=False
                            ),
                            intent=lex.CfnBot.IntentOverrideProperty(
                                name="name",
                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                    slot_name="slotName",
                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                        shape="shape",
                                        value=lex.CfnBot.SlotValueProperty(
                                            interpreted_value="interpretedValue"
                                        ),
                                        values=[slot_value_override_property_]
                                    )
                                )]
                            ),
                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                key="key",
                
                                # the properties below are optional
                                value="value"
                            )]
                        ),
                
                        # the properties below are optional
                        response=lex.CfnBot.ResponseSpecificationProperty(
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
                
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
                
                            # the properties below are optional
                            allow_interrupt=False
                        )
                    )],
                    default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                        next_step=lex.CfnBot.DialogStateProperty(
                            dialog_action=lex.CfnBot.DialogActionProperty(
                                type="type",
                
                                # the properties below are optional
                                slot_to_elicit="slotToElicit",
                                suppress_next_message=False
                            ),
                            intent=lex.CfnBot.IntentOverrideProperty(
                                name="name",
                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                    slot_name="slotName",
                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                        shape="shape",
                                        value=lex.CfnBot.SlotValueProperty(
                                            interpreted_value="interpretedValue"
                                        ),
                                        values=[slot_value_override_property_]
                                    )
                                )]
                            ),
                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                key="key",
                
                                # the properties below are optional
                                value="value"
                            )]
                        ),
                        response=lex.CfnBot.ResponseSpecificationProperty(
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
                
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
                
                            # the properties below are optional
                            allow_interrupt=False
                        )
                    ),
                    is_active=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9139def8ccd62ee86123a85f6d401c6ade591034035d573334b0d5862e739835)
                check_type(argname="argument conditional_branches", value=conditional_branches, expected_type=type_hints["conditional_branches"])
                check_type(argname="argument default_branch", value=default_branch, expected_type=type_hints["default_branch"])
                check_type(argname="argument is_active", value=is_active, expected_type=type_hints["is_active"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "conditional_branches": conditional_branches,
                "default_branch": default_branch,
                "is_active": is_active,
            }

        @builtins.property
        def conditional_branches(
            self,
        ) -> typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.ConditionalBranchProperty"]]]:
            '''A list of conditional branches.

            A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalspecification.html#cfn-lex-bot-conditionalspecification-conditionalbranches
            '''
            result = self._values.get("conditional_branches")
            assert result is not None, "Required property 'conditional_branches' is missing"
            return typing.cast(typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.ConditionalBranchProperty"]]], result)

        @builtins.property
        def default_branch(
            self,
        ) -> typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.DefaultConditionalBranchProperty"]:
            '''The conditional branch that should be followed when the conditions for other branches are not satisfied.

            A conditional branch is made up of a condition, a response and a next step.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalspecification.html#cfn-lex-bot-conditionalspecification-defaultbranch
            '''
            result = self._values.get("default_branch")
            assert result is not None, "Required property 'default_branch' is missing"
            return typing.cast(typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.DefaultConditionalBranchProperty"], result)

        @builtins.property
        def is_active(
            self,
        ) -> typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]:
            '''Determines whether a conditional branch is active.

            When ``IsActive`` is false, the conditions are not evaluated.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalspecification.html#cfn-lex-bot-conditionalspecification-isactive
            '''
            result = self._values.get("is_active")
            assert result is not None, "Required property 'is_active' is missing"
            return typing.cast(typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionalSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.ConversationLogSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "audio_log_settings": "audioLogSettings",
            "text_log_settings": "textLogSettings",
        },
    )
    class ConversationLogSettingsProperty:
        def __init__(
            self,
            *,
            audio_log_settings: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.AudioLogSettingProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            text_log_settings: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.TextLogSettingProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''Configures conversation logging that saves audio, text, and metadata for the conversations with your users.

            :param audio_log_settings: The Amazon S3 settings for logging audio to an S3 bucket.
            :param text_log_settings: The Amazon CloudWatch Logs settings for logging text and metadata.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conversationlogsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                conversation_log_settings_property = lex.CfnBot.ConversationLogSettingsProperty(
                    audio_log_settings=[lex.CfnBot.AudioLogSettingProperty(
                        destination=lex.CfnBot.AudioLogDestinationProperty(
                            s3_bucket=lex.CfnBot.S3BucketLogDestinationProperty(
                                log_prefix="logPrefix",
                                s3_bucket_arn="s3BucketArn",
                
                                # the properties below are optional
                                kms_key_arn="kmsKeyArn"
                            )
                        ),
                        enabled=False
                    )],
                    text_log_settings=[lex.CfnBot.TextLogSettingProperty(
                        destination=lex.CfnBot.TextLogDestinationProperty(
                            cloud_watch=lex.CfnBot.CloudWatchLogGroupLogDestinationProperty(
                                cloud_watch_log_group_arn="cloudWatchLogGroupArn",
                                log_prefix="logPrefix"
                            )
                        ),
                        enabled=False
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__32014d318a463d84d2ee90b10658989e7745be06c4a07c49052abde4628a8ade)
                check_type(argname="argument audio_log_settings", value=audio_log_settings, expected_type=type_hints["audio_log_settings"])
                check_type(argname="argument text_log_settings", value=text_log_settings, expected_type=type_hints["text_log_settings"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if audio_log_settings is not None:
                self._values["audio_log_settings"] = audio_log_settings
            if text_log_settings is not None:
                self._values["text_log_settings"] = text_log_settings

        @builtins.property
        def audio_log_settings(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.AudioLogSettingProperty"]]]]:
            '''The Amazon S3 settings for logging audio to an S3 bucket.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conversationlogsettings.html#cfn-lex-bot-conversationlogsettings-audiologsettings
            '''
            result = self._values.get("audio_log_settings")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.AudioLogSettingProperty"]]]], result)

        @builtins.property
        def text_log_settings(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.TextLogSettingProperty"]]]]:
            '''The Amazon CloudWatch Logs settings for logging text and metadata.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conversationlogsettings.html#cfn-lex-bot-conversationlogsettings-textlogsettings
            '''
            result = self._values.get("text_log_settings")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.TextLogSettingProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConversationLogSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.CustomPayloadProperty",
        jsii_struct_bases=[],
        name_mapping={"value": "value"},
    )
    class CustomPayloadProperty:
        def __init__(self, *, value: builtins.str) -> None:
            '''A custom response string that Amazon Lex sends to your application.

            You define the content and structure the string.

            :param value: The string that is sent to your application.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-custompayload.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                custom_payload_property = lex.CfnBot.CustomPayloadProperty(
                    value="value"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4c211a101090e012075cd5d7de400caf8737378224339c466fc9c98f1c66d972)
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "value": value,
            }

        @builtins.property
        def value(self) -> builtins.str:
            '''The string that is sent to your application.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-custompayload.html#cfn-lex-bot-custompayload-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomPayloadProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.CustomVocabularyItemProperty",
        jsii_struct_bases=[],
        name_mapping={
            "phrase": "phrase",
            "display_as": "displayAs",
            "weight": "weight",
        },
    )
    class CustomVocabularyItemProperty:
        def __init__(
            self,
            *,
            phrase: builtins.str,
            display_as: typing.Optional[builtins.str] = None,
            weight: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Specifies an entry in a custom vocabulary.

            :param phrase: Specifies 1 - 4 words that should be recognized.
            :param display_as: The DisplayAs value for the custom vocabulary item from the custom vocabulary list.
            :param weight: Specifies the degree to which the phrase recognition is boosted. The default value is 1.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabularyitem.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                custom_vocabulary_item_property = lex.CfnBot.CustomVocabularyItemProperty(
                    phrase="phrase",
                
                    # the properties below are optional
                    display_as="displayAs",
                    weight=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b46661b9ee8bacad87c11f515448797784114d8fdfb04e124aa3c7a0cfe232a3)
                check_type(argname="argument phrase", value=phrase, expected_type=type_hints["phrase"])
                check_type(argname="argument display_as", value=display_as, expected_type=type_hints["display_as"])
                check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "phrase": phrase,
            }
            if display_as is not None:
                self._values["display_as"] = display_as
            if weight is not None:
                self._values["weight"] = weight

        @builtins.property
        def phrase(self) -> builtins.str:
            '''Specifies 1 - 4 words that should be recognized.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabularyitem.html#cfn-lex-bot-customvocabularyitem-phrase
            '''
            result = self._values.get("phrase")
            assert result is not None, "Required property 'phrase' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def display_as(self) -> typing.Optional[builtins.str]:
            '''The DisplayAs value for the custom vocabulary item from the custom vocabulary list.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabularyitem.html#cfn-lex-bot-customvocabularyitem-displayas
            '''
            result = self._values.get("display_as")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def weight(self) -> typing.Optional[jsii.Number]:
            '''Specifies the degree to which the phrase recognition is boosted.

            The default value is 1.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabularyitem.html#cfn-lex-bot-customvocabularyitem-weight
            '''
            result = self._values.get("weight")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomVocabularyItemProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.CustomVocabularyProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_vocabulary_items": "customVocabularyItems"},
    )
    class CustomVocabularyProperty:
        def __init__(
            self,
            *,
            custom_vocabulary_items: typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.CustomVocabularyItemProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Specifies a custom vocabulary.

            A custom vocabulary is a list of words that you expect to be used during a conversation with your bot.

            :param custom_vocabulary_items: Specifies a list of words that you expect to be used during a conversation with your bot.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabulary.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                custom_vocabulary_property = lex.CfnBot.CustomVocabularyProperty(
                    custom_vocabulary_items=[lex.CfnBot.CustomVocabularyItemProperty(
                        phrase="phrase",
                
                        # the properties below are optional
                        display_as="displayAs",
                        weight=123
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__71081a5a4f02cf15b2b9585786d6b5e59f91107b18d6dc2d0f807a12251a9a35)
                check_type(argname="argument custom_vocabulary_items", value=custom_vocabulary_items, expected_type=type_hints["custom_vocabulary_items"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "custom_vocabulary_items": custom_vocabulary_items,
            }

        @builtins.property
        def custom_vocabulary_items(
            self,
        ) -> typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.CustomVocabularyItemProperty"]]]:
            '''Specifies a list of words that you expect to be used during a conversation with your bot.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabulary.html#cfn-lex-bot-customvocabulary-customvocabularyitems
            '''
            result = self._values.get("custom_vocabulary_items")
            assert result is not None, "Required property 'custom_vocabulary_items' is missing"
            return typing.cast(typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.CustomVocabularyItemProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomVocabularyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.DTMFSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "deletion_character": "deletionCharacter",
            "end_character": "endCharacter",
            "end_timeout_ms": "endTimeoutMs",
            "max_length": "maxLength",
        },
    )
    class DTMFSpecificationProperty:
        def __init__(
            self,
            *,
            deletion_character: builtins.str,
            end_character: builtins.str,
            end_timeout_ms: jsii.Number,
            max_length: jsii.Number,
        ) -> None:
            '''Specifies the DTMF input specifications.

            :param deletion_character: The DTMF character that clears the accumulated DTMF digits and immediately ends the input.
            :param end_character: The DTMF character that immediately ends input. If the user does not press this character, the input ends after the end timeout.
            :param end_timeout_ms: How long the bot should wait after the last DTMF character input before assuming that the input has concluded.
            :param max_length: The maximum number of DTMF digits allowed in an utterance.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                d_tMFSpecification_property = lex.CfnBot.DTMFSpecificationProperty(
                    deletion_character="deletionCharacter",
                    end_character="endCharacter",
                    end_timeout_ms=123,
                    max_length=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bfb971d2a02e83430a9bfb5997fb6398deb433696e160a3d596545bf7b2f93ed)
                check_type(argname="argument deletion_character", value=deletion_character, expected_type=type_hints["deletion_character"])
                check_type(argname="argument end_character", value=end_character, expected_type=type_hints["end_character"])
                check_type(argname="argument end_timeout_ms", value=end_timeout_ms, expected_type=type_hints["end_timeout_ms"])
                check_type(argname="argument max_length", value=max_length, expected_type=type_hints["max_length"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "deletion_character": deletion_character,
                "end_character": end_character,
                "end_timeout_ms": end_timeout_ms,
                "max_length": max_length,
            }

        @builtins.property
        def deletion_character(self) -> builtins.str:
            '''The DTMF character that clears the accumulated DTMF digits and immediately ends the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html#cfn-lex-bot-dtmfspecification-deletioncharacter
            '''
            result = self._values.get("deletion_character")
            assert result is not None, "Required property 'deletion_character' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def end_character(self) -> builtins.str:
            '''The DTMF character that immediately ends input.

            If the user does not press this character, the input ends after the end timeout.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html#cfn-lex-bot-dtmfspecification-endcharacter
            '''
            result = self._values.get("end_character")
            assert result is not None, "Required property 'end_character' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def end_timeout_ms(self) -> jsii.Number:
            '''How long the bot should wait after the last DTMF character input before assuming that the input has concluded.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html#cfn-lex-bot-dtmfspecification-endtimeoutms
            '''
            result = self._values.get("end_timeout_ms")
            assert result is not None, "Required property 'end_timeout_ms' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def max_length(self) -> jsii.Number:
            '''The maximum number of DTMF digits allowed in an utterance.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html#cfn-lex-bot-dtmfspecification-maxlength
            '''
            result = self._values.get("max_length")
            assert result is not None, "Required property 'max_length' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DTMFSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.DataPrivacyProperty",
        jsii_struct_bases=[],
        name_mapping={"child_directed": "childDirected"},
    )
    class DataPrivacyProperty:
        def __init__(
            self,
            *,
            child_directed: typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable],
        ) -> None:
            '''By default, data stored by Amazon Lex is encrypted.

            The ``DataPrivacy`` structure provides settings that determine how Amazon Lex handles special cases of securing the data for your bot.

            :param child_directed: For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying ``true`` or ``false`` in the ``childDirected`` field. By specifying ``true`` in the ``childDirected`` field, you confirm that your use of Amazon Lex *is* related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying ``false`` in the ``childDirected`` field, you confirm that your use of Amazon Lex *is not* related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the ``childDirected`` field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the `Amazon Lex FAQ <https://docs.aws.amazon.com/lex/faqs#data-security>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dataprivacy.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                data_privacy_property = lex.CfnBot.DataPrivacyProperty(
                    child_directed=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4e2d76be0ab1d7bef5b2db6f6b7068e3739548eec497c49a26dd5bd2f3955b25)
                check_type(argname="argument child_directed", value=child_directed, expected_type=type_hints["child_directed"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "child_directed": child_directed,
            }

        @builtins.property
        def child_directed(
            self,
        ) -> typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]:
            '''For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying ``true`` or ``false`` in the ``childDirected`` field.

            By specifying ``true`` in the ``childDirected`` field, you confirm that your use of Amazon Lex *is* related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying ``false`` in the ``childDirected`` field, you confirm that your use of Amazon Lex *is not* related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the ``childDirected`` field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the `Amazon Lex FAQ <https://docs.aws.amazon.com/lex/faqs#data-security>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dataprivacy.html#cfn-lex-bot-dataprivacy-childdirected
            '''
            result = self._values.get("child_directed")
            assert result is not None, "Required property 'child_directed' is missing"
            return typing.cast(typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataPrivacyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.DefaultConditionalBranchProperty",
        jsii_struct_bases=[],
        name_mapping={"next_step": "nextStep", "response": "response"},
    )
    class DefaultConditionalBranchProperty:
        def __init__(
            self,
            *,
            next_step: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.DialogStateProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            response: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.ResponseSpecificationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A set of actions that Amazon Lex should run if none of the other conditions are met.

            :param next_step: The next step in the conversation.
            :param response: Specifies a list of message groups that Amazon Lex uses to respond the user input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-defaultconditionalbranch.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                # slot_value_override_property_: lex.CfnBot.SlotValueOverrideProperty
                
                default_conditional_branch_property = lex.CfnBot.DefaultConditionalBranchProperty(
                    next_step=lex.CfnBot.DialogStateProperty(
                        dialog_action=lex.CfnBot.DialogActionProperty(
                            type="type",
                
                            # the properties below are optional
                            slot_to_elicit="slotToElicit",
                            suppress_next_message=False
                        ),
                        intent=lex.CfnBot.IntentOverrideProperty(
                            name="name",
                            slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                slot_name="slotName",
                                slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                    shape="shape",
                                    value=lex.CfnBot.SlotValueProperty(
                                        interpreted_value="interpretedValue"
                                    ),
                                    values=[slot_value_override_property_]
                                )
                            )]
                        ),
                        session_attributes=[lex.CfnBot.SessionAttributeProperty(
                            key="key",
                
                            # the properties below are optional
                            value="value"
                        )]
                    ),
                    response=lex.CfnBot.ResponseSpecificationProperty(
                        message_groups_list=[lex.CfnBot.MessageGroupProperty(
                            message=lex.CfnBot.MessageProperty(
                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                    value="value"
                                ),
                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                    title="title",
                
                                    # the properties below are optional
                                    buttons=[lex.CfnBot.ButtonProperty(
                                        text="text",
                                        value="value"
                                    )],
                                    image_url="imageUrl",
                                    subtitle="subtitle"
                                ),
                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                    value="value"
                                ),
                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                    value="value"
                                )
                            ),
                
                            # the properties below are optional
                            variations=[lex.CfnBot.MessageProperty(
                                custom_payload=lex.CfnBot.CustomPayloadProperty(
                                    value="value"
                                ),
                                image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                    title="title",
                
                                    # the properties below are optional
                                    buttons=[lex.CfnBot.ButtonProperty(
                                        text="text",
                                        value="value"
                                    )],
                                    image_url="imageUrl",
                                    subtitle="subtitle"
                                ),
                                plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                    value="value"
                                ),
                                ssml_message=lex.CfnBot.SSMLMessageProperty(
                                    value="value"
                                )
                            )]
                        )],
                
                        # the properties below are optional
                        allow_interrupt=False
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e7bf6f07843b469410114625c3542e6e8f273529fbb54f5f25d523fd796fc83a)
                check_type(argname="argument next_step", value=next_step, expected_type=type_hints["next_step"])
                check_type(argname="argument response", value=response, expected_type=type_hints["response"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if next_step is not None:
                self._values["next_step"] = next_step
            if response is not None:
                self._values["response"] = response

        @builtins.property
        def next_step(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.DialogStateProperty"]]:
            '''The next step in the conversation.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-defaultconditionalbranch.html#cfn-lex-bot-defaultconditionalbranch-nextstep
            '''
            result = self._values.get("next_step")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.DialogStateProperty"]], result)

        @builtins.property
        def response(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.ResponseSpecificationProperty"]]:
            '''Specifies a list of message groups that Amazon Lex uses to respond the user input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-defaultconditionalbranch.html#cfn-lex-bot-defaultconditionalbranch-response
            '''
            result = self._values.get("response")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.ResponseSpecificationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultConditionalBranchProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.DialogActionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "type": "type",
            "slot_to_elicit": "slotToElicit",
            "suppress_next_message": "suppressNextMessage",
        },
    )
    class DialogActionProperty:
        def __init__(
            self,
            *,
            type: builtins.str,
            slot_to_elicit: typing.Optional[builtins.str] = None,
            suppress_next_message: typing.Optional[typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]] = None,
        ) -> None:
            '''Defines the action that the bot executes at runtime when the conversation reaches this step.

            :param type: The action that the bot should execute.
            :param slot_to_elicit: If the dialog action is ``ElicitSlot`` , defines the slot to elicit from the user.
            :param suppress_next_message: When true the next message for the intent is not used.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                dialog_action_property = lex.CfnBot.DialogActionProperty(
                    type="type",
                
                    # the properties below are optional
                    slot_to_elicit="slotToElicit",
                    suppress_next_message=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__134884338917f62cb048e6128baebc7878cfff79a6467db2ea33e27f44611d94)
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
                check_type(argname="argument slot_to_elicit", value=slot_to_elicit, expected_type=type_hints["slot_to_elicit"])
                check_type(argname="argument suppress_next_message", value=suppress_next_message, expected_type=type_hints["suppress_next_message"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "type": type,
            }
            if slot_to_elicit is not None:
                self._values["slot_to_elicit"] = slot_to_elicit
            if suppress_next_message is not None:
                self._values["suppress_next_message"] = suppress_next_message

        @builtins.property
        def type(self) -> builtins.str:
            '''The action that the bot should execute.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogaction.html#cfn-lex-bot-dialogaction-type
            '''
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def slot_to_elicit(self) -> typing.Optional[builtins.str]:
            '''If the dialog action is ``ElicitSlot`` , defines the slot to elicit from the user.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogaction.html#cfn-lex-bot-dialogaction-slottoelicit
            '''
            result = self._values.get("slot_to_elicit")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def suppress_next_message(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]]:
            '''When true the next message for the intent is not used.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogaction.html#cfn-lex-bot-dialogaction-suppressnextmessage
            '''
            result = self._values.get("suppress_next_message")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DialogActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.DialogCodeHookInvocationSettingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enable_code_hook_invocation": "enableCodeHookInvocation",
            "is_active": "isActive",
            "post_code_hook_specification": "postCodeHookSpecification",
            "invocation_label": "invocationLabel",
        },
    )
    class DialogCodeHookInvocationSettingProperty:
        def __init__(
            self,
            *,
            enable_code_hook_invocation: typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable],
            is_active: typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable],
            post_code_hook_specification: typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.PostDialogCodeHookInvocationSpecificationProperty", typing.Dict[builtins.str, typing.Any]]],
            invocation_label: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Settings that specify the dialog code hook that is called by Amazon Lex at a step of the conversation.

            :param enable_code_hook_invocation: Indicates whether a Lambda function should be invoked for the dialog.
            :param is_active: Determines whether a dialog code hook is used when the intent is activated.
            :param post_code_hook_specification: Contains the responses and actions that Amazon Lex takes after the Lambda function is complete.
            :param invocation_label: A label that indicates the dialog step from which the dialog code hook is happening.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                # slot_value_override_property_: lex.CfnBot.SlotValueOverrideProperty
                
                dialog_code_hook_invocation_setting_property = lex.CfnBot.DialogCodeHookInvocationSettingProperty(
                    enable_code_hook_invocation=False,
                    is_active=False,
                    post_code_hook_specification=lex.CfnBot.PostDialogCodeHookInvocationSpecificationProperty(
                        failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                condition=lex.CfnBot.ConditionProperty(
                                    expression_string="expressionString"
                                ),
                                name="name",
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                
                                # the properties below are optional
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            )],
                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
                            is_active=False
                        ),
                        failure_next_step=lex.CfnBot.DialogStateProperty(
                            dialog_action=lex.CfnBot.DialogActionProperty(
                                type="type",
                
                                # the properties below are optional
                                slot_to_elicit="slotToElicit",
                                suppress_next_message=False
                            ),
                            intent=lex.CfnBot.IntentOverrideProperty(
                                name="name",
                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                    slot_name="slotName",
                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                        shape="shape",
                                        value=lex.CfnBot.SlotValueProperty(
                                            interpreted_value="interpretedValue"
                                        ),
                                        values=[slot_value_override_property_]
                                    )
                                )]
                            ),
                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                key="key",
                
                                # the properties below are optional
                                value="value"
                            )]
                        ),
                        failure_response=lex.CfnBot.ResponseSpecificationProperty(
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
                
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
                
                            # the properties below are optional
                            allow_interrupt=False
                        ),
                        success_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                condition=lex.CfnBot.ConditionProperty(
                                    expression_string="expressionString"
                                ),
                                name="name",
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                
                                # the properties below are optional
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            )],
                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
                            is_active=False
                        ),
                        success_next_step=lex.CfnBot.DialogStateProperty(
                            dialog_action=lex.CfnBot.DialogActionProperty(
                                type="type",
                
                                # the properties below are optional
                                slot_to_elicit="slotToElicit",
                                suppress_next_message=False
                            ),
                            intent=lex.CfnBot.IntentOverrideProperty(
                                name="name",
                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                    slot_name="slotName",
                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                        shape="shape",
                                        value=lex.CfnBot.SlotValueProperty(
                                            interpreted_value="interpretedValue"
                                        ),
                                        values=[slot_value_override_property_]
                                    )
                                )]
                            ),
                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                key="key",
                
                                # the properties below are optional
                                value="value"
                            )]
                        ),
                        success_response=lex.CfnBot.ResponseSpecificationProperty(
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
                
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
                
                            # the properties below are optional
                            allow_interrupt=False
                        ),
                        timeout_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                condition=lex.CfnBot.ConditionProperty(
                                    expression_string="expressionString"
                                ),
                                name="name",
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                
                                # the properties below are optional
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            )],
                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
                            is_active=False
                        ),
                        timeout_next_step=lex.CfnBot.DialogStateProperty(
                            dialog_action=lex.CfnBot.DialogActionProperty(
                                type="type",
                
                                # the properties below are optional
                                slot_to_elicit="slotToElicit",
                                suppress_next_message=False
                            ),
                            intent=lex.CfnBot.IntentOverrideProperty(
                                name="name",
                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                    slot_name="slotName",
                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                        shape="shape",
                                        value=lex.CfnBot.SlotValueProperty(
                                            interpreted_value="interpretedValue"
                                        ),
                                        values=[slot_value_override_property_]
                                    )
                                )]
                            ),
                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                key="key",
                
                                # the properties below are optional
                                value="value"
                            )]
                        ),
                        timeout_response=lex.CfnBot.ResponseSpecificationProperty(
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
                
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
                
                            # the properties below are optional
                            allow_interrupt=False
                        )
                    ),
                
                    # the properties below are optional
                    invocation_label="invocationLabel"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d8dedf43eb07aae1f35337a17c663ecab3ee117c9872506852f081daf7f9d3bd)
                check_type(argname="argument enable_code_hook_invocation", value=enable_code_hook_invocation, expected_type=type_hints["enable_code_hook_invocation"])
                check_type(argname="argument is_active", value=is_active, expected_type=type_hints["is_active"])
                check_type(argname="argument post_code_hook_specification", value=post_code_hook_specification, expected_type=type_hints["post_code_hook_specification"])
                check_type(argname="argument invocation_label", value=invocation_label, expected_type=type_hints["invocation_label"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "enable_code_hook_invocation": enable_code_hook_invocation,
                "is_active": is_active,
                "post_code_hook_specification": post_code_hook_specification,
            }
            if invocation_label is not None:
                self._values["invocation_label"] = invocation_label

        @builtins.property
        def enable_code_hook_invocation(
            self,
        ) -> typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]:
            '''Indicates whether a Lambda function should be invoked for the dialog.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html#cfn-lex-bot-dialogcodehookinvocationsetting-enablecodehookinvocation
            '''
            result = self._values.get("enable_code_hook_invocation")
            assert result is not None, "Required property 'enable_code_hook_invocation' is missing"
            return typing.cast(typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable], result)

        @builtins.property
        def is_active(
            self,
        ) -> typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]:
            '''Determines whether a dialog code hook is used when the intent is activated.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html#cfn-lex-bot-dialogcodehookinvocationsetting-isactive
            '''
            result = self._values.get("is_active")
            assert result is not None, "Required property 'is_active' is missing"
            return typing.cast(typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable], result)

        @builtins.property
        def post_code_hook_specification(
            self,
        ) -> typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.PostDialogCodeHookInvocationSpecificationProperty"]:
            '''Contains the responses and actions that Amazon Lex takes after the Lambda function is complete.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html#cfn-lex-bot-dialogcodehookinvocationsetting-postcodehookspecification
            '''
            result = self._values.get("post_code_hook_specification")
            assert result is not None, "Required property 'post_code_hook_specification' is missing"
            return typing.cast(typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.PostDialogCodeHookInvocationSpecificationProperty"], result)

        @builtins.property
        def invocation_label(self) -> typing.Optional[builtins.str]:
            '''A label that indicates the dialog step from which the dialog code hook is happening.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html#cfn-lex-bot-dialogcodehookinvocationsetting-invocationlabel
            '''
            result = self._values.get("invocation_label")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DialogCodeHookInvocationSettingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.DialogCodeHookSettingProperty",
        jsii_struct_bases=[],
        name_mapping={"enabled": "enabled"},
    )
    class DialogCodeHookSettingProperty:
        def __init__(
            self,
            *,
            enabled: typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable],
        ) -> None:
            '''Settings that determine the Lambda function that Amazon Lex uses for processing user responses.

            :param enabled: Enables the dialog code hook so that it processes user requests.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehooksetting.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                dialog_code_hook_setting_property = lex.CfnBot.DialogCodeHookSettingProperty(
                    enabled=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6db6c1b57aa2e6666240e75ea9ff22c796a6d1dcd210a5da32a2412b0d9c6d6b)
                check_type(argname="argument enabled", value=enabled, expected_type=type_hints["enabled"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "enabled": enabled,
            }

        @builtins.property
        def enabled(
            self,
        ) -> typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]:
            '''Enables the dialog code hook so that it processes user requests.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehooksetting.html#cfn-lex-bot-dialogcodehooksetting-enabled
            '''
            result = self._values.get("enabled")
            assert result is not None, "Required property 'enabled' is missing"
            return typing.cast(typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DialogCodeHookSettingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.DialogStateProperty",
        jsii_struct_bases=[],
        name_mapping={
            "dialog_action": "dialogAction",
            "intent": "intent",
            "session_attributes": "sessionAttributes",
        },
    )
    class DialogStateProperty:
        def __init__(
            self,
            *,
            dialog_action: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.DialogActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            intent: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.IntentOverrideProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            session_attributes: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Sequence[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.SessionAttributeProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''The current state of the conversation with the user.

            :param dialog_action: Defines the action that the bot executes at runtime when the conversation reaches this step.
            :param intent: Override settings to configure the intent state.
            :param session_attributes: Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogstate.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                # slot_value_override_property_: lex.CfnBot.SlotValueOverrideProperty
                
                dialog_state_property = lex.CfnBot.DialogStateProperty(
                    dialog_action=lex.CfnBot.DialogActionProperty(
                        type="type",
                
                        # the properties below are optional
                        slot_to_elicit="slotToElicit",
                        suppress_next_message=False
                    ),
                    intent=lex.CfnBot.IntentOverrideProperty(
                        name="name",
                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                            slot_name="slotName",
                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                shape="shape",
                                value=lex.CfnBot.SlotValueProperty(
                                    interpreted_value="interpretedValue"
                                ),
                                values=[slot_value_override_property_]
                            )
                        )]
                    ),
                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                        key="key",
                
                        # the properties below are optional
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__81678dce6eb6aa2e6ca3849f8ea9cd0df99c822ee2c91d2536a16dc2ab8e46e7)
                check_type(argname="argument dialog_action", value=dialog_action, expected_type=type_hints["dialog_action"])
                check_type(argname="argument intent", value=intent, expected_type=type_hints["intent"])
                check_type(argname="argument session_attributes", value=session_attributes, expected_type=type_hints["session_attributes"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if dialog_action is not None:
                self._values["dialog_action"] = dialog_action
            if intent is not None:
                self._values["intent"] = intent
            if session_attributes is not None:
                self._values["session_attributes"] = session_attributes

        @builtins.property
        def dialog_action(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.DialogActionProperty"]]:
            '''Defines the action that the bot executes at runtime when the conversation reaches this step.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogstate.html#cfn-lex-bot-dialogstate-dialogaction
            '''
            result = self._values.get("dialog_action")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.DialogActionProperty"]], result)

        @builtins.property
        def intent(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.IntentOverrideProperty"]]:
            '''Override settings to configure the intent state.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogstate.html#cfn-lex-bot-dialogstate-intent
            '''
            result = self._values.get("intent")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.IntentOverrideProperty"]], result)

        @builtins.property
        def session_attributes(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.SessionAttributeProperty"]]]]:
            '''Map of key/value pairs representing session-specific context information.

            It contains application information passed between Amazon Lex and a client application.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogstate.html#cfn-lex-bot-dialogstate-sessionattributes
            '''
            result = self._values.get("session_attributes")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.List[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.SessionAttributeProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DialogStateProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.ElicitationCodeHookInvocationSettingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enable_code_hook_invocation": "enableCodeHookInvocation",
            "invocation_label": "invocationLabel",
        },
    )
    class ElicitationCodeHookInvocationSettingProperty:
        def __init__(
            self,
            *,
            enable_code_hook_invocation: typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable],
            invocation_label: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Settings that specify the dialog code hook that is called by Amazon Lex between eliciting slot values.

            :param enable_code_hook_invocation: Indicates whether a Lambda function should be invoked for the dialog.
            :param invocation_label: A label that indicates the dialog step from which the dialog code hook is happening.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-elicitationcodehookinvocationsetting.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                elicitation_code_hook_invocation_setting_property = lex.CfnBot.ElicitationCodeHookInvocationSettingProperty(
                    enable_code_hook_invocation=False,
                
                    # the properties below are optional
                    invocation_label="invocationLabel"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__80587fe6b27481dc6b97f6f3bc59b0fb19e7a8ffe1dc5c600444d44cd21f27c2)
                check_type(argname="argument enable_code_hook_invocation", value=enable_code_hook_invocation, expected_type=type_hints["enable_code_hook_invocation"])
                check_type(argname="argument invocation_label", value=invocation_label, expected_type=type_hints["invocation_label"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "enable_code_hook_invocation": enable_code_hook_invocation,
            }
            if invocation_label is not None:
                self._values["invocation_label"] = invocation_label

        @builtins.property
        def enable_code_hook_invocation(
            self,
        ) -> typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]:
            '''Indicates whether a Lambda function should be invoked for the dialog.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-elicitationcodehookinvocationsetting.html#cfn-lex-bot-elicitationcodehookinvocationsetting-enablecodehookinvocation
            '''
            result = self._values.get("enable_code_hook_invocation")
            assert result is not None, "Required property 'enable_code_hook_invocation' is missing"
            return typing.cast(typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable], result)

        @builtins.property
        def invocation_label(self) -> typing.Optional[builtins.str]:
            '''A label that indicates the dialog step from which the dialog code hook is happening.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-elicitationcodehookinvocationsetting.html#cfn-lex-bot-elicitationcodehookinvocationsetting-invocationlabel
            '''
            result = self._values.get("invocation_label")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ElicitationCodeHookInvocationSettingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.ExternalSourceSettingProperty",
        jsii_struct_bases=[],
        name_mapping={"grammar_slot_type_setting": "grammarSlotTypeSetting"},
    )
    class ExternalSourceSettingProperty:
        def __init__(
            self,
            *,
            grammar_slot_type_setting: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.GrammarSlotTypeSettingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Provides information about the external source of the slot type's definition.

            :param grammar_slot_type_setting: Settings required for a slot type based on a grammar that you provide.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-externalsourcesetting.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                external_source_setting_property = lex.CfnBot.ExternalSourceSettingProperty(
                    grammar_slot_type_setting=lex.CfnBot.GrammarSlotTypeSettingProperty(
                        source=lex.CfnBot.GrammarSlotTypeSourceProperty(
                            s3_bucket_name="s3BucketName",
                            s3_object_key="s3ObjectKey",
                
                            # the properties below are optional
                            kms_key_arn="kmsKeyArn"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__048a8708754b33da941ab48ab56d391c82ce3900f3f968f262b5d4674d4ac1df)
                check_type(argname="argument grammar_slot_type_setting", value=grammar_slot_type_setting, expected_type=type_hints["grammar_slot_type_setting"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if grammar_slot_type_setting is not None:
                self._values["grammar_slot_type_setting"] = grammar_slot_type_setting

        @builtins.property
        def grammar_slot_type_setting(
            self,
        ) -> typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.GrammarSlotTypeSettingProperty"]]:
            '''Settings required for a slot type based on a grammar that you provide.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-externalsourcesetting.html#cfn-lex-bot-externalsourcesetting-grammarslottypesetting
            '''
            result = self._values.get("grammar_slot_type_setting")
            return typing.cast(typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, "CfnBot.GrammarSlotTypeSettingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ExternalSourceSettingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-lex.CfnBot.FulfillmentCodeHookSettingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enabled": "enabled",
            "fulfillment_updates_specification": "fulfillmentUpdatesSpecification",
            "is_active": "isActive",
            "post_fulfillment_status_specification": "postFulfillmentStatusSpecification",
        },
    )
    class FulfillmentCodeHookSettingProperty:
        def __init__(
            self,
            *,
            enabled: typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable],
            fulfillment_updates_specification: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.FulfillmentUpdatesSpecificationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            is_active: typing.Optional[typing.Union[builtins.bool, _aws_cdk_core_f4b25747.IResolvable]] = None,
            post_fulfillment_status_specification: typing.Optional[typing.Union[_aws_cdk_core_f4b25747.IResolvable, typing.Union["CfnBot.PostFulfillmentStatusSpecificationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Determines if a Lambda function should be invoked for a specific intent.

            :param enabled: Indicates whether a Lambda function should be invoked to fulfill a specific intent.
            :param fulfillment_updates_specification: Provides settings for update messages sent to the user for long-running Lambda fulfillment functions. Fulfillment updates can be used only with streaming conversations.
            :param is_active: Determines whether the fulfillment code hook is used. When ``active`` is false, the code hook doesn't run.
            :param post_fulfillment_status_specification: Provides settings for messages sent to the user for after the Lambda fulfillment function completes. Post-fulfillment messages can be sent for both streaming and non-streaming conversations.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentcodehooksetting.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_lex as lex
                
                # slot_value_override_property_: lex.CfnBot.SlotValueOverrideProperty
                
                fulfillment_code_hook_setting_property = lex.CfnBot.FulfillmentCodeHookSettingProperty(
                    enabled=False,
                
                    # the properties below are optional
                    fulfillment_updates_specification=lex.CfnBot.FulfillmentUpdatesSpecificationProperty(
                        active=False,
                
                        # the properties below are optional
                        start_response=lex.CfnBot.FulfillmentStartResponseSpecificationProperty(
                            delay_in_seconds=123,
                            message_groups=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
                
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
                
                            # the properties below are optional
                            allow_interrupt=False
                        ),
                        timeout_in_seconds=123,
                        update_response=lex.CfnBot.FulfillmentUpdateResponseSpecificationProperty(
                            frequency_in_seconds=123,
                            message_groups=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
                
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
                
                            # the properties below are optional
                            allow_interrupt=False
                        )
                    ),
                    is_active=False,
                    post_fulfillment_status_specification=lex.CfnBot.PostFulfillmentStatusSpecificationProperty(
                        failure_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                condition=lex.CfnBot.ConditionProperty(
                                    expression_string="expressionString"
                                ),
                                name="name",
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                
                                # the properties below are optional
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            )],
                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
                            is_active=False
                        ),
                        failure_next_step=lex.CfnBot.DialogStateProperty(
                            dialog_action=lex.CfnBot.DialogActionProperty(
                                type="type",
                
                                # the properties below are optional
                                slot_to_elicit="slotToElicit",
                                suppress_next_message=False
                            ),
                            intent=lex.CfnBot.IntentOverrideProperty(
                                name="name",
                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                    slot_name="slotName",
                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                        shape="shape",
                                        value=lex.CfnBot.SlotValueProperty(
                                            interpreted_value="interpretedValue"
                                        ),
                                        values=[slot_value_override_property_]
                                    )
                                )]
                            ),
                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                key="key",
                
                                # the properties below are optional
                                value="value"
                            )]
                        ),
                        failure_response=lex.CfnBot.ResponseSpecificationProperty(
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
                
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
                
                            # the properties below are optional
                            allow_interrupt=False
                        ),
                        success_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                condition=lex.CfnBot.ConditionProperty(
                                    expression_string="expressionString"
                                ),
                                name="name",
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                
                                # the properties below are optional
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            )],
                            default_branch=lex.CfnBot.DefaultConditionalBranchProperty(
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        )]
                                    )],
                
                                    # the properties below are optional
                                    allow_interrupt=False
                                )
                            ),
                            is_active=False
                        ),
                        success_next_step=lex.CfnBot.DialogStateProperty(
                            dialog_action=lex.CfnBot.DialogActionProperty(
                                type="type",
                
                                # the properties below are optional
                                slot_to_elicit="slotToElicit",
                                suppress_next_message=False
                            ),
                            intent=lex.CfnBot.IntentOverrideProperty(
                                name="name",
                                slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                    slot_name="slotName",
                                    slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                        shape="shape",
                                        value=lex.CfnBot.SlotValueProperty(
                                            interpreted_value="interpretedValue"
                                        ),
                                        values=[slot_value_override_property_]
                                    )
                                )]
                            ),
                            session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                key="key",
                
                                # the properties below are optional
                                value="value"
                            )]
                        ),
                        success_response=lex.CfnBot.ResponseSpecificationProperty(
                            message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                message=lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                ),
                
                                # the properties below are optional
                                variations=[lex.CfnBot.MessageProperty(
                                    custom_payload=lex.CfnBot.CustomPayloadProperty(
                                        value="value"
                                    ),
                                    image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                        title="title",
                
                                        # the properties below are optional
                                        buttons=[lex.CfnBot.ButtonProperty(
                                            text="text",
                                            value="value"
                                        )],
                                        image_url="imageUrl",
                                        subtitle="subtitle"
                                    ),
                                    plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                        value="value"
                                    ),
                                    ssml_message=lex.CfnBot.SSMLMessageProperty(
                                        value="value"
                                    )
                                )]
                            )],
                
                            # the properties below are optional
                            allow_interrupt=False
                        ),
                        timeout_conditional=lex.CfnBot.ConditionalSpecificationProperty(
                            conditional_branches=[lex.CfnBot.ConditionalBranchProperty(
                                condition=lex.CfnBot.ConditionProperty(
                                    expression_string="expressionString"
                                ),
                                name="name",
                                next_step=lex.CfnBot.DialogStateProperty(
                                    dialog_action=lex.CfnBot.DialogActionProperty(
                                        type="type",
                
                                        # the properties below are optional
                                        slot_to_elicit="slotToElicit",
                                        suppress_next_message=False
                                    ),
                                    intent=lex.CfnBot.IntentOverrideProperty(
                                        name="name",
                                        slots=[lex.CfnBot.SlotValueOverrideMapProperty(
                                            slot_name="slotName",
                                            slot_value_override=lex.CfnBot.SlotValueOverrideProperty(
                                                shape="shape",
                                                value=lex.CfnBot.SlotValueProperty(
                                                    interpreted_value="interpretedValue"
                                                ),
                                                values=[slot_value_override_property_]
                                            )
                                        )]
                                    ),
                                    session_attributes=[lex.CfnBot.SessionAttributeProperty(
                                        key="key",
                
                                        # the properties below are optional
                                        value="value"
                                    )]
                                ),
                
                                # the properties below are optional
                                response=lex.CfnBot.ResponseSpecificationProperty(
                                    message_groups_list=[lex.CfnBot.MessageGroupProperty(
                                        message=lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
                                        ),
                
                                        # the properties below are optional
                                        variations=[lex.CfnBot.MessageProperty(
                                            custom_payload=lex.CfnBot.CustomPayloadProperty(
                                                value="value"
                                            ),
                                            image_response_card=lex.CfnBot.ImageResponseCardProperty(
                                                title="title",
                
                                                # the properties below are optional
                                                buttons=[lex.CfnBot.ButtonProperty(
                                                    text="text",
                                                    value="value"
                                                )],
                                                image_url="imageUrl",
                                                subtitle="subtitle"
                                            ),
                                            plain_text_message=lex.CfnBot.PlainTextMessageProperty(
                                                value="value"
                                            ),
                                            ssml_message=lex.CfnBot.SSMLMessageProperty(
                                                value="value"
                                            )
           