# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-02-08 19:17
from __future__ import unicode_literals

from django.core.management.sql import emit_pre_migrate_signal, emit_post_migrate_signal
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import modelcluster.contrib.taggit
import modelcluster.fields
import molo.core.blocks
import molo.core.models
import taggit.managers
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.core.models
import wagtail.images.blocks
import wagtail.search.index


# Functions from the following migrations need manual copying.
# Move them and any dependencies into this file, then update the
# RunPython operations to refer to the local versions:
# molo.core.migrations.0002_create_homepage
# NOTE: this function is labelled homepage, but creates BannerPage instead.
# This is due to necessary changes when squashing the migrations.
# Instead of creating the HomePage and then renaming it to BannerPage,
# we create the BannerPage immediately and remove migration to
# rename the model.
def create_homepage(apps, schema_editor):
    # Get models
    ContentType = apps.get_model('contenttypes.ContentType')
    Page = apps.get_model('wagtailcore.Page')
    Site = apps.get_model('wagtailcore.Site')
    BannerPage = apps.get_model('core.BannerPage')

    # Delete the default homepage
    Page.objects.get(id=2).delete()

    # Create content type for homepage model
    bannerpage_content_type, created = ContentType.objects.get_or_create(
        model='bannerpage', app_label='core')

    # Create a new bannerpage
    bannerpage = BannerPage.objects.create(
        title="Homepage",
        slug='home',
        content_type=bannerpage_content_type,
        path='00010001',
        depth=2,
        numchild=0,
        url_path='/home/',
    )

    # Create a site with the new bannerpage set as the root
    Site.objects.create(
        hostname='localhost', root_page=bannerpage, is_default_site=True)


# molo.core.migrations.0004_configure_root_page
def configure_root_page(apps, schema_editor):
    # Get models
    ContentType = apps.get_model('contenttypes.ContentType')
    Site = apps.get_model('wagtailcore.Site')
    Main = apps.get_model('core.Main')
    BannerPage = apps.get_model('core.BannerPage')

    # Delete the default homepage
    BannerPage.objects.all().delete()

    # Create content type for main model
    main_content_type, created = ContentType.objects.get_or_create(
        model='main', app_label='core')

    # Create a new homepage
    main = Main.objects.create(
        title="Main",
        slug='main',
        content_type=main_content_type,
        path='00010001',
        depth=2,
        numchild=0,
        url_path='/home/',
    )

    # Create a site with the new homepage set as the root
    Site.objects.all().delete()
    Site.objects.create(
        hostname='localhost', root_page=main, is_default_site=True)


# molo.core.migrations.0034_create_index_pages
def create_banner_index(apps, schema_editor):
    from molo.core.models import BannerIndexPage, Main
    main = Main.objects.first()

    if main:
        banner_index = BannerIndexPage(title='Banners', slug='banners')
        main.add_child(instance=banner_index)
        banner_index.save_revision().publish()


def create_section_index(apps, schema_editor):
    from molo.core.models import SectionIndexPage, Main
    main = Main.objects.all().first()

    if main:
        section_index = SectionIndexPage(title='Sections', slug='sections')
        main.add_child(instance=section_index)
        section_index.save_revision().publish()


def create_footer_index(apps, schema_editor):
    from molo.core.models import FooterIndexPage, Main
    main = Main.objects.all().first()

    if main:
        footer_index = FooterIndexPage(
            title='Footer pages', slug='footer-pages')
        main.add_child(instance=footer_index)
        footer_index.save_revision().publish()


# molo.core.migrations.0047_add_core_permissions_to_groups
def add_core_permissions_to_groups(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    try:
        # Django 1.9
        emit_post_migrate_signal(2, False, db_alias)
    except TypeError:
        # Django < 1.9
        try:
            # Django 1.8
            emit_post_migrate_signal(2, False, 'default', db_alias)
        except TypeError:  # Django < 1.8
            emit_post_migrate_signal([], 2, False, 'default', db_alias)

    Group = apps.get_model('auth.Group')
    Permission = apps.get_model('auth.Permission')
    GroupPagePermission = apps.get_model('wagtailcore.GroupPagePermission')
    BannerIndexPage = apps.get_model('core.BannerIndexPage')
    SectionIndexPage = apps.get_model('core.SectionIndexPage')
    FooterIndexPage = apps.get_model('core.FooterIndexPage')

    if Group.objects.all().filter(name='Writer and Content Loader'):
        Group.objects.get(name='Writer and Content Loader').delete()

    if Group.objects.all().filter(name='Publisher'):
        Group.objects.get(name='Publisher').delete()

    # Create groups
    access_admin = Permission.objects.get(codename='access_admin')

    # <- Wagtail Login Only ->
    wagtail_login_only_group, _created = Group.objects.get_or_create(
        name='Wagtail Login Only')
    wagtail_login_only_group.permissions.add(access_admin)

    # <- Editors ->
    editor_group = Group.objects.get(name='Editors')

    # Remove the existing page permissions
    editor_group.page_permissions.all().delete()

    # Add page permissions
    sections = SectionIndexPage.objects.first()
    GroupPagePermission.objects.get_or_create(
        group=editor_group,
        page=sections,
        permission_type='add',
    )
    GroupPagePermission.objects.get_or_create(
        group=editor_group,
        page=sections,
        permission_type='edit',
    )

    banners = BannerIndexPage.objects.first()
    GroupPagePermission.objects.get_or_create(
        group=editor_group,
        page=banners,
        permission_type='add',
    )
    GroupPagePermission.objects.get_or_create(
        group=editor_group,
        page=banners,
        permission_type='edit',
    )

    add_sitelanguage = Permission.objects.get(codename='add_sitelanguage')
    editor_group.permissions.add(add_sitelanguage)

    # <- Moderator ->

    moderator_group = Group.objects.get(name='Moderators')

    add_sitelanguage = Permission.objects.get(codename='add_sitelanguage')
    change_sitelanguage = Permission.objects.get(
        codename='change_sitelanguage')
    change_user = Permission.objects.get(
        codename='change_user')
    moderator_group.permissions.add(add_sitelanguage, change_sitelanguage,
                                    change_user)

    moderator_group.page_permissions.all().delete()
    sections = SectionIndexPage.objects.first()
    GroupPagePermission.objects.get_or_create(
        group=moderator_group,
        page=sections,
        permission_type='add',
    )
    GroupPagePermission.objects.get_or_create(
        group=moderator_group,
        page=sections,
        permission_type='edit',
    )
    GroupPagePermission.objects.get_or_create(
        group=moderator_group,
        page=sections,
        permission_type='publish',
    )

    banners = BannerIndexPage.objects.first()
    GroupPagePermission.objects.get_or_create(
        group=moderator_group,
        page=banners,
        permission_type='add',
    )
    GroupPagePermission.objects.get_or_create(
        group=moderator_group,
        page=banners,
        permission_type='edit',
    )
    GroupPagePermission.objects.get_or_create(
        group=moderator_group,
        page=banners,
        permission_type='publish',
    )

    footers = FooterIndexPage.objects.first()
    GroupPagePermission.objects.get_or_create(
        group=moderator_group,
        page=footers,
        permission_type='add',
    )
    GroupPagePermission.objects.get_or_create(
        group=moderator_group,
        page=footers,
        permission_type='edit',
    )
    GroupPagePermission.objects.get_or_create(
        group=moderator_group,
        page=footers,
        permission_type='publish',
    )


# molo.core.migrations.0050_data_migration_promoted_articles
def set_promote_start_date(apps, schema_editor):
    ArticlePage = apps.get_model("core", "ArticlePage")

    latest_articles = ArticlePage.objects.filter(featured_in_latest=True)
    homepage_articles = ArticlePage.objects.filter(featured_in_homepage=True)
    section_articles = ArticlePage.objects.filter(featured_in_section=True)

    for article in latest_articles:
        article.featured_in_latest_start_date = article.latest_revision_created_at
        article.save()
    for article in homepage_articles:
        article.featured_in_homepage_start_date = article.latest_revision_created_at
        article.save()
    for article in section_articles:
        article.featured_in_section_start_date = article.latest_revision_created_at
        article.save()


# molo.core.migrations.0051_remove_user_permission_for_moderator_group
def remove_user_permission_for_moderator_group(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    try:
        # Django 1.9
        emit_post_migrate_signal(2, False, db_alias)
    except TypeError:
        # Django < 1.9
        try:
            # Django 1.8
            emit_post_migrate_signal(2, False, 'default', db_alias)
        except TypeError:  # Django < 1.8
            emit_post_migrate_signal([], 2, False, 'default', db_alias)

    Group = apps.get_model('auth.Group')
    Permission = apps.get_model('auth.Permission')

    # <- Moderator ->
    moderator_group = Group.objects.filter(name='Moderators').first()
    if moderator_group:
        change_user = Permission.objects.get(codename='change_user')
        moderator_group.permissions.remove(change_user)


# molo.core.migrations.0052_update_permissions_for_groups
def update_permissions_for_group(apps, schema_editor):
    '''
    Update permissions for some users.

    Give bulk-delete permissions to moderators.
    Give edit permission to moderators and editors in order
    to display 'Main' page in the explorer.
    '''
    db_alias = schema_editor.connection.alias
    try:
        # Django 1.9
        emit_post_migrate_signal(2, False, db_alias)
    except TypeError:
        # Django < 1.9
        try:
            # Django 1.8
            emit_post_migrate_signal(2, False, 'default', db_alias)
        except TypeError:  # Django < 1.8
            emit_post_migrate_signal([], 2, False, 'default', db_alias)

    Group = apps.get_model('auth.Group')
    GroupPagePermission = apps.get_model('wagtailcore.GroupPagePermission')
    SectionIndexPage = apps.get_model('core.SectionIndexPage')
    MainPage = apps.get_model('core.Main')

    moderator_group = Group.objects.filter(name='Moderators').first()
    editor_group = Group.objects.filter(name='Editors').first()

    if moderator_group:
        sections = SectionIndexPage.objects.first()
        GroupPagePermission.objects.get_or_create(
            group_id=moderator_group.id,
            page_id=sections.id,
            permission_type='bulk_delete'
        )

        main = MainPage.objects.first()
        GroupPagePermission.objects.get_or_create(
            group_id=moderator_group.id,
            page_id=main.id,
            permission_type='edit'
        )

    if editor_group:
        main = MainPage.objects.first()
        GroupPagePermission.objects.get_or_create(
            group_id=editor_group.id,
            page_id=main.id,
            permission_type='edit'
        )


# molo.core.migrations.0055_migrate_current_site_languages_to_language_relation
def convert_languages_to_site_language_relation(apps, schema_editor):
    from molo.core.models import SiteLanguage, SiteLanguageRelation, Main, Languages
    main = Main.objects.all().first()
    if main:
        site = main.get_site()
        if site:
            language_setting, _ = Languages.objects.get_or_create(
                site_id=site.pk)
            for language in SiteLanguage.objects.all():
                site_language_rel = SiteLanguageRelation(
                    sitelanguage_ptr=language,
                    language_setting=language_setting,
                    locale=language.locale,
                    is_active=language.is_active,
                    is_main_language=language.is_main_language)
                site_language_rel.save()


# molo.core.migrations.0057_create_tag_index_page
def create_tag_index(apps, schema_editor):
    from molo.core.models import TagIndexPage, Main
    main = Main.objects.all().first()

    if main:
        tag_index = TagIndexPage(title='Tags', slug='tags')
        main.add_child(instance=tag_index)
        tag_index.save_revision().publish()


# molo.core.migrations.0060_reaction_questions_index_page
def create_reaction_question_index(apps, schema_editor):
    from molo.core.models import ReactionQuestionIndexPage, Main
    main = Main.objects.all().first()

    if main:
        reaction_question_index = ReactionQuestionIndexPage(
            title='Reaction Questions', slug='reaction-questions')
        main.add_child(instance=reaction_question_index)
        reaction_question_index.save_revision().publish()


# molo.core.migrations.0068_media_migration
def convert_media_to_molo_media(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    try:
        # Django 1.9
        emit_post_migrate_signal(2, False, db_alias)
    except TypeError:
        # Django < 1.9
        try:
            # Django 1.8
            emit_post_migrate_signal(2, False, 'default', db_alias)
        except TypeError:  # Django < 1.8
            emit_post_migrate_signal([], 2, False, 'default', db_alias)
    from molo.core.models import MoloMedia, ArticlePage
    from wagtailmedia.models import Media

    for media in Media.objects.all():
        if media.type == 'video':
            new_media = MoloMedia.objects.create(
                title=media.title, file=media.file, duration=media.duration,
                type=media.type, width=media.width, height=media.height,
                thumbnail=media.thumbnail)
        else:
            new_media = MoloMedia.objects.create(
                title=media.title, file=media.file, duration=media.duration,
                type=media.type)
        media.file = None
        media.save()
        for article in ArticlePage.objects.all():
            for block in article.body:
                if block.block_type is 'media' and block.value is media.id:
                    block.value = new_media.id
                    article.save()


# molo.core.migrations.0071_remove_old_image_hashes
def delete_imageinfo(apps, schema_editor):
    ImageInfo = apps.get_model('core.ImageInfo')
    ImageInfo.objects.all().delete()


# molo.core.migrations.0073_run_wagtail_migration_before_core_34
def run_wagtail_migration_before_core_34(apps, schema_editor):
    """
    Migration 34 needs migration 0040 from wagtail core
    and this Migration will run wagtail migration before
    molo core migration 34
    """
    db_alias = schema_editor.connection.alias
    emit_pre_migrate_signal(verbosity=2, interactive=False, db=db_alias)


# molo.core.migrations.0075_create_timezone
def seed_timezones(apps, schema_editor):
    from molo.core.models import Timezone
    from pytz import common_timezones
    for timezone_title in common_timezones:
        timezone = Timezone.objects.create(title=timezone_title)
        timezone.save()


def delete_timezones(apps, schema_editor):
    from molo.core.models import Timezone
    Timezone.objects.all().delete()


# molo.core.migrations.0076_create_cmssettings
def set_initial_timezone(apps, schema_editor):
    from django.conf import settings as django_settings
    from molo.core.models import CmsSettings, Timezone
    from wagtail.core.models import Site

    current_timezone_name = django_settings.TIME_ZONE or 'UTC'
    for site in Site.objects.all():
        cms_settings = CmsSettings.for_site(site)
        cms_settings.timezone = Timezone.objects.filter(
            title=current_timezone_name,
        ).first()
        cms_settings.save()


def unset_timezone(apps, schema_editor):
    from molo.core.models import CmsSettings
    from wagtail.core.models import Site
    for site in Site.objects.all():
        site_settings = CmsSettings.for_site(site)
        site_settings.timezone = None
        site_settings.save()


class Migration(migrations.Migration):

    replaces = [
        ('core', '0001_initial'),
        ('core', '0002_create_homepage'),
        ('core', '0003_articlepage_languagepage_main_sectionpage'),
        ('core', '0004_configure_root_page'),
        ('core', '0005_add_nullable_to_articlepage_sectionpage'),
        ('core', '0006_add_help_text_to_language_code'),
        ('core', '0007_articlepage_body'),
        ('core', '0008_articlepage_add_more_blocks'),
        ('core', '0009_sectionpage_image'),
        ('core', '0010_add_banner_to_homepage'),
        ('core', '0011_footerpage'),
        ('core', '0012_add_featured_fields_to_articlepage'),
        ('core', '0013_articlepage_featured_in_homepage'),
        ('core', '0014_sectionpage_extra_style_hints'),
        ('core', '0015_auto_20150925_1037'),
        ('core', '0016_auto_20150925_1226'),
        ('core', '0017_auto_20150925_1232'),
        ('core', '0018_auto_20150925_1554'),
        ('core', '0019_add_tags_to_article'),
        ('core', '0020_add-social-media-fields-to-article-page'),
        ('core', '0021_add-meta-tags-field-to-article-page'),
        ('core', '0022_add_help_text_for_metadata_tags'),
        ('core', '0023_languagepage_main_language'),
        ('core', '0024_add_language_field_to_models'),
        ('core', '0025_add_translation_model'),
        ('core', '0026_add_site_language_model'),
        ('core', '0027_remove_commenting_fields_from_homepage'),
        ('core', '0028_rename_homepage_to_bannerpage'),
        ('core', '0029_add_UUID_filed'),
        ('core', '0030_change_related_name_for_translations'),
        ('core', '0031_sitesettings'),
        ('core', '0032_sitesettings_ga_tag_manager'),
        ('core', '0033_bannerindexpage_footerindexpage_sectionindexpage'),
        ('core', '0034_create_index_pages'),
        ('core', '0035_content_rotation_settings'),
        ('core', '0036_auto_add_related_section_to_article'),
        ('core', '0037_add_article_body_media_field'),
        ('core', '0038_sitesettings_global_ga_tag_manager'),
        ('core', '0039_add_content_rotation_to_SectionPage'),
        ('core', '0040_auto_20160722_1041'),
        ('core', '0041_GA_tracking_code'),
        ('core', '0042_content_rotation_dates_and_times'),
        ('core', '0043_sitesettings_show_only_translated_pages'),
        ('core', '0044_add_topic_of_the_day_fields'),
        ('core', '0045_bannerpage_external_link'),
        ('core', '0046_sitesettings_enable_clickable_tags'),
        ('core', '0047_add_core_permissions_to_groups'),
        ('core', '0048_promotion_dates'),
        ('core', '0049_add_social_media_links_to_site_settings'),
        ('core', '0050_data_migration_promoted_articles'),
        ('core', '0051_remove_user_permission_for_moderator_group'),
        ('core', '0052_update_permissions_for_groups'),
        ('core', '0053_add_next_and_recommended_functionality'),
        ('core', '0054_languages_sitelanguagerelation'),
        ('core', '0055_migrate_current_site_languages_to_language_relation'),
        ('core', '0056_tag_navigation'),
        ('core', '0057_create_tag_index_page'),
        ('core', '0058_section_tags'),
        ('core', '0059_reaction_questions'),
        ('core', '0060_reaction_questions_index_page'),
        ('core', '0061_add_success_fields_to_reaction_choice'),
        ('core', '0062_increase_char_length_reaction_success'),
        ('core', '0063_articlepagelanguageproxy'),
        ('core', '0064_auto_20170802_1410'),
        ('core', '0065_auto_20170807_1005'),
        ('core', '0066_add_custom_media_model'),
        ('core', '0067_promote_homepage_media'),
        ('core', '0068_media_migration'),
        ('core', '0069_add_image_info'),
        ('core', '0070_add_service_directory_api'),
        ('core', '0071_remove_old_image_hashes'),
        ('core', '0072_fb_tracking_id'),
        ('core', '0073_run_wagtail_migration_before_core_34'),
        ('core', '0074_banner_subtitle'),
        ('core', '0075_create_timezone'),
        ('core', '0076_create_cmssettings'),
        ('core', '0077_molo_page')
    ]

    initial = True

    dependencies = [
        ('wagtailcore', '0015_add_more_verbose_names'),
        ('wagtailmedia', '0003_copy_media_permissions_to_collections'),
        ('wagtailimages', '0005_make_filter_spec_unique'),
        ('wagtailcore', '0029_unicode_slugfield_dj19'),
        ('auth', '0007_alter_validators_add_error_messages'),
        ('sites', '0002_alter_domain_unique'),
        ('wagtailimages', '0012_copy_image_permissions_to_collections'),
        ('taggit', '0002_auto_20150616_2121'),
        ('wagtailcore', '0010_change_page_owner_to_null_on_delete'),
        ('contenttypes', '0002_remove_content_type_name'),
        ('wagtailcore', '0028_merge'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('wagtailimages', '0006_add_verbose_names'),
        ('wagtailcore', '0040_page_draft_title'),
        ('taggit', '0001_initial'),
        ('wagtailcore', '0032_add_bulk_delete_page_permission'),
        ('wagtailcore', '0023_alter_page_revision_on_delete_behaviour'),
        ('wagtailusers', '0005_make_related_name_wagtail_specific'),
        ('wagtailimages', '0010_change_on_delete_behaviour'),
        ('wagtailcore', '0024_alter_page_content_type_on_delete_behaviour'),
        ('wagtailadmin', '0001_create_admin_access_permissions'),
        ('wagtailimages', '0018_remove_rendition_filter'),
    ]

    operations = [
        migrations.CreateModel(
            name='BannerPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page',),
        ),
        migrations.RunPython(create_homepage),
        migrations.CreateModel(
            name='ArticlePage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('subtitle', models.TextField()),
                ('image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image')),
            ],
            options={
                'verbose_name': 'Article',
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='LanguagePage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('code', models.CharField(max_length=255)),
            ],
            options={
                'verbose_name': 'Language',
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='Main',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='SectionPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('description', models.TextField()),
            ],
            options={
                'verbose_name': 'Section',
            },
            bases=('wagtailcore.page',),
        ),
        migrations.RunPython(configure_root_page),
        migrations.AlterField(
            model_name='articlepage',
            name='subtitle',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='sectionpage',
            name='description',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='languagepage',
            name='code',
            field=models.CharField(help_text='The language code as specified in iso639-2', max_length=255),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='body',
            field=wagtail.core.fields.StreamField(((b'heading', wagtail.core.blocks.CharBlock(classname=b'full title')), (b'paragraph', molo.core.blocks.MarkDownBlock()), (b'image', wagtail.images.blocks.ImageChooserBlock()), (b'list', wagtail.core.blocks.ListBlock(wagtail.core.blocks.CharBlock(label=b'Item'))), (b'numbered_list', wagtail.core.blocks.ListBlock(wagtail.core.blocks.CharBlock(label=b'Item'))), (b'page', wagtail.core.blocks.PageChooserBlock())), blank=True, null=True),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='image',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image'),
        ),
        migrations.AddField(
            model_name='bannerpage',
            name='banner',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image'),
        ),
        migrations.AddField(
            model_name='bannerpage',
            name='banner_link_page',
            field=models.ForeignKey(blank=True, help_text='Optional page to which the banner will link to', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page'),
        ),
        migrations.CreateModel(
            name='FooterPage',
            fields=[
                ('articlepage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.ArticlePage')),
            ],
            options={
                'abstract': False,
            },
            bases=('core.articlepage',),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='featured_in_latest',
            field=models.BooleanField(default=False, help_text='Article to be featured in the Latest module'),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='featured_in_section',
            field=models.BooleanField(default=False, help_text='Article to be featured in the Section module'),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='featured_in_homepage',
            field=models.BooleanField(default=False, help_text='Article to be featured in the Homepage within the Section module'),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='extra_style_hints',
            field=models.TextField(blank=True, default=b'', help_text='Styling options that can be applied to this section and all its descendants', null=True),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='commenting_state',
            field=models.CharField(blank=True, choices=[(b'O', b'Open'), (b'C', b'Closed'), (b'D', b'Disabled'), (b'T', b'Timestamped')], max_length=1, null=True),
        ),
        migrations.AddField(
            model_name='languagepage',
            name='commenting_state',
            field=models.CharField(blank=True, choices=[(b'O', b'Open'), (b'C', b'Closed'), (b'D', b'Disabled'), (b'T', b'Timestamped')], max_length=1, null=True),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='commenting_state',
            field=models.CharField(blank=True, choices=[(b'O', b'Open'), (b'C', b'Closed'), (b'D', b'Disabled'), (b'T', b'Timestamped')], max_length=1, null=True),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='commenting_close_time',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='commenting_open_time',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='languagepage',
            name='commenting_close_time',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='languagepage',
            name='commenting_open_time',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='commenting_close_time',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='commenting_open_time',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.CreateModel(
            name='ArticlePageTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content_object', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='tagged_items', to='core.ArticlePage')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='core_articlepagetag_items', to='taggit.Tag')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='articlepage',
            name='tags',
            field=modelcluster.contrib.taggit.ClusterTaggableManager(blank=True, help_text='A comma-separated list of tags.', through='core.ArticlePageTag', to='taggit.Tag', verbose_name='Tags'),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='social_media_description',
            field=models.TextField(blank=True, null=True, verbose_name=b'description'),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='social_media_image',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name=b'Image'),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='social_media_title',
            field=models.TextField(blank=True, null=True, verbose_name=b'title'),
        ),
        migrations.CreateModel(
            name='ArticlePageMetaDataTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content_object', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='metadata_tagged_items', to='core.ArticlePage')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='core_articlepagemetadatatag_items', to='taggit.Tag')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='articlepage',
            name='metadata_tags',
            field=modelcluster.contrib.taggit.ClusterTaggableManager(blank=True, help_text='A comma-separated list of tags. This is not visible to the user.', through='core.ArticlePageMetaDataTag', to='taggit.Tag', verbose_name='Tags'),
        ),
        migrations.CreateModel(
            name='PageTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='wagtailcore.Page')),
                ('translated_page', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='source_page', to='wagtailcore.Page')),
            ],
        ),
        migrations.CreateModel(
            name='LanguageRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='SiteLanguage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('locale', models.CharField(choices=[(b'af', b'Afrikaans'), (b'ar', b'Arabic'), (b'ast', b'Asturian'), (b'az', b'Azerbaijani'), (b'bg', b'Bulgarian'), (b'be', b'Belarusian'), (b'bn', b'Bengali'), (b'br', b'Breton'), (b'bs', b'Bosnian'), (b'ca', b'Catalan'), (b'cs', b'Czech'), (b'cy', b'Welsh'), (b'da', b'Danish'), (b'de', b'German'), (b'el', b'Greek'), (b'en', b'English'), (b'en-au', b'Australian English'), (b'en-gb', b'British English'), (b'eo', b'Esperanto'), (b'es', b'Spanish'), (b'es-ar', b'Argentinian Spanish'), (b'es-mx', b'Mexican Spanish'), (b'es-ni', b'Nicaraguan Spanish'), (b'es-ve', b'Venezuelan Spanish'), (b'et', b'Estonian'), (b'eu', b'Basque'), (b'fa', b'Persian'), (b'fi', b'Finnish'), (b'fr', b'French'), (b'fy', b'Frisian'), (b'ga', b'Irish'), (b'gl', b'Galician'), (b'he', b'Hebrew'), (b'hi', b'Hindi'), (b'hr', b'Croatian'), (b'hu', b'Hungarian'), (b'ia', b'Interlingua'), (b'id', b'Indonesian'), (b'io', b'Ido'), (b'is', b'Icelandic'), (b'it', b'Italian'), (b'ja', b'Japanese'), (b'ka', b'Georgian'), (b'kk', b'Kazakh'), (b'km', b'Khmer'), (b'kn', b'Kannada'), (b'ko', b'Korean'), (b'lb', b'Luxembourgish'), (b'lt', b'Lithuanian'), (b'lv', b'Latvian'), (b'mk', b'Macedonian'), (b'ml', b'Malayalam'), (b'mn', b'Mongolian'), (b'mr', b'Marathi'), (b'my', b'Burmese'), (b'nb', b'Norwegian Bokmal'), (b'ne', b'Nepali'), (b'nl', b'Dutch'), (b'nn', b'Norwegian Nynorsk'), (b'os', b'Ossetic'), (b'pa', b'Punjabi'), (b'pl', b'Polish'), (b'pt', b'Portuguese'), (b'pt-br', b'Brazilian Portuguese'), (b'ro', b'Romanian'), (b'ru', b'Russian'), (b'sk', b'Slovak'), (b'sl', b'Slovenian'), (b'sq', b'Albanian'), (b'sr', b'Serbian'), (b'sr-latn', b'Serbian Latin'), (b'sv', b'Swedish'), (b'sw', b'Swahili'), (b'ta', b'Tamil'), (b'te', b'Telugu'), (b'th', b'Thai'), (b'tr', b'Turkish'), (b'tt', b'Tatar'), (b'udm', b'Udmurt'), (b'uk', b'Ukrainian'), (b'ur', b'Urdu'), (b'vi', b'Vietnamese'), (b'zh-cn', b'Simplified Chinese'), (b'zh-hans', b'Simplified Chinese'), (b'zh-hant', b'Traditional Chinese'), (b'zh-tw', b'Traditional Chinese'), (b'zu', 'Zulu'), (b'xh', 'Xhosa'), (b'st', 'Sotho'), (b've', 'Venda'), (b'tn', 'Tswana'), (b'ts', 'Tsonga'), (b'ss', 'Swati'), (b'nr', 'Ndebele')], help_text='Site language', max_length=255, verbose_name='language name')),
                ('is_main_language', models.BooleanField(default=False, editable=False, verbose_name='main Language')),
                ('is_active', models.BooleanField(default=True, verbose_name='active Language')),
            ],
            options={
                'verbose_name': 'Language',
            },
        ),
        migrations.AddField(
            model_name='languagerelation',
            name='language',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.SiteLanguage'),
        ),
        migrations.AddField(
            model_name='languagerelation',
            name='page',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='languages', to='wagtailcore.Page'),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='uuid',
            field=models.CharField(blank=True, max_length=32, null=True),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='uuid',
            field=models.CharField(blank=True, max_length=32, null=True),
        ),
        migrations.CreateModel(
            name='SiteSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('logo', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
                ('ga_tag_manager', models.CharField(blank=True, help_text='GA Tag Manager tracking code (e.g GTM-XXX)', max_length=255, null=True, verbose_name='GA Tag Manager')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BannerIndexPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='FooterIndexPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='SectionIndexPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('commenting_state', models.CharField(blank=True, choices=[(b'O', b'Open'), (b'C', b'Closed'), (b'D', b'Disabled'), (b'T', b'Timestamped')], default=b'O', max_length=1, null=True)),
                ('commenting_open_time', models.DateTimeField(blank=True, null=True)),
                ('commenting_close_time', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
            bases=(molo.core.models.CommentedPageMixin, 'wagtailcore.page'),
        ),
        migrations.RunPython(create_banner_index),
        migrations.RunPython(create_section_index),
        migrations.RunPython(create_footer_index),
        migrations.CreateModel(
            name='ArticlePageRelatedSections',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('page', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='related_sections', to='core.ArticlePage')),
                ('section', models.ForeignKey(blank=True, help_text='Section that this page also belongs too', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.AlterField(
            model_name='sitelanguage',
            name='locale',
            field=models.CharField(choices=[(b'af', b'Afrikaans'), (b'ar', b'Arabic'), (b'ast', b'Asturian'), (b'az', b'Azerbaijani'), (b'bg', b'Bulgarian'), (b'be', b'Belarusian'), (b'bn', b'Bengali'), (b'br', b'Breton'), (b'bs', b'Bosnian'), (b'ca', b'Catalan'), (b'cs', b'Czech'), (b'cy', b'Welsh'), (b'da', b'Danish'), (b'de', b'German'), (b'el', b'Greek'), (b'en', b'English'), (b'en-au', b'Australian English'), (b'en-gb', b'British English'), (b'eo', b'Esperanto'), (b'es', b'Spanish'), (b'es-ar', b'Argentinian Spanish'), (b'es-co', b'Colombian Spanish'), (b'es-mx', b'Mexican Spanish'), (b'es-ni', b'Nicaraguan Spanish'), (b'es-ve', b'Venezuelan Spanish'), (b'et', b'Estonian'), (b'eu', b'Basque'), (b'fa', b'Persian'), (b'fi', b'Finnish'), (b'fr', b'French'), (b'fy', b'Frisian'), (b'ga', b'Irish'), (b'gd', b'Scottish Gaelic'), (b'gl', b'Galician'), (b'he', b'Hebrew'), (b'hi', b'Hindi'), (b'hr', b'Croatian'), (b'hu', b'Hungarian'), (b'ia', b'Interlingua'), (b'id', b'Indonesian'), (b'io', b'Ido'), (b'is', b'Icelandic'), (b'it', b'Italian'), (b'ja', b'Japanese'), (b'ka', b'Georgian'), (b'kk', b'Kazakh'), (b'km', b'Khmer'), (b'kn', b'Kannada'), (b'ko', b'Korean'), (b'lb', b'Luxembourgish'), (b'lt', b'Lithuanian'), (b'lv', b'Latvian'), (b'mk', b'Macedonian'), (b'ml', b'Malayalam'), (b'mn', b'Mongolian'), (b'mr', b'Marathi'), (b'my', b'Burmese'), (b'nb', b'Norwegian Bokmal'), (b'ne', b'Nepali'), (b'nl', b'Dutch'), (b'nn', b'Norwegian Nynorsk'), (b'os', b'Ossetic'), (b'pa', b'Punjabi'), (b'pl', b'Polish'), (b'pt', b'Portuguese'), (b'pt-br', b'Brazilian Portuguese'), (b'ro', b'Romanian'), (b'ru', b'Russian'), (b'sk', b'Slovak'), (b'sl', b'Slovenian'), (b'sq', b'Albanian'), (b'sr', b'Serbian'), (b'sr-latn', b'Serbian Latin'), (b'sv', b'Swedish'), (b'sw', b'Swahili'), (b'ta', b'Tamil'), (b'te', b'Telugu'), (b'th', b'Thai'), (b'tr', b'Turkish'), (b'tt', b'Tatar'), (b'udm', b'Udmurt'), (b'uk', b'Ukrainian'), (b'ur', b'Urdu'), (b'vi', b'Vietnamese'), (b'zh-hans', b'Simplified Chinese'), (b'zh-hant', b'Traditional Chinese'), (b'zu', 'Zulu'), (b'xh', 'Xhosa'), (b'st', 'Sotho'), (b've', 'Venda'), (b'tn', 'Tswana'), (b'ts', 'Tsonga'), (b'ss', 'Swati'), (b'nr', 'Ndebele')], help_text='Site language', max_length=255, verbose_name='language name'),
        ),
        migrations.AlterField(
            model_name='articlepage',
            name='body',
            field=wagtail.core.fields.StreamField(((b'heading', wagtail.core.blocks.CharBlock(classname=b'full title')), (b'paragraph', molo.core.blocks.MarkDownBlock()), (b'image', wagtail.images.blocks.ImageChooserBlock()), (b'list', wagtail.core.blocks.ListBlock(wagtail.core.blocks.CharBlock(label=b'Item'))), (b'numbered_list', wagtail.core.blocks.ListBlock(wagtail.core.blocks.CharBlock(label=b'Item'))), (b'page', wagtail.core.blocks.PageChooserBlock()), (b'media', molo.core.blocks.MultimediaBlock())), blank=True, null=True),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='global_ga_tag_manager',
            field=models.CharField(blank=True, help_text='Global GA Tag Manager tracking code (e.g GTM-XXX) to be used to view analytics on more than one site globally', max_length=255, null=True, verbose_name='Global GA Tag Manager'),
        ),
        migrations.AlterField(
            model_name='sitesettings',
            name='ga_tag_manager',
            field=models.CharField(blank=True, help_text='Local GA Tag Manager tracking code (e.g GTM-XXX) to be used to view analytics on this site only', max_length=255, null=True, verbose_name='Local GA Tag Manager'),
        ),
        migrations.AlterField(
            model_name='sitelanguage',
            name='locale',
            field=models.CharField(choices=[(b'af', b'Afrikaans'), (b'ar', b'Arabic'), (b'ast', b'Asturian'), (b'az', b'Azerbaijani'), (b'bg', b'Bulgarian'), (b'be', b'Belarusian'), (b'bn', b'Bengali'), (b'br', b'Breton'), (b'bs', b'Bosnian'), (b'ca', b'Catalan'), (b'cs', b'Czech'), (b'cy', b'Welsh'), (b'da', b'Danish'), (b'de', b'German'), (b'el', b'Greek'), (b'en', b'English'), (b'en-au', b'Australian English'), (b'en-gb', b'British English'), (b'eo', b'Esperanto'), (b'es', b'Spanish'), (b'es-ar', b'Argentinian Spanish'), (b'es-co', b'Colombian Spanish'), (b'es-mx', b'Mexican Spanish'), (b'es-ni', b'Nicaraguan Spanish'), (b'es-ve', b'Venezuelan Spanish'), (b'et', b'Estonian'), (b'eu', b'Basque'), (b'fa', b'Persian'), (b'fi', b'Finnish'), (b'fr', b'French'), (b'fy', b'Frisian'), (b'ga', b'Irish'), (b'gd', b'Scottish Gaelic'), (b'gl', b'Galician'), (b'he', b'Hebrew'), (b'hi', b'Hindi'), (b'hr', b'Croatian'), (b'hu', b'Hungarian'), (b'ia', b'Interlingua'), (b'id', b'Indonesian'), (b'io', b'Ido'), (b'is', b'Icelandic'), (b'it', b'Italian'), (b'ja', b'Japanese'), (b'ka', b'Georgian'), (b'kk', b'Kazakh'), (b'km', b'Khmer'), (b'kn', b'Kannada'), (b'ko', b'Korean'), (b'lb', b'Luxembourgish'), (b'lt', b'Lithuanian'), (b'lv', b'Latvian'), (b'mk', b'Macedonian'), (b'ml', b'Malayalam'), (b'mn', b'Mongolian'), (b'mr', b'Marathi'), (b'my', b'Burmese'), (b'nb', b'Norwegian Bokmal'), (b'ne', b'Nepali'), (b'nl', b'Dutch'), (b'nn', b'Norwegian Nynorsk'), (b'os', b'Ossetic'), (b'pa', b'Punjabi'), (b'pl', b'Polish'), (b'pt', b'Portuguese'), (b'pt-br', b'Brazilian Portuguese'), (b'ro', b'Romanian'), (b'ru', b'Russian'), (b'sk', b'Slovak'), (b'sl', b'Slovenian'), (b'sq', b'Albanian'), (b'sr', b'Serbian'), (b'sr-latn', b'Serbian Latin'), (b'sv', b'Swedish'), (b'sw', b'Swahili'), (b'ta', b'Tamil'), (b'te', b'Telugu'), (b'th', b'Thai'), (b'tr', b'Turkish'), (b'tt', b'Tatar'), (b'udm', b'Udmurt'), (b'uk', b'Ukrainian'), (b'ur', b'Urdu'), (b'vi', b'Vietnamese'), (b'zh-hans', b'Simplified Chinese'), (b'zh-hant', b'Traditional Chinese'), (b'tl', 'Tagalog'), (b'rw', 'Kinyarwanda'), (b'ha', 'Hausa')], help_text='Site language', max_length=255, verbose_name='language name'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='global_ga_tracking_code',
            field=models.CharField(blank=True, help_text='Global GA tracking code to be used to view analytics on more than one site globally', max_length=255, null=True, verbose_name='Global GA Tracking Code'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='local_ga_tracking_code',
            field=models.CharField(blank=True, help_text='Local GA tracking code to be used to view analytics on this site only', max_length=255, null=True, verbose_name='Local GA Tracking Code'),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='content_rotation_end_date',
            field=models.DateTimeField(blank=True, help_text=b'The date rotation will end', null=True),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='content_rotation_start_date',
            field=models.DateTimeField(blank=True, help_text=b'The date rotation will begin', null=True),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='friday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Friday'),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='monday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Monday'),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='saturday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Saturday'),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='sunday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Sunday'),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='thursday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Thursday'),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='time',
            field=wagtail.core.fields.StreamField(((b'time', wagtail.core.blocks.TimeBlock(required=False)),), blank=True, help_text=b'The time/s content will be rotated', null=True),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='tuesday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Tuesday'),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='wednesday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Wednesday'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='content_rotation_end_date',
            field=models.DateTimeField(blank=True, help_text=b'The date rotation will end', null=True),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='content_rotation_start_date',
            field=models.DateTimeField(blank=True, help_text=b'The date rotation will begin', null=True),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='friday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Friday'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='monday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Monday'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='saturday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Saturday'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='sunday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Sunday'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='thursday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Thursday'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='time',
            field=wagtail.core.fields.StreamField(((b'time', wagtail.core.blocks.TimeBlock(required=False)),), blank=True, help_text=b'The time/s content will be rotated', null=True),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='tuesday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Tuesday'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='wednesday_rotation',
            field=models.BooleanField(default=False, verbose_name=b'Wednesday'),
        ),
        migrations.AlterField(
            model_name='sitelanguage',
            name='locale',
            field=models.CharField(choices=[(b'af', b'Afrikaans'), (b'ar', b'Arabic'), (b'ast', b'Asturian'), (b'az', b'Azerbaijani'), (b'bg', b'Bulgarian'), (b'be', b'Belarusian'), (b'bn', b'Bengali'), (b'br', b'Breton'), (b'bs', b'Bosnian'), (b'ca', b'Catalan'), (b'cs', b'Czech'), (b'cy', b'Welsh'), (b'da', b'Danish'), (b'de', b'German'), (b'el', b'Greek'), (b'en', b'English'), (b'en-au', b'Australian English'), (b'en-gb', b'British English'), (b'eo', b'Esperanto'), (b'es', b'Spanish'), (b'es-ar', b'Argentinian Spanish'), (b'es-co', b'Colombian Spanish'), (b'es-mx', b'Mexican Spanish'), (b'es-ni', b'Nicaraguan Spanish'), (b'es-ve', b'Venezuelan Spanish'), (b'et', b'Estonian'), (b'eu', b'Basque'), (b'fa', b'Persian'), (b'fi', b'Finnish'), (b'fr', b'French'), (b'fy', b'Frisian'), (b'ga', b'Irish'), (b'gd', b'Scottish Gaelic'), (b'gl', b'Galician'), (b'he', b'Hebrew'), (b'hi', b'Hindi'), (b'hr', b'Croatian'), (b'hu', b'Hungarian'), (b'ia', b'Interlingua'), (b'id', b'Indonesian'), (b'io', b'Ido'), (b'is', b'Icelandic'), (b'it', b'Italian'), (b'ja', b'Japanese'), (b'ka', b'Georgian'), (b'kk', b'Kazakh'), (b'km', b'Khmer'), (b'kn', b'Kannada'), (b'ko', b'Korean'), (b'lb', b'Luxembourgish'), (b'lt', b'Lithuanian'), (b'lv', b'Latvian'), (b'mk', b'Macedonian'), (b'ml', b'Malayalam'), (b'mn', b'Mongolian'), (b'mr', b'Marathi'), (b'my', b'Burmese'), (b'nb', b'Norwegian Bokmal'), (b'ne', b'Nepali'), (b'nl', b'Dutch'), (b'nn', b'Norwegian Nynorsk'), (b'os', b'Ossetic'), (b'pa', b'Punjabi'), (b'pl', b'Polish'), (b'pt', b'Portuguese'), (b'pt-br', b'Brazilian Portuguese'), (b'ro', b'Romanian'), (b'ru', b'Russian'), (b'sk', b'Slovak'), (b'sl', b'Slovenian'), (b'sq', b'Albanian'), (b'sr', b'Serbian'), (b'sr-latn', b'Serbian Latin'), (b'sv', b'Swedish'), (b'sw', b'Swahili'), (b'ta', b'Tamil'), (b'te', b'Telugu'), (b'th', b'Thai'), (b'tr', b'Turkish'), (b'tt', b'Tatar'), (b'udm', b'Udmurt'), (b'uk', b'Ukrainian'), (b'ur', b'Urdu'), (b'vi', b'Vietnamese'), (b'zh-hans', b'Simplified Chinese'), (b'zh-hant', b'Traditional Chinese'), (b'zu', 'Zulu'), (b'xh', 'Xhosa'), (b'st', 'Sotho'), (b've', 'Venda'), (b'tn', 'Tswana'), (b'ts', 'Tsonga'), (b'ss', 'Swati'), (b'nr', 'Ndebele')], help_text='Site language', max_length=255, verbose_name='language name'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='show_only_translated_pages',
            field=models.BooleanField(default=False, help_text=b'When selecting this option, untranslated pages will not be visible to the front end user when they viewing a child language of the site'),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='demote_date',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='feature_as_topic_of_the_day',
            field=models.BooleanField(default=False, help_text='Article to be featured as the Topic of the Day'),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='promote_date',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='bannerpage',
            name='external_link',
            field=models.TextField(blank=True, help_text=b'External link which a banner will link to. eg https://www.google.co.za/', null=True),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='enable_clickable_tags',
            field=models.BooleanField(default=False, verbose_name=b'Display tags on Front-end'),
        ),
        migrations.RunPython(add_core_permissions_to_groups),
        migrations.AddField(
            model_name='articlepage',
            name='featured_in_homepage_end_date',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='featured_in_homepage_start_date',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='featured_in_latest_end_date',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='featured_in_latest_start_date',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='featured_in_section_end_date',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='articlepage',
            name='featured_in_section_start_date',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='facebook_image',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='facebook_sharing',
            field=models.BooleanField(default=False, help_text=b'Enable this field to allow for sharing to Facebook.', verbose_name=b'Facebook'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='social_media_links_on_footer_page',
            field=wagtail.core.fields.StreamField(((b'social_media_site', wagtail.core.blocks.StructBlock(((b'title', wagtail.core.blocks.CharBlock(required=True)), (b'link', wagtail.core.blocks.CharBlock(required=True)), (b'image', wagtail.images.blocks.ImageChooserBlock())))),), blank=True, null=True),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='twitter_image',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='twitter_sharing',
            field=models.BooleanField(default=False, help_text=b'Enable this field to allow for sharing to Twitter.', verbose_name=b'Twitter'),
        ),
        migrations.RunPython(set_promote_start_date),
        migrations.RunPython(remove_user_permission_for_moderator_group),
        migrations.RunPython(update_permissions_for_group),
        migrations.CreateModel(
            name='ArticlePageRecommendedSections',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('page', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='recommended_articles', to='core.ArticlePage')),
                ('recommended_article', models.ForeignKey(blank=True, help_text='Recommended articles for this article', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='enable_next_section',
            field=models.BooleanField(default=False, help_text=b"Activate up next section underneath articles in this section will appear with the heading and subheading of that article. The text will say 'next' in order to make the user feel like it's fresh content.", verbose_name=b'Activate up next section underneath articles'),
        ),
        migrations.AddField(
            model_name='sectionpage',
            name='enable_recommended_section',
            field=models.BooleanField(default=False, help_text=b"Underneath the area for 'next articles' recommended articles will appear, with the image + heading + subheading", verbose_name=b'Activate recommended section underneath articles'),
        ),
        migrations.CreateModel(
            name='Languages',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SiteLanguageRelation',
            fields=[
                ('sitelanguage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.SiteLanguage')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('language_setting', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='languages', to='core.Languages')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
            bases=('core.sitelanguage', models.Model),
        ),
        migrations.RunPython(convert_languages_to_site_language_relation),
        migrations.CreateModel(
            name='ArticlePageTags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('page', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='nav_tags', to='core.ArticlePage')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('feature_in_homepage', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
            bases=(molo.core.models.TranslatablePageMixin, 'wagtailcore.page'),
        ),
        migrations.CreateModel(
            name='TagIndexPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page', molo.core.models.PreventDeleteMixin),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='enable_tag_navigation',
            field=models.BooleanField(default=False, help_text=b'Enable tag navigation. When this is true, the clickable tag functionality will be overriden'),
        ),
        migrations.AddField(
            model_name='articlepagetags',
            name='tag',
            field=models.ForeignKey(blank=True, help_text='Tags for tag navigation', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page'),
        ),
        migrations.RunPython(create_tag_index),
        migrations.CreateModel(
            name='SectionPageTags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('page', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='section_tags', to='core.SectionPage')),
                ('tag', models.ForeignKey(blank=True, help_text='Tags for tag navigation', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ArticlePageReactionQuestions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('page', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='reaction_questions', to='core.ArticlePage')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ReactionQuestion',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
            ],
            options={
                'abstract': False,
            },
            bases=(molo.core.models.TranslatablePageMixin, 'wagtailcore.page'),
        ),
        migrations.CreateModel(
            name='ReactionQuestionChoice',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image')),
            ],
            options={
                'abstract': False,
            },
            bases=(molo.core.models.TranslatablePageMixinNotRoutable, 'wagtailcore.page'),
        ),
        migrations.CreateModel(
            name='ReactionQuestionIndexPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page', molo.core.models.PreventDeleteMixin),
        ),
        migrations.CreateModel(
            name='ReactionQuestionResponse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('article', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.ArticlePage')),
                ('choice', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.ReactionQuestionChoice')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.ReactionQuestion')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='articlepagereactionquestions',
            name='reaction_question',
            field=models.ForeignKey(blank=True, help_text='Reaction Questions', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page'),
        ),
        migrations.RunPython(create_reaction_question_index),
        migrations.AddField(
            model_name='reactionquestionchoice',
            name='success_image',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image'),
        ),
        migrations.AddField(
            model_name='reactionquestionchoice',
            name='success_message',
            field=models.CharField(blank=True, max_length=1000, null=True),
        ),
        migrations.CreateModel(
            name='ArticlePageLanguageProxy',
            fields=[
            ],
            options={
                'verbose_name': 'Article View',
                'proxy': True,
                'verbose_name_plural': 'Article View',
            },
            bases=('core.articlepage',),
        ),
        migrations.AlterField(
            model_name='sitelanguage',
            name='locale',
            field=models.CharField(choices=[(b'af', b'Afrikaans'), (b'ar', b'Arabic'), (b'ast', b'Asturian'), (b'az', b'Azerbaijani'), (b'bg', b'Bulgarian'), (b'be', b'Belarusian'), (b'bn', b'Bengali'), (b'br', b'Breton'), (b'bs', b'Bosnian'), (b'ca', b'Catalan'), (b'cs', b'Czech'), (b'cy', b'Welsh'), (b'da', b'Danish'), (b'de', b'German'), (b'el', b'Greek'), (b'en', b'English'), (b'en-au', b'Australian English'), (b'en-gb', b'British English'), (b'eo', b'Esperanto'), (b'es', b'Spanish'), (b'es-ar', b'Argentinian Spanish'), (b'es-co', b'Colombian Spanish'), (b'es-mx', b'Mexican Spanish'), (b'es-ni', b'Nicaraguan Spanish'), (b'es-ve', b'Venezuelan Spanish'), (b'et', b'Estonian'), (b'eu', b'Basque'), (b'fa', b'Persian'), (b'fi', b'Finnish'), (b'fr', b'French'), (b'fy', b'Frisian'), (b'ga', b'Irish'), (b'gd', b'Scottish Gaelic'), (b'gl', b'Galician'), (b'he', b'Hebrew'), (b'hi', b'Hindi'), (b'hr', b'Croatian'), (b'hu', b'Hungarian'), (b'ia', b'Interlingua'), (b'id', b'Indonesian'), (b'io', b'Ido'), (b'is', b'Icelandic'), (b'it', b'Italian'), (b'ja', b'Japanese'), (b'ka', b'Georgian'), (b'kk', b'Kazakh'), (b'km', b'Khmer'), (b'kn', b'Kannada'), (b'ko', b'Korean'), (b'lb', b'Luxembourgish'), (b'lt', b'Lithuanian'), (b'lv', b'Latvian'), (b'mk', b'Macedonian'), (b'ml', b'Malayalam'), (b'mn', b'Mongolian'), (b'mr', b'Marathi'), (b'my', b'Burmese'), (b'nb', b'Norwegian Bokmal'), (b'ne', b'Nepali'), (b'nl', b'Dutch'), (b'nn', b'Norwegian Nynorsk'), (b'os', b'Ossetic'), (b'pa', b'Punjabi'), (b'pl', b'Polish'), (b'pt', b'Portuguese'), (b'pt-br', b'Brazilian Portuguese'), (b'ro', b'Romanian'), (b'ru', b'Russian'), (b'sk', b'Slovak'), (b'sl', b'Slovenian'), (b'sq', b'Albanian'), (b'sr', b'Serbian'), (b'sr-latn', b'Serbian Latin'), (b'sv', b'Swedish'), (b'sw', b'Swahili'), (b'ta', b'Tamil'), (b'te', b'Telugu'), (b'th', b'Thai'), (b'tr', b'Turkish'), (b'tt', b'Tatar'), (b'udm', b'Udmurt'), (b'uk', b'Ukrainian'), (b'ur', b'Urdu'), (b'vi', b'Vietnamese'), (b'zh-hans', b'Simplified Chinese'), (b'zh-hant', b'Traditional Chinese'), (b'zu', 'Zulu'), (b'xh', 'Xhosa'), (b'st', 'Sotho'), (b've', 'Venda'), (b'tn', 'Tswana'), (b'ts', 'Tsonga'), (b'ss', 'Swati'), (b'nr', 'Ndebele'), (b'bem', 'Bemba'), (b'nya', 'Nyanja'), (b'ny', 'Chichewa')], help_text='Site language', max_length=255, verbose_name='language name'),
        ),
        migrations.AlterField(
            model_name='sitelanguage',
            name='locale',
            field=models.CharField(choices=[(b'af', b'Afrikaans'), (b'ar', b'Arabic'), (b'ast', b'Asturian'), (b'az', b'Azerbaijani'), (b'bg', b'Bulgarian'), (b'be', b'Belarusian'), (b'bn', b'Bengali'), (b'br', b'Breton'), (b'bs', b'Bosnian'), (b'ca', b'Catalan'), (b'cs', b'Czech'), (b'cy', b'Welsh'), (b'da', b'Danish'), (b'de', b'German'), (b'el', b'Greek'), (b'en', b'English'), (b'en-au', b'Australian English'), (b'en-gb', b'British English'), (b'eo', b'Esperanto'), (b'es', b'Spanish'), (b'es-ar', b'Argentinian Spanish'), (b'es-co', b'Colombian Spanish'), (b'es-mx', b'Mexican Spanish'), (b'es-ni', b'Nicaraguan Spanish'), (b'es-ve', b'Venezuelan Spanish'), (b'et', b'Estonian'), (b'eu', b'Basque'), (b'fa', b'Persian'), (b'fi', b'Finnish'), (b'fr', b'French'), (b'fy', b'Frisian'), (b'ga', b'Irish'), (b'gd', b'Scottish Gaelic'), (b'gl', b'Galician'), (b'he', b'Hebrew'), (b'hi', b'Hindi'), (b'hr', b'Croatian'), (b'hu', b'Hungarian'), (b'ia', b'Interlingua'), (b'id', b'Indonesian'), (b'io', b'Ido'), (b'is', b'Icelandic'), (b'it', b'Italian'), (b'ja', b'Japanese'), (b'ka', b'Georgian'), (b'kk', b'Kazakh'), (b'km', b'Khmer'), (b'kn', b'Kannada'), (b'ko', b'Korean'), (b'lb', b'Luxembourgish'), (b'lt', b'Lithuanian'), (b'lv', b'Latvian'), (b'mk', b'Macedonian'), (b'ml', b'Malayalam'), (b'mn', b'Mongolian'), (b'mr', b'Marathi'), (b'my', b'Burmese'), (b'nb', b'Norwegian Bokmal'), (b'ne', b'Nepali'), (b'nl', b'Dutch'), (b'nn', b'Norwegian Nynorsk'), (b'os', b'Ossetic'), (b'pa', b'Punjabi'), (b'pl', b'Polish'), (b'pt', b'Portuguese'), (b'pt-br', b'Brazilian Portuguese'), (b'ro', b'Romanian'), (b'ru', b'Russian'), (b'sk', b'Slovak'), (b'sl', b'Slovenian'), (b'sq', b'Albanian'), (b'sr', b'Serbian'), (b'sr-latn', b'Serbian Latin'), (b'sv', b'Swedish'), (b'sw', b'Swahili'), (b'ta', b'Tamil'), (b'te', b'Telugu'), (b'th', b'Thai'), (b'tr', b'Turkish'), (b'tt', b'Tatar'), (b'udm', b'Udmurt'), (b'uk', b'Ukrainian'), (b'ur', b'Urdu'), (b'vi', b'Vietnamese'), (b'zh-hans', b'Simplified Chinese'), (b'zh-hant', b'Traditional Chinese'), (b'zu', 'Zulu'), (b'xh', 'Xhosa'), (b'st', 'Sotho'), (b've', 'Venda'), (b'tn', 'Tswana'), (b'ts', 'Tsonga'), (b'ss', 'Swati'), (b'nr', 'Ndebele')], help_text='Site language', max_length=255, verbose_name='language name'),
        ),
        migrations.CreateModel(
            name='MoloMedia',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('file', models.FileField(upload_to='media', verbose_name='file')),
                ('type', models.CharField(choices=[('audio', 'Audio file'), ('video', 'Video file')], max_length=255)),
                ('duration', models.PositiveIntegerField(help_text='Duration in seconds', verbose_name='duration')),
                ('width', models.PositiveIntegerField(blank=True, null=True, verbose_name='width')),
                ('height', models.PositiveIntegerField(blank=True, null=True, verbose_name='height')),
                ('thumbnail', models.FileField(blank=True, upload_to='media_thumbnails', verbose_name='thumbnail')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('youtube_link', models.CharField(blank=True, max_length=512, null=True)),
                ('collection', models.ForeignKey(default=wagtail.core.models.get_root_collection_id, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='wagtailcore.Collection', verbose_name='collection')),
                ('tags', taggit.managers.TaggableManager(blank=True, help_text=None, through='taggit.TaggedItem', to='taggit.Tag', verbose_name='tags')),
                ('uploaded_by_user', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='uploaded by user')),
                ('feature_in_homepage', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
                'verbose_name': 'media',
            },
            bases=(wagtail.search.index.Indexed, models.Model),
        ),
        migrations.AlterField(
            model_name='articlepage',
            name='body',
            field=wagtail.core.fields.StreamField(((b'heading', wagtail.core.blocks.CharBlock(classname=b'full title')), (b'paragraph', molo.core.blocks.MarkDownBlock()), (b'image', wagtail.images.blocks.ImageChooserBlock()), (b'list', wagtail.core.blocks.ListBlock(wagtail.core.blocks.CharBlock(label=b'Item'))), (b'numbered_list', wagtail.core.blocks.ListBlock(wagtail.core.blocks.CharBlock(label=b'Item'))), (b'page', wagtail.core.blocks.PageChooserBlock()), (b'media', molo.core.models.MoloMediaBlock(icon=b'media'))), blank=True, null=True),
        ),
        migrations.RunPython(convert_media_to_molo_media),
        migrations.CreateModel(
            name='ImageInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image_hash', models.CharField(max_length=256, null=True)),
                ('image', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_info', to='wagtailimages.Image')),
            ],
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='enable_service_directory',
            field=models.BooleanField(default=False, verbose_name=b'Enable service directory'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='google_places_api_server_key',
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name='google places server key'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='service_directory_api_base_url',
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name='service directory base url'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='service_directory_api_password',
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name='service directory password'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='service_directory_api_username',
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name='service directory username'),
        ),
        migrations.RunPython(delete_imageinfo),
        migrations.AddField(
            model_name='sitesettings',
            name='fb_analytics_app_id',
            field=models.CharField(blank=True, help_text='The tracking ID to be used to view Facebook Analytics', max_length=25, null=True, verbose_name='Facebook Analytics App ID'),
        ),
        migrations.RunPython(run_wagtail_migration_before_core_34),
        migrations.AddField(
            model_name='bannerpage',
            name='subtitle',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='sitelanguage',
            name='locale',
            field=models.CharField(choices=[('af', 'Afrikaans'), ('ar', 'Arabic'), ('ast', 'Asturian'), ('az', 'Azerbaijani'), ('bg', 'Bulgarian'), ('be', 'Belarusian'), ('bn', 'Bengali'), ('br', 'Breton'), ('bs', 'Bosnian'), ('ca', 'Catalan'), ('cs', 'Czech'), ('cy', 'Welsh'), ('da', 'Danish'), ('de', 'German'), ('dsb', 'Lower Sorbian'), ('el', 'Greek'), ('en', 'English'), ('en-au', 'Australian English'), ('en-gb', 'British English'), ('eo', 'Esperanto'), ('es', 'Spanish'), ('es-ar', 'Argentinian Spanish'), ('es-co', 'Colombian Spanish'), ('es-mx', 'Mexican Spanish'), ('es-ni', 'Nicaraguan Spanish'), ('es-ve', 'Venezuelan Spanish'), ('et', 'Estonian'), ('eu', 'Basque'), ('fa', 'Persian'), ('fi', 'Finnish'), ('fr', 'French'), ('fy', 'Frisian'), ('ga', 'Irish'), ('gd', 'Scottish Gaelic'), ('gl', 'Galician'), ('he', 'Hebrew'), ('hi', 'Hindi'), ('hr', 'Croatian'), ('hsb', 'Upper Sorbian'), ('hu', 'Hungarian'), ('ia', 'Interlingua'), ('id', 'Indonesian'), ('io', 'Ido'), ('is', 'Icelandic'), ('it', 'Italian'), ('ja', 'Japanese'), ('ka', 'Georgian'), ('kk', 'Kazakh'), ('km', 'Khmer'), ('kn', 'Kannada'), ('ko', 'Korean'), ('lb', 'Luxembourgish'), ('lt', 'Lithuanian'), ('lv', 'Latvian'), ('mk', 'Macedonian'), ('ml', 'Malayalam'), ('mn', 'Mongolian'), ('mr', 'Marathi'), ('my', 'Burmese'), ('nb', 'Norwegian Bokmål'), ('ne', 'Nepali'), ('nl', 'Dutch'), ('nn', 'Norwegian Nynorsk'), ('os', 'Ossetic'), ('pa', 'Punjabi'), ('pl', 'Polish'), ('pt', 'Portuguese'), ('pt-br', 'Brazilian Portuguese'), ('ro', 'Romanian'), ('ru', 'Russian'), ('sk', 'Slovak'), ('sl', 'Slovenian'), ('sq', 'Albanian'), ('sr', 'Serbian'), ('sr-latn', 'Serbian Latin'), ('sv', 'Swedish'), ('sw', 'Swahili'), ('ta', 'Tamil'), ('te', 'Telugu'), ('th', 'Thai'), ('tr', 'Turkish'), ('tt', 'Tatar'), ('udm', 'Udmurt'), ('uk', 'Ukrainian'), ('ur', 'Urdu'), ('vi', 'Vietnamese'), ('zh-hans', 'Simplified Chinese'), ('zh-hant', 'Traditional Chinese'), (b'zu', 'Zulu'), (b'xh', 'Xhosa'), (b'st', 'Sotho'), (b've', 'Venda'), (b'tn', 'Tswana'), (b'ts', 'Tsonga'), (b'ss', 'Swati'), (b'nr', 'Ndebele')], help_text='Site language', max_length=255, verbose_name='language name'),
        ),
        migrations.CreateModel(
            name='Timezone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, unique=True)),
            ],
        ),
        migrations.RunPython(seed_timezones, delete_timezones),
        migrations.CreateModel(
            name='CmsSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
                ('timezone', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='core.Timezone')),
            ],
            options={
                'verbose_name': 'CMS settings',
            },
        ),
        migrations.RunPython(set_initial_timezone, unset_timezone),
        migrations.CreateModel(
            name='MoloPage',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('wagtailcore.page',),
        ),
    ]
