# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2017-12-20 11:48
from __future__ import unicode_literals

from django.db import migrations, models

from molo.core.models import Timezone

from pytz import common_timezones


def seed_timezones(apps, schema_editor):
    for timezone_title in common_timezones:
        timezone = Timezone.objects.create(title=timezone_title)
        timezone.save()


def delete_timezones(apps, schema_editor):
    Timezone.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0074_banner_subtitle'),
    ]

    operations = [
        migrations.CreateModel(
            name='Timezone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, unique=True)),
            ],
        ),
        migrations.RunPython(seed_timezones, delete_timezones),
    ]
