# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-02-13 07:27
from __future__ import unicode_literals

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import phonenumber_field.modelfields
import uuid


# Functions from the following migrations need manual copying.
# Move them and any dependencies into this file, then update the
# RunPython operations to refer to the local versions:
# molo.profiles.migrations.0010_create_security_question_index_page
def create_section_index(apps, schema_editor):
    from molo.core.models import Main
    from molo.profiles.models import SecurityQuestionIndexPage
    main = Main.objects.all().first()
    index_page = SecurityQuestionIndexPage.objects.filter(
        slug='security-questions').first()

    if main and not index_page:
        index_page = SecurityQuestionIndexPage(
            title='Security Questions', slug='security-questions')
        main.add_child(instance=index_page)
        index_page.save_revision().publish()


# molo.profiles.migrations.0015_add_curent_site_to_user_profile
def add_site_to_user_profile(apps, schema_editor):
    UserProfile = apps.get_model("profiles", "UserProfile")
    Site = apps.get_model("wagtailcore", "Site")
    site = Site.objects.all().first()
    if site:
        UserProfile.objects.all().update(site=site)


# molo.profiles.migrations.0020_populate_uuid_values
def create_uuid(apps, schema_editor):
    UserProfile = apps.get_model('profiles', 'UserProfile')
    for user in UserProfile.objects.all():
        user.uuid = uuid.uuid4()
        user.save(update_fields=['uuid'])


class Migration(migrations.Migration):

    replaces = [
        ('profiles', '0001_initial'),
        ('profiles', '0002_add_mobile_number_field'),
        ('profiles', '0003_add_email_field'),
        ('profiles', '0004_add_profile_settings'),
        ('profiles', '0005_add_security_questions_model'),
        ('profiles', '0006_add_show_security_question_field'),
        ('profiles', '0007_add_password_recovery_retries'),
        ('profiles', '0008_change_num_security_questions_default'),
        ('profiles', '0009_add_security_question_index_page'),
        ('profiles', '0010_create_security_question_index_page'),
        ('profiles', '0011_country_code'),
        ('profiles', '0012_userprofilessettings_terms_and_conditions'),
        ('profiles', '0013_add_location_gender_education_level_fields'),
        ('profiles', '0014_add_site_to_profile'),
        ('profiles', '0015_add_curent_site_to_user_profile'),
        ('profiles', '0016_add_registration_token'),
        ('profiles', '0017_userprofile_migrated_username'),
        ('profiles', '0018_userprofile_admin_sites'),
        ('profiles', '0019_add_uuid_field'),
        ('profiles', '0020_populate_uuid_values'),
        ('profiles', '0021_remove_uuid_null')
    ]

    initial = True

    dependencies = [
        ('auth', '0006_require_contenttypes_0002'),
        ('wagtailcore', '__latest__'),
        ('wagtailcore', '0023_alter_page_revision_on_delete_behaviour'),
        ('wagtailcore', '0028_merge'),
        ('wagtailcore', '0032_add_bulk_delete_page_permission'),
    ]

    operations = [
        migrations.CreateModel(
            name='UserProfile',
            fields=[
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='profile', serialize=False, to=settings.AUTH_USER_MODEL)),
                ('date_of_birth', models.DateField(null=True)),
                ('alias', models.CharField(blank=True, max_length=128, null=True)),
                ('avatar', models.ImageField(blank=True, null=True, upload_to=b'users/profile', verbose_name=b'avatar')),
                ('mobile_number', phonenumber_field.modelfields.PhoneNumberField(blank=True, max_length=128, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='UserProfilesSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('show_mobile_number_field', models.BooleanField(default=False, verbose_name='Add mobile number field to registration')),
                ('mobile_number_required', models.BooleanField(default=False, verbose_name='Mobile number required')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
                ('email_required', models.BooleanField(default=False, verbose_name='Email required')),
                ('show_email_field', models.BooleanField(default=False, verbose_name='Add email field to registration')),
                ('prevent_email_in_username', models.BooleanField(default=False, verbose_name='Prevent email in username / display name')),
                ('prevent_phone_number_in_username', models.BooleanField(default=False, verbose_name='Prevent phone number in username / display name')),
                ('security_questions_required', models.BooleanField(default=False, verbose_name='Security questions required')),
                ('show_security_question_fields', models.BooleanField(default=False, verbose_name='Add security question fields to registration')),
                ('num_security_questions', models.PositiveSmallIntegerField(default=1, verbose_name='Number of security questions asked for password recovery')),
                ('password_recovery_retries', models.PositiveSmallIntegerField(default=5, verbose_name='Max number of password recovery retries before lockout')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SecurityAnswer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('answer', models.CharField(max_length=150)),
            ],
        ),
        migrations.CreateModel(
            name='SecurityQuestion',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page'))
            ],
            options={
                'verbose_name': 'Security Question',
            },
        ),
        migrations.AddField(
            model_name='securityanswer',
            name='question',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='profiles.SecurityQuestion'),
        ),
        migrations.AddField(
            model_name='securityanswer',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='profiles.UserProfile'),
        ),
        migrations.AddField(
            model_name='userprofile',
            name='security_question_answers',
            field=models.ManyToManyField(through='profiles.SecurityAnswer', to='profiles.SecurityQuestion'),
        ),
        migrations.CreateModel(
            name='SecurityQuestionIndexPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page',),
        ),
        migrations.RunPython(create_section_index),
        migrations.AddField(
            model_name='userprofilessettings',
            name='country_code',
            field=models.CharField(blank=True, help_text='For example: +27 for South Africa, +44 for England', max_length=4, null=True, verbose_name="The country code that should be added to a user's number for this site"),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='terms_and_conditions',
            field=models.ForeignKey(blank=True, help_text='Choose a footer page', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page'),
        ),
        migrations.AddField(
            model_name='userprofile',
            name='education_level',
            field=models.CharField(blank=True, max_length=128, null=True),
        ),
        migrations.AddField(
            model_name='userprofile',
            name='gender',
            field=models.CharField(blank=True, max_length=128, null=True),
        ),
        migrations.AddField(
            model_name='userprofile',
            name='location',
            field=models.CharField(blank=True, max_length=128, null=True),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='activate_display_name',
            field=models.BooleanField(default=True, verbose_name='Activate Display Name'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='activate_dob',
            field=models.BooleanField(default=True, verbose_name='Activate Date Of Birth'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='activate_education_level',
            field=models.BooleanField(default=False, verbose_name='Activate Education Level'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='activate_education_level_required',
            field=models.BooleanField(default=False, verbose_name='Education Level Required'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='activate_gender',
            field=models.BooleanField(default=False, verbose_name='Activate Gender'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='activate_location',
            field=models.BooleanField(default=False, verbose_name='Activate Location'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='capture_display_name_on_reg',
            field=models.BooleanField(default=False, help_text='If Display Name is activated, and Capture On Registration is not activated, The display name field will be captured on done page.', verbose_name='Capture On Registration'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='capture_dob_on_reg',
            field=models.BooleanField(default=False, help_text='If Date Of Birth is activated, and Capture On Registration is not activated, The Date Of Birth field will be captured on done page.', verbose_name='Capture On Registration'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='capture_education_level_on_reg',
            field=models.BooleanField(default=False, help_text='If Education Level is activated, and Capture On Registration is not activated, The Education Level field will be captured on done page.', verbose_name='Capture On Registration'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='capture_gender_on_reg',
            field=models.BooleanField(default=False, help_text='If Gender is activated, and Capture On Registration is not activated, The Gender field will be captured on done page.', verbose_name='Capture On Registration'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='capture_location_on_reg',
            field=models.BooleanField(default=False, help_text='If Location is activated, and Capture On Registration is not activated, The Location field will be captured on done page.', verbose_name='Capture On Registration'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='display_name_required',
            field=models.BooleanField(default=False, verbose_name='Display Name Required'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='dob_required',
            field=models.BooleanField(default=False, verbose_name='Date Of Birth Required'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='gender_required',
            field=models.BooleanField(default=False, verbose_name='Gender Required'),
        ),
        migrations.AddField(
            model_name='userprofilessettings',
            name='location_required',
            field=models.BooleanField(default=False, verbose_name='Location Required'),
        ),
        migrations.AddField(
            model_name='userprofile',
            name='site',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site'),
        ),
        migrations.RunPython(add_site_to_user_profile),
        migrations.AddField(
            model_name='userprofile',
            name='fcm_registration_token',
            field=models.CharField(max_length=256, null=True),
        ),
        migrations.AddField(
            model_name='userprofile',
            name='migrated_username',
            field=models.CharField(blank=True, max_length=40, null=True, validators=[django.core.validators.RegexValidator(b'^[\\w.@+-]+$', 'Enter a valid username. This value may contain only letters, numbers and @/./+/-/_ characters.')], verbose_name='migrated_username'),
        ),
        migrations.AddField(
            model_name='userprofile',
            name='admin_sites',
            field=models.ManyToManyField(related_name='admin_sites', to='wagtailcore.Site'),
        ),
        migrations.AddField(
            model_name='userprofile',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, null=True),
        ),
        migrations.RunPython(create_uuid),
        migrations.AlterField(
            model_name='userprofile',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, unique=True),
        ),
    ]
