# DO NOT CHANGE ANY CODE BELOW
# This file is generated automatically by `generate_api_schema.py` and will be overwritten
# Instead, change functions / models by subclassing them in the `./overwrites/` folder. They will be used instead.

from datetime import datetime
from typing import TYPE_CHECKING, Union

import attr

from bungio.models.base import BaseEnum, BaseFlagEnum, BaseModel
from bungio.utils import enum_converter

if TYPE_CHECKING:
    from bungio.models import UserInfoCard


class ApplicationScopes(BaseFlagEnum):
    """
    _No description given by bungie._
    """

    READ_BASIC_USER_PROFILE = 1
    """Read basic user profile information such as the user's handle, avatar icon, etc. """
    READ_GROUPS = 2
    """Read Group/Clan Forums, Wall, and Members for groups and clans that the user has joined. """
    WRITE_GROUPS = 4
    """Write Group/Clan Forums, Wall, and Members for groups and clans that the user has joined. """
    ADMIN_GROUPS = 8
    """Administer Group/Clan Forums, Wall, and Members for groups and clans that the user is a founder or an administrator. """
    BNET_WRITE = 16
    """Create new groups, clans, and forum posts, along with other actions that are reserved for Bungie.net elevated scope: not meant to be used by third party applications. """
    MOVE_EQUIP_DESTINY_ITEMS = 32
    """Move or equip Destiny items """
    READ_DESTINY_INVENTORY_AND_VAULT = 64
    """Read Destiny 1 Inventory and Vault contents. For Destiny 2, this scope is needed to read anything regarded as private. This is the only scope a Destiny 2 app needs for read operations against Destiny 2 data such as inventory, vault, currency, vendors, milestones, progression, etc. """
    READ_USER_DATA = 128
    """Read user data such as who they are web notifications, clan/group memberships, recent activity, muted users. """
    EDIT_USER_DATA = 256
    """Edit user data such as preferred language, status, motto, avatar selection and theme. """
    READ_DESTINY_VENDORS_AND_ADVISORS = 512
    """Access vendor and advisor data specific to a user. OBSOLETE. This scope is only used on the Destiny 1 API. """
    READ_AND_APPLY_TOKENS = 1024
    """Read offer history and claim and apply tokens for the user. """
    ADVANCED_WRITE_ACTIONS = 2048
    """Can perform actions that will result in a prompt to the user via the Destiny app. """
    PARTNER_OFFER_GRANT = 4096
    """Can user the partner offer api to claim rewards defined for a partner """
    DESTINY_UNLOCK_VALUE_QUERY = 8192
    """Allows an app to query sensitive information like unlock flags and values not available through normal methods. """
    USER_PII_READ = 16384
    """Allows an app to query sensitive user PII, most notably email information. """


@attr.define
class ApiUsage(BaseModel):
    """
    _No description given by bungie._

    None
    Attributes:
        api_calls: Counts for on API calls made for the time range.
        throttled_requests: Instances of blocked requests or requests that crossed the warn threshold during the time range.
    """

    api_calls: list["Series"] = attr.field(metadata={"type": """list[Series]"""})
    throttled_requests: list["Series"] = attr.field(metadata={"type": """list[Series]"""})


@attr.define
class Series(BaseModel):
    """
    _No description given by bungie._

    None
    Attributes:
        datapoints: Collection of samples with time and value.
        target: Target to which to datapoints apply.
    """

    datapoints: list["Datapoint"] = attr.field(metadata={"type": """list[Datapoint]"""})
    target: str = attr.field()


@attr.define
class Datapoint(BaseModel):
    """
    _No description given by bungie._

    None
    Attributes:
        count: Count associated with timestamp
        time: Timestamp for the related count.
    """

    count: float = attr.field()
    time: datetime = attr.field()


@attr.define
class Application(BaseModel):
    """
    _No description given by bungie._

    None
    Attributes:
        application_id: Unique ID assigned to the application
        creation_date: Date the application was first added to our database.
        first_published: Date the first time the application status entered the 'Public' status.
        link: Link to website for the application where a user can learn more about the app.
        name: Name of the application
        origin: Value of the Origin header sent in requests generated by this application.
        override_authorize_view_name: An optional override for the Authorize view name.
        redirect_url: URL used to pass the user's authorization code to the application
        scope: Permissions the application needs to work
        status: Current status of the application.
        status_changed: Date the application status last changed.
        team: List of team members who manage this application on Bungie.net. Will always consist of at least the application owner.
    """

    application_id: int = attr.field()
    creation_date: datetime = attr.field()
    first_published: datetime = attr.field()
    link: str = attr.field()
    name: str = attr.field()
    origin: str = attr.field()
    override_authorize_view_name: str = attr.field()
    redirect_url: str = attr.field()
    scope: int = attr.field()
    status: Union["ApplicationStatus", int] = attr.field(converter=enum_converter("ApplicationStatus"))
    status_changed: datetime = attr.field()
    team: list["ApplicationDeveloper"] = attr.field(metadata={"type": """list[ApplicationDeveloper]"""})


class ApplicationStatus(BaseEnum):
    """
    _No description given by bungie._
    """

    NONE = 0
    """No value assigned """
    PRIVATE = 1
    """Application exists and works but will not appear in any public catalog. New applications start in this state, test applications will remain in this state. """
    PUBLIC = 2
    """Active applications that can appear in an catalog. """
    DISABLED = 3
    """Application disabled by the owner. All authorizations will be treated as terminated while in this state. Owner can move back to private or public state. """
    BLOCKED = 4
    """Application has been blocked by Bungie. It cannot be transitioned out of this state by the owner. Authorizations are terminated when an application is in this state. """


@attr.define
class ApplicationDeveloper(BaseModel):
    """
    _No description given by bungie._

    None
    Attributes:
        api_eula_version: _No description given by bungie._
        role: _No description given by bungie._
        user: _No description given by bungie._
    """

    api_eula_version: int = attr.field()
    role: Union["DeveloperRole", int] = attr.field(converter=enum_converter("DeveloperRole"))
    user: "UserInfoCard" = attr.field()


class DeveloperRole(BaseEnum):
    """
    _No description given by bungie._
    """

    NONE = 0
    """_No description given by bungie._ """
    OWNER = 1
    """_No description given by bungie._ """
    TEAM_MEMBER = 2
    """_No description given by bungie._ """
