"""
A utility to process Rigol oscilloscope wfm files (DHO800 series focus).

Fork of scottprahl/RigolWFM by ai.moda focused on DHO800 series support.
Original documentation: <https://RigolWFM.readthedocs.io>

    Example:
    >>> import matplotlib.pyplot as plt
    >>> import RigolWFM.wfm as rigol

    >>> filename = 'example.wfm'
    >>> scope = 'DS1000E'

    >>> w = rigol.Wfm.from_file(filename, scope)
    >>> w.plot()
    >>> plt.show()

Info waveform class::

    help(rigol.wfm)

Info about channel class::

    help(rigol.channel)

All the parsing code is auto-generated by `kaitai-struct-compiler`
based on `.ksy` files that describe the binary format of the Rigol
oscilloscope `.wfm` files.
"""
from RigolWFM._version import __version__

__author__ = 'Scott Prahl, ai.moda (DHO800 fork)'
__email__ = 'scott.prahl@oit.edu'
__copyright__ = '2020-23 Scott Prahl, 2024-25 ai.moda'
__license__ = 'BSD 3-clause'
__url__ = 'https://github.com/aimoda/rigolwfm-dho800'
