/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as dynamodb from 'aws-cdk-lib/aws-dynamodb';
import { Construct } from 'constructs';
export interface BuildDynamoDBTableProps {
    /**
     * Optional user provided props to override the default props
     *
     * @default - Default props are used
     */
    readonly dynamoTableProps?: dynamodb.TableProps;
    /**
     * Existing instance of dynamodb table object.
     * Providing both this and `dynamoTableProps` will cause an error.
     *
     * @default - None
     */
    readonly existingTableObj?: dynamodb.Table;
    /**
     * Existing instance of dynamodb interface.
     * Providing both this and `dynamoTableProps` will cause an error.
     *
     * @default - None
     */
    readonly existingTableInterface?: dynamodb.ITable;
}
export interface BuildDynamoDBTableWithStreamProps {
    /**
     * Optional user provided props to override the default props
     *
     * @default - Default props are used
     */
    readonly dynamoTableProps?: dynamodb.TableProps;
    /**
     * Existing instance of dynamodb table object.
     * Providing both this and `dynamoTableProps` will cause an error.
     *
     * @default - None
     */
    readonly existingTableInterface?: dynamodb.ITable;
}
export declare function buildDynamoDBTable(scope: Construct, props: BuildDynamoDBTableProps): [dynamodb.ITable, dynamodb.Table?];
export declare function checkTableProps(props: BuildDynamoDBTableProps): void;
export declare function buildDynamoDBTableWithStream(scope: Construct, props: BuildDynamoDBTableWithStreamProps): [dynamodb.ITable, dynamodb.Table?];
export declare function getPartitionKeyNameFromTable(table: dynamodb.Table): string;
