/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { Construct } from 'constructs';
import { DynamoEventSourceProps, S3EventSourceProps, KinesisEventSourceProps, StreamEventSourceProps } from 'aws-cdk-lib/aws-lambda-event-sources';
import * as sqs from 'aws-cdk-lib/aws-sqs';
export interface EventSourceProps {
    readonly eventSourceProps?: StreamEventSourceProps;
    readonly deploySqsDlqQueue?: boolean;
    readonly sqsDlqQueueProps?: sqs.QueueProps;
}
export declare function DynamoEventSourceProps(scope: Construct, _dynamoEventSourceProps?: EventSourceProps): DynamoEventSourceProps;
export declare function S3EventSourceProps(_s3EventSourceProps?: S3EventSourceProps): any;
export declare function KinesisEventSourceProps(scope: Construct, _kinesisEventSourceProps?: EventSourceProps): KinesisEventSourceProps;
