"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisEventSourceProps = exports.S3EventSourceProps = exports.DynamoEventSourceProps = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
const utils_1 = require("./utils");
const aws_lambda_event_sources_1 = require("aws-cdk-lib/aws-lambda-event-sources");
const s3 = require("aws-cdk-lib/aws-s3");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const sqs_helper_1 = require("./sqs-helper");
function DynamoEventSourceProps(scope, _dynamoEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: aws_cdk_lib_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_dynamoEventSourceProps === undefined || _dynamoEventSourceProps?.deploySqsDlqQueue === undefined
        || _dynamoEventSourceProps.deploySqsDlqQueue) {
        const [sqsQueue] = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _dynamoEventSourceProps?.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(sqsQueue),
        };
    }
    const defaultDynamoEventSourceProps = Object.assign(baseProps, extraProps);
    return utils_1.consolidateProps(defaultDynamoEventSourceProps, _dynamoEventSourceProps?.eventSourceProps);
}
exports.DynamoEventSourceProps = DynamoEventSourceProps;
function S3EventSourceProps(_s3EventSourceProps) {
    const defaultS3EventSourceProps = {
        events: [s3.EventType.OBJECT_CREATED]
    };
    return utils_1.consolidateProps(defaultS3EventSourceProps, _s3EventSourceProps);
}
exports.S3EventSourceProps = S3EventSourceProps;
function KinesisEventSourceProps(scope, _kinesisEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: aws_cdk_lib_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_kinesisEventSourceProps === undefined || _kinesisEventSourceProps?.deploySqsDlqQueue === undefined
        || _kinesisEventSourceProps.deploySqsDlqQueue) {
        const [sqsQueue] = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _kinesisEventSourceProps?.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(sqsQueue),
        };
    }
    const defaultKinesisEventSourceProps = Object.assign(baseProps, extraProps);
    return utils_1.consolidateProps(defaultKinesisEventSourceProps, _kinesisEventSourceProps?.eventSourceProps);
}
exports.KinesisEventSourceProps = KinesisEventSourceProps;
//# sourceMappingURL=data:application/json;base64,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