# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MeasureVariable(Model):
    """Represents a variable (computed column) in a measure.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param kind: Possible values include: 'arithmetic', 'date'
    :type kind: str or ~dynamics.customerinsights.api.models.enum
    :ivar name: Gets the name of the variable
    :vartype name: str
    :ivar data_type: Gets the data type of the variable
    :vartype data_type: str
    :ivar expression_text: Gets the expression text for computing the variable
    :vartype expression_text: str
    :ivar variable_condition_groups: Gets the variable conditions
    :vartype variable_condition_groups:
     list[~dynamics.customerinsights.api.models.MeasureVariableConditionGroup]
    """

    _validation = {
        'name': {'readonly': True},
        'data_type': {'readonly': True},
        'expression_text': {'readonly': True},
        'variable_condition_groups': {'readonly': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'expression_text': {'key': 'expressionText', 'type': 'str'},
        'variable_condition_groups': {'key': 'variableConditionGroups', 'type': '[MeasureVariableConditionGroup]'},
    }

    def __init__(self, **kwargs):
        super(MeasureVariable, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.name = None
        self.data_type = None
        self.expression_text = None
        self.variable_condition_groups = None
