# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SegmentMetadata(Model):
    """Represents a Segment Metadata.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name: Gets the unique name of the segment
    :type name: str
    :param friendly_name: Gets the friendlyName of the segment.
    :type friendly_name: str
    :param description: Gets the description of the segment.
    :type description: str
    :param segment_query_expression:
    :type segment_query_expression:
     ~dynamics.customerinsights.api.models.SegmentationQuery
    :param state: Possible values include: 'inactive', 'active', 'validating',
     'validated', 'invalid', 'validationError'
    :type state: str or ~dynamics.customerinsights.api.models.enum
    :param error_description: Gets the error description when the segment
     metadata has some issues after refresh.
    :type error_description: str
    :param end_date: Gets the end date of the segment.
    :type end_date: datetime
    :param evaluation_status:
    :type evaluation_status:
     ~dynamics.customerinsights.api.models.SegmentationPublishStats
    :param sql_validation_stats:
    :type sql_validation_stats:
     ~dynamics.customerinsights.api.models.SqlValidationStats
    :param evaluation_status_history: Gets the segment evaluation status
     history. (not persisted in store)
    :type evaluation_status_history:
     list[~dynamics.customerinsights.api.models.HistoricalSegmentStats]
    :ivar version: Gets the version number of this object.
    :vartype version: long
    :ivar updated_by: Gets the UPN of the user who last updated this record.
    :vartype updated_by: str
    :ivar updated_utc: Gets the time the object was last updated.
    :vartype updated_utc: datetime
    :ivar created_by: Gets the email address of the user who created this
     record.
    :vartype created_by: str
    :ivar created_utc: Gets the time the object was initially created.
    :vartype created_utc: datetime
    :ivar instance_id: Gets the Customer Insights instance id associated with
     this object.
    :vartype instance_id: str
    """

    _validation = {
        'version': {'readonly': True},
        'updated_by': {'readonly': True},
        'updated_utc': {'readonly': True},
        'created_by': {'readonly': True},
        'created_utc': {'readonly': True},
        'instance_id': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'segment_query_expression': {'key': 'segmentQueryExpression', 'type': 'SegmentationQuery'},
        'state': {'key': 'state', 'type': 'str'},
        'error_description': {'key': 'errorDescription', 'type': 'str'},
        'end_date': {'key': 'endDate', 'type': 'iso-8601'},
        'evaluation_status': {'key': 'evaluationStatus', 'type': 'SegmentationPublishStats'},
        'sql_validation_stats': {'key': 'sqlValidationStats', 'type': 'SqlValidationStats'},
        'evaluation_status_history': {'key': 'evaluationStatusHistory', 'type': '[HistoricalSegmentStats]'},
        'version': {'key': 'version', 'type': 'long'},
        'updated_by': {'key': 'updatedBy', 'type': 'str'},
        'updated_utc': {'key': 'updatedUtc', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_utc': {'key': 'createdUtc', 'type': 'iso-8601'},
        'instance_id': {'key': 'instanceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SegmentMetadata, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.description = kwargs.get('description', None)
        self.segment_query_expression = kwargs.get('segment_query_expression', None)
        self.state = kwargs.get('state', None)
        self.error_description = kwargs.get('error_description', None)
        self.end_date = kwargs.get('end_date', None)
        self.evaluation_status = kwargs.get('evaluation_status', None)
        self.sql_validation_stats = kwargs.get('sql_validation_stats', None)
        self.evaluation_status_history = kwargs.get('evaluation_status_history', None)
        self.version = None
        self.updated_by = None
        self.updated_utc = None
        self.created_by = None
        self.created_utc = None
        self.instance_id = None
