# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class WorkflowRefreshSchedule(Model):
    """Represents a DAG refresh schedule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param operation_type: Possible values include: 'none', 'ingestion',
     'derivedEntity', 'dataPreparation', 'map', 'match', 'merge',
     'profileStore', 'search', 'activity', 'attributeMeasures',
     'entityMeasures', 'measures', 'segmentation', 'enrichment',
     'intelligence', 'aiBuilder', 'insights', 'export', 'modelManagement',
     'relationship', 'roleAssignment', 'analysis', 'all'
    :type operation_type: str or ~dynamics.customerinsights.api.models.enum
    :param sub_type: Possible values include: 'templatedMeasures',
     'createAnalysisModel', 'linkAnalysisModel'
    :type sub_type: str or ~dynamics.customerinsights.api.models.enum
    :param identifiers: Gets the identifiers of the schedule
    :type identifiers: list[str]
    :param job_type: Possible values include: 'full', 'incremental'
    :type job_type: str or ~dynamics.customerinsights.api.models.enum
    :ivar is_active: Gets a value indicating whether the schedule is active.
    :vartype is_active: bool
    :ivar timezone_id: Gets the ID of the timezone
    :vartype timezone_id: str
    :ivar cron_schedules: Gets the schedule in CRON format
    :vartype cron_schedules: list[str]
    :ivar schedule_id: Gets the ID of the schedule
    :vartype schedule_id: str
    :ivar instance_id: Gets the Customer Insights instance id associated with
     this object.
    :vartype instance_id: str
    """

    _validation = {
        'is_active': {'readonly': True},
        'timezone_id': {'readonly': True},
        'cron_schedules': {'readonly': True},
        'schedule_id': {'readonly': True},
        'instance_id': {'readonly': True},
    }

    _attribute_map = {
        'operation_type': {'key': 'operationType', 'type': 'str'},
        'sub_type': {'key': 'subType', 'type': 'str'},
        'identifiers': {'key': 'identifiers', 'type': '[str]'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'is_active': {'key': 'isActive', 'type': 'bool'},
        'timezone_id': {'key': 'timezoneId', 'type': 'str'},
        'cron_schedules': {'key': 'cronSchedules', 'type': '[str]'},
        'schedule_id': {'key': 'scheduleId', 'type': 'str'},
        'instance_id': {'key': 'instanceId', 'type': 'str'},
    }

    def __init__(self, *, operation_type=None, sub_type=None, identifiers=None, job_type=None, **kwargs) -> None:
        super(WorkflowRefreshSchedule, self).__init__(**kwargs)
        self.operation_type = operation_type
        self.sub_type = sub_type
        self.identifiers = identifiers
        self.job_type = job_type
        self.is_active = None
        self.timezone_id = None
        self.cron_schedules = None
        self.schedule_id = None
        self.instance_id = None
