# AUTOGENERATED - modify shared_anyscale_util in root directory to make changes
from enum import Enum


"""
Headers used within Anyscale
"""


class RequestHeaders(str, Enum):
    """
    Request headers, set by the client.
    """

    # Standardized authorization header
    # https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Authorization
    AUTHORIZATION = "Authorization"

    # Identifies type of client (Web, SDK, CLI, etc.)
    CLIENT = "X-Anyscale-Client"

    # Identifies the version of the client
    CLIENT_VERSION = "X-Anyscale-Client-Version"


class ResponseHeaders(str, Enum):
    """
    Response headers, set by our server.
    """

    # Identifies a tenant for observability, used for authenticating requests to Cortex
    TENANT_ID = "X-Anyscale-Tenant-Id"

    # Identifies a user in Grafana, used for authenticating user requests to Grafana
    GRAFANA_USER_ID = "X-Anyscale-Grafana-User-Id"
